/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.baseutil.reflect;

import com.jfirer.baseutil.reflect.ReflectUtil;
import com.jfirer.baseutil.reflect.UNSAFE;
import com.jfirer.baseutil.smc.SmcHelper;
import com.jfirer.baseutil.smc.compiler.CompileHelper;
import com.jfirer.baseutil.smc.model.ClassModel;
import com.jfirer.baseutil.smc.model.MethodModel;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;

public class ValueAccessor {
    private static final int _UNSAFE = 0;
    private static final int _FIELD = 1;
    private static final int INT = 1;
    private static final int BYTE = 2;
    private static final int CHAR = 3;
    private static final int BOOLEAN = 4;
    private static final int SHORT = 5;
    private static final int LONG = 6;
    private static final int FLOAT = 7;
    private static final int DOUBLE = 8;
    private static final AtomicInteger count = new AtomicInteger();
    private final int accessType;
    private Field field;
    private long offset;
    private boolean primitive;
    private int primitiveType = 0;

    public ValueAccessor() {
        this.accessType = Integer.MIN_VALUE;
    }

    public ValueAccessor(Field field) {
        this.field = field;
        this.primitive = field.getType().isPrimitive();
        int n = this.accessType = UNSAFE.isAvailable() ? 0 : 1;
        if (this.accessType == 0) {
            this.offset = UNSAFE.objectFieldOffset(field);
        } else {
            field.setAccessible(true);
        }
        if (this.primitive) {
            Class<?> type = field.getType();
            if (type == Integer.TYPE) {
                this.primitiveType = 1;
            } else if (type == Short.TYPE) {
                this.primitiveType = 5;
            } else if (type == Long.TYPE) {
                this.primitiveType = 6;
            } else if (type == Float.TYPE) {
                this.primitiveType = 7;
            } else if (type == Double.TYPE) {
                this.primitiveType = 8;
            } else if (type == Boolean.TYPE) {
                this.primitiveType = 4;
            } else if (type == Byte.TYPE) {
                this.primitiveType = 2;
            } else if (type == Character.TYPE) {
                this.primitiveType = 3;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    static String toMethodName(Field field) {
        return field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
    }

    public static ValueAccessor create(Field field, CompileHelper compileHelper) {
        ClassModel classModel = new ClassModel("ValueAccessor_" + field.getName() + "_" + count.getAndIncrement(), ValueAccessor.class, new Class[0]);
        Class<?> type = field.getType();
        if (type == Integer.TYPE || type == Integer.class) {
            return ValueAccessor.build(field, compileHelper, classModel, "getInt", Integer.TYPE, Integer.class);
        }
        if (type == Short.TYPE || type == Short.class) {
            return ValueAccessor.build(field, compileHelper, classModel, "getShort", Short.TYPE, Short.class);
        }
        if (type == Long.TYPE || type == Long.class) {
            return ValueAccessor.build(field, compileHelper, classModel, "getLong", Long.TYPE, Long.class);
        }
        if (type == Float.TYPE || type == Float.class) {
            return ValueAccessor.build(field, compileHelper, classModel, "getFloat", Float.TYPE, Float.class);
        }
        if (type == Double.TYPE || type == Double.class) {
            return ValueAccessor.build(field, compileHelper, classModel, "getDouble", Double.TYPE, Double.class);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return ValueAccessor.build(field, compileHelper, classModel, "getBoolean", Boolean.TYPE, Boolean.class);
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return ValueAccessor.build(field, compileHelper, classModel, "getByte", Byte.TYPE, Byte.class);
        }
        if (type == Character.TYPE || type == Character.class) {
            return ValueAccessor.build(field, compileHelper, classModel, "getChar", Character.TYPE, Character.class);
        }
        try {
            Method method = ValueAccessor.class.getDeclaredMethod("get", Object.class);
            MethodModel methodModel = new MethodModel(method, classModel);
            methodModel.setBody("return ((" + SmcHelper.getReferenceName(field.getDeclaringClass(), classModel) + ")$0).get" + ValueAccessor.toMethodName(field) + "();");
            classModel.putMethodModel(methodModel);
            method = ValueAccessor.class.getDeclaredMethod("setObject", Object.class, Object.class);
            methodModel = new MethodModel(method, classModel);
            methodModel.setBody("((" + SmcHelper.getReferenceName(field.getDeclaringClass(), classModel) + ")$0).set" + ValueAccessor.toMethodName(field) + "((" + SmcHelper.getReferenceName(field.getType(), classModel) + ")$1);");
            classModel.putMethodModel(methodModel);
            return (ValueAccessor)compileHelper.compile(classModel).newInstance();
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            return null;
        }
    }

    private static ValueAccessor build(Field field, CompileHelper compileHelper, ClassModel classModel, String get, Class<?> C1, Class<?> C2) {
        try {
            Method method = ValueAccessor.class.getDeclaredMethod(get, Object.class);
            MethodModel methodModel = new MethodModel(method, classModel);
            if (field.getType() != Boolean.TYPE) {
                methodModel.setBody("return ((" + SmcHelper.getReferenceName(field.getDeclaringClass(), classModel) + ")$0).get" + ValueAccessor.toMethodName(field) + "();");
            } else {
                methodModel.setBody("return ((" + SmcHelper.getReferenceName(field.getDeclaringClass(), classModel) + ")$0).is" + ValueAccessor.toMethodName(field) + "();");
            }
            classModel.putMethodModel(methodModel);
            Method getIntObject = ValueAccessor.class.getDeclaredMethod(get + "Object", Object.class);
            methodModel = new MethodModel(getIntObject, classModel);
            if (field.getType() != Boolean.TYPE) {
                methodModel.setBody("return ((" + SmcHelper.getReferenceName(field.getDeclaringClass(), classModel) + ")$0).get" + ValueAccessor.toMethodName(field) + "();");
            } else {
                methodModel.setBody("return ((" + SmcHelper.getReferenceName(field.getDeclaringClass(), classModel) + ")$0).is" + ValueAccessor.toMethodName(field) + "();");
            }
            classModel.putMethodModel(methodModel);
            method = ValueAccessor.class.getDeclaredMethod("get", Object.class);
            methodModel = new MethodModel(method, classModel);
            if (field.getType() != Boolean.TYPE) {
                methodModel.setBody("return ((" + SmcHelper.getReferenceName(field.getDeclaringClass(), classModel) + ")$0).get" + ValueAccessor.toMethodName(field) + "();");
            } else {
                methodModel.setBody("return ((" + SmcHelper.getReferenceName(field.getDeclaringClass(), classModel) + ")$0).is" + ValueAccessor.toMethodName(field) + "();");
            }
            classModel.putMethodModel(methodModel);
            method = ValueAccessor.class.getDeclaredMethod("set", Object.class, C1);
            methodModel = new MethodModel(method, classModel);
            methodModel.setBody("((" + SmcHelper.getReferenceName(field.getDeclaringClass(), classModel) + ")$0).set" + ValueAccessor.toMethodName(field) + "($1);");
            classModel.putMethodModel(methodModel);
            method = ValueAccessor.class.getDeclaredMethod("set", Object.class, C2);
            methodModel = new MethodModel(method, classModel);
            methodModel.setBody("((" + SmcHelper.getReferenceName(field.getDeclaringClass(), classModel) + ")$0).set" + ValueAccessor.toMethodName(field) + "($1);");
            classModel.putMethodModel(methodModel);
            return (ValueAccessor)compileHelper.compile(classModel).newInstance();
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            return null;
        }
    }

    public void set(Object entity, int value) {
        if (this.accessType == 0) {
            if (this.primitive) {
                UNSAFE.putInt(entity, this.offset, value);
            } else {
                UNSAFE.putObject(entity, this.offset, value);
            }
        } else {
            try {
                if (this.primitive) {
                    this.field.setInt(entity, value);
                } else {
                    this.field.set(entity, value);
                }
            }
            catch (Exception e) {
                ReflectUtil.throwException(e);
            }
        }
    }

    public void set(Object entity, Integer value) {
        if (this.accessType == 0) {
            if (this.primitive) {
                UNSAFE.putInt(entity, this.offset, value);
            } else {
                UNSAFE.putObject(entity, this.offset, value);
            }
        } else {
            try {
                if (this.primitive) {
                    this.field.setInt(entity, value);
                } else {
                    this.field.set(entity, value);
                }
            }
            catch (Exception e) {
                ReflectUtil.throwException(e);
            }
        }
    }

    public void set(Object entity, short value) {
        if (this.accessType == 0) {
            if (this.primitive) {
                UNSAFE.putShort(entity, this.offset, value);
            } else {
                UNSAFE.putObject(entity, this.offset, value);
            }
        } else {
            try {
                if (this.primitive) {
                    this.field.setShort(entity, value);
                } else {
                    this.field.set(entity, value);
                }
            }
            catch (Exception e) {
                ReflectUtil.throwException(e);
            }
        }
    }

    public void set(Object entity, Short value) {
        if (this.accessType == 0) {
            if (this.primitive) {
                UNSAFE.putShort(entity, this.offset, value);
            } else {
                UNSAFE.putObject(entity, this.offset, value);
            }
        } else {
            try {
                if (this.primitive) {
                    this.field.setShort(entity, value);
                } else {
                    this.field.set(entity, value);
                }
            }
            catch (Exception e) {
                ReflectUtil.throwException(e);
            }
        }
    }

    public void set(Object entity, long value) {
        if (this.accessType == 0) {
            if (this.primitive) {
                UNSAFE.putLong(entity, this.offset, value);
            } else {
                UNSAFE.putObject(entity, this.offset, value);
            }
        } else {
            try {
                if (this.primitive) {
                    this.field.setLong(entity, value);
                } else {
                    this.field.set(entity, value);
                }
            }
            catch (Exception e) {
                ReflectUtil.throwException(e);
            }
        }
    }

    public void set(Object entity, Long value) {
        if (this.accessType == 0) {
            if (this.primitive) {
                UNSAFE.putLong(entity, this.offset, value);
            } else {
                UNSAFE.putObject(entity, this.offset, value);
            }
        } else {
            try {
                if (this.primitive) {
                    this.field.setLong(entity, value);
                } else {
                    this.field.set(entity, value);
                }
            }
            catch (Exception e) {
                ReflectUtil.throwException(e);
            }
        }
    }

    public void set(Object entity, char value) {
        if (this.accessType == 0) {
            if (this.primitive) {
                UNSAFE.putChar(entity, this.offset, value);
            } else {
                UNSAFE.putObject(entity, this.offset, Character.valueOf(value));
            }
        } else {
            try {
                if (this.primitive) {
                    this.field.setChar(entity, value);
                } else {
                    this.field.set(entity, Character.valueOf(value));
                }
            }
            catch (Exception e) {
                ReflectUtil.throwException(e);
            }
        }
    }

    public void set(Object entity, Character value) {
        if (this.accessType == 0) {
            if (this.primitive) {
                UNSAFE.putChar(entity, this.offset, value.charValue());
            } else {
                UNSAFE.putObject(entity, this.offset, value);
            }
        } else {
            try {
                if (this.primitive) {
                    this.field.setChar(entity, value.charValue());
                } else {
                    this.field.set(entity, value);
                }
            }
            catch (Exception e) {
                ReflectUtil.throwException(e);
            }
        }
    }

    public void set(Object entity, byte value) {
        if (this.accessType == 0) {
            if (this.primitive) {
                UNSAFE.putByte(entity, this.offset, value);
            } else {
                UNSAFE.putObject(entity, this.offset, value);
            }
        } else {
            try {
                if (this.primitive) {
                    this.field.setByte(entity, value);
                } else {
                    this.field.set(entity, value);
                }
            }
            catch (Exception e) {
                ReflectUtil.throwException(e);
            }
        }
    }

    public void set(Object entity, Byte value) {
        if (this.accessType == 0) {
            if (this.primitive) {
                UNSAFE.putByte(entity, this.offset, value);
            } else {
                UNSAFE.putObject(entity, this.offset, value);
            }
        } else {
            try {
                if (this.primitive) {
                    this.field.setByte(entity, value);
                } else {
                    this.field.set(entity, value);
                }
            }
            catch (Exception e) {
                ReflectUtil.throwException(e);
            }
        }
    }

    public void set(Object entity, boolean value) {
        if (this.accessType == 0) {
            if (this.primitive) {
                UNSAFE.putBoolean(entity, this.offset, value);
            } else {
                UNSAFE.putObject(entity, this.offset, value);
            }
        } else {
            try {
                if (this.primitive) {
                    this.field.setBoolean(entity, value);
                } else {
                    this.field.set(entity, value);
                }
            }
            catch (Exception e) {
                ReflectUtil.throwException(e);
            }
        }
    }

    public void set(Object entity, Boolean value) {
        if (this.accessType == 0) {
            if (this.primitive) {
                UNSAFE.putBoolean(entity, this.offset, value);
            } else {
                UNSAFE.putObject(entity, this.offset, value);
            }
        } else {
            try {
                if (this.primitive) {
                    this.field.setBoolean(entity, value);
                } else {
                    this.field.set(entity, value);
                }
            }
            catch (Exception e) {
                ReflectUtil.throwException(e);
            }
        }
    }

    public void set(Object entity, float value) {
        if (this.accessType == 0) {
            if (this.primitive) {
                UNSAFE.putFloat(entity, this.offset, value);
            } else {
                UNSAFE.putObject(entity, this.offset, Float.valueOf(value));
            }
        } else {
            try {
                if (this.primitive) {
                    this.field.setFloat(entity, value);
                } else {
                    this.field.set(entity, Float.valueOf(value));
                }
            }
            catch (Exception e) {
                ReflectUtil.throwException(e);
            }
        }
    }

    public void set(Object entity, Float value) {
        if (this.accessType == 0) {
            if (this.primitive) {
                UNSAFE.putFloat(entity, this.offset, value.floatValue());
            } else {
                UNSAFE.putObject(entity, this.offset, value);
            }
        } else {
            try {
                if (this.primitive) {
                    this.field.setFloat(entity, value.floatValue());
                } else {
                    this.field.set(entity, value);
                }
            }
            catch (Exception e) {
                ReflectUtil.throwException(e);
            }
        }
    }

    public void set(Object entity, double value) {
        if (this.accessType == 0) {
            if (this.primitive) {
                UNSAFE.putDouble(entity, this.offset, value);
            } else {
                UNSAFE.putObject(entity, this.offset, value);
            }
        } else {
            try {
                if (this.primitive) {
                    this.field.setDouble(entity, value);
                } else {
                    this.field.set(entity, value);
                }
            }
            catch (Exception e) {
                ReflectUtil.throwException(e);
            }
        }
    }

    public void set(Object entity, Double value) {
        if (this.accessType == 0) {
            if (this.primitive) {
                UNSAFE.putDouble(entity, this.offset, value);
            } else {
                UNSAFE.putObject(entity, this.offset, value);
            }
        } else {
            try {
                if (this.primitive) {
                    this.field.setDouble(entity, value);
                } else {
                    this.field.set(entity, value);
                }
            }
            catch (Exception e) {
                ReflectUtil.throwException(e);
            }
        }
    }

    public void setObject(Object entity, Object value) {
        block14: {
            block12: {
                block13: {
                    if (this.accessType != 0) break block12;
                    if (!this.primitive) break block13;
                    switch (this.primitiveType) {
                        case 1: {
                            UNSAFE.putInt(entity, this.offset, (Integer)value);
                            break block14;
                        }
                        case 5: {
                            UNSAFE.putShort(entity, this.offset, (Short)value);
                            break block14;
                        }
                        case 6: {
                            UNSAFE.putLong(entity, this.offset, (Long)value);
                            break block14;
                        }
                        case 7: {
                            UNSAFE.putFloat(entity, this.offset, ((Float)value).floatValue());
                            break block14;
                        }
                        case 8: {
                            UNSAFE.putDouble(entity, this.offset, (Double)value);
                            break block14;
                        }
                        case 4: {
                            UNSAFE.putBoolean(entity, this.offset, (Boolean)value);
                            break block14;
                        }
                        case 2: {
                            UNSAFE.putByte(entity, this.offset, (Byte)value);
                            break block14;
                        }
                        case 3: {
                            UNSAFE.putChar(entity, this.offset, ((Character)value).charValue());
                            break block14;
                        }
                        default: {
                            throw new UnsupportedOperationException();
                        }
                    }
                }
                UNSAFE.putObject(entity, this.offset, value);
                break block14;
            }
            try {
                this.field.set(entity, value);
            }
            catch (Exception e) {
                ReflectUtil.throwException(e);
            }
        }
    }

    public int getInt(Object entity) {
        try {
            return this.accessType == 0 ? (this.primitive ? UNSAFE.getInt(entity, this.offset) : (Integer)UNSAFE.getObject(entity, this.offset)) : (this.primitive ? this.field.getInt(entity) : ((Integer)this.field.get(entity)).intValue());
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            return 0;
        }
    }

    public Integer getIntObject(Object entity) {
        try {
            return this.accessType == 0 ? (this.primitive ? Integer.valueOf(UNSAFE.getInt(entity, this.offset)) : (Integer)UNSAFE.getObject(entity, this.offset)) : (this.primitive ? Integer.valueOf(this.field.getInt(entity)) : (Integer)this.field.get(entity));
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            return 0;
        }
    }

    public short getShort(Object entity) {
        try {
            return this.accessType == 0 ? (this.primitive ? UNSAFE.getShort(entity, this.offset) : (Short)UNSAFE.getObject(entity, this.offset)) : (this.primitive ? this.field.getShort(entity) : ((Short)this.field.get(entity)).shortValue());
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            return 0;
        }
    }

    public Short getShortObject(Object entity) {
        try {
            return this.accessType == 0 ? (this.primitive ? Short.valueOf(UNSAFE.getShort(entity, this.offset)) : (Short)UNSAFE.getObject(entity, this.offset)) : (this.primitive ? Short.valueOf(this.field.getShort(entity)) : (Short)this.field.get(entity));
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            return (short)0;
        }
    }

    public boolean getBoolean(Object entity) {
        try {
            return this.accessType == 0 ? (this.primitive ? UNSAFE.getBoolean(entity, this.offset) : (Boolean)UNSAFE.getObject(entity, this.offset)) : (this.primitive ? this.field.getBoolean(entity) : ((Boolean)this.field.get(entity)).booleanValue());
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            return false;
        }
    }

    public Boolean getBooleanObject(Object entity) {
        try {
            return this.accessType == 0 ? (this.primitive ? Boolean.valueOf(UNSAFE.getBoolean(entity, this.offset)) : (Boolean)UNSAFE.getObject(entity, this.offset)) : (this.primitive ? Boolean.valueOf(this.field.getBoolean(entity)) : (Boolean)this.field.get(entity));
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            return false;
        }
    }

    public long getLong(Object entity) {
        try {
            return this.accessType == 0 ? (this.primitive ? UNSAFE.getLong(entity, this.offset) : (Long)UNSAFE.getObject(entity, this.offset)) : (this.primitive ? this.field.getLong(entity) : ((Long)this.field.get(entity)).longValue());
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            return 0L;
        }
    }

    public Long getLongObject(Object entity) {
        try {
            return this.accessType == 0 ? (this.primitive ? Long.valueOf(UNSAFE.getLong(entity, this.offset)) : (Long)UNSAFE.getObject(entity, this.offset)) : (this.primitive ? Long.valueOf(this.field.getLong(entity)) : (Long)this.field.get(entity));
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            return 0L;
        }
    }

    public byte getByte(Object entity) {
        try {
            return this.accessType == 0 ? (this.primitive ? UNSAFE.getByte(entity, this.offset) : (Byte)UNSAFE.getObject(entity, this.offset)) : (this.primitive ? this.field.getByte(entity) : ((Byte)this.field.get(entity)).byteValue());
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            return 0;
        }
    }

    public Byte getByteObject(Object entity) {
        try {
            return this.accessType == 0 ? (this.primitive ? Byte.valueOf(UNSAFE.getByte(entity, this.offset)) : (Byte)UNSAFE.getObject(entity, this.offset)) : (this.primitive ? Byte.valueOf(this.field.getByte(entity)) : (Byte)this.field.get(entity));
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            return (byte)0;
        }
    }

    public char getChar(Object entity) {
        try {
            return this.accessType == 0 ? (this.primitive ? UNSAFE.getChar(entity, this.offset) : ((Character)UNSAFE.getObject(entity, this.offset)).charValue()) : (this.primitive ? this.field.getChar(entity) : ((Character)this.field.get(entity)).charValue());
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            return '\u0000';
        }
    }

    public Character getCharObject(Object entity) {
        try {
            return this.accessType == 0 ? (this.primitive ? Character.valueOf(UNSAFE.getChar(entity, this.offset)) : (Character)UNSAFE.getObject(entity, this.offset)) : (this.primitive ? Character.valueOf(this.field.getChar(entity)) : (Character)this.field.get(entity));
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            return Character.valueOf('\u0000');
        }
    }

    public float getFloat(Object entity) {
        try {
            return this.accessType == 0 ? (this.primitive ? UNSAFE.getFloat(entity, this.offset) : ((Float)UNSAFE.getObject(entity, this.offset)).floatValue()) : (this.primitive ? this.field.getFloat(entity) : ((Float)this.field.get(entity)).floatValue());
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            return 0.0f;
        }
    }

    public Float getFloatObject(Object entity) {
        try {
            return this.accessType == 0 ? (this.primitive ? Float.valueOf(UNSAFE.getFloat(entity, this.offset)) : (Float)UNSAFE.getObject(entity, this.offset)) : (this.primitive ? Float.valueOf(this.field.getFloat(entity)) : (Float)this.field.get(entity));
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            return Float.valueOf(0.0f);
        }
    }

    public double getDouble(Object entity) {
        try {
            return this.accessType == 0 ? (this.primitive ? UNSAFE.getDouble(entity, this.offset) : (Double)UNSAFE.getObject(entity, this.offset)) : (this.primitive ? this.field.getDouble(entity) : ((Double)this.field.get(entity)).doubleValue());
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            return 0.0;
        }
    }

    public Double getDoubleObject(Object entity) {
        try {
            return this.accessType == 0 ? (this.primitive ? Double.valueOf(UNSAFE.getDouble(entity, this.offset)) : (Double)UNSAFE.getObject(entity, this.offset)) : (this.primitive ? Double.valueOf(this.field.getDouble(entity)) : (Double)this.field.get(entity));
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            return 0.0;
        }
    }

    public Object get(Object entity) {
        if (this.accessType == 0) {
            if (this.primitive) {
                switch (this.primitiveType) {
                    case 1: {
                        return UNSAFE.getInt(entity, this.offset);
                    }
                    case 5: {
                        return UNSAFE.getShort(entity, this.offset);
                    }
                    case 6: {
                        return UNSAFE.getLong(entity, this.offset);
                    }
                    case 7: {
                        return Float.valueOf(UNSAFE.getFloat(entity, this.offset));
                    }
                    case 8: {
                        return UNSAFE.getDouble(entity, this.offset);
                    }
                    case 4: {
                        return UNSAFE.getBoolean(entity, this.offset);
                    }
                    case 2: {
                        return UNSAFE.getByte(entity, this.offset);
                    }
                    case 3: {
                        return Character.valueOf(UNSAFE.getChar(entity, this.offset));
                    }
                }
                throw new UnsupportedOperationException();
            }
            return UNSAFE.getObject(entity, this.offset);
        }
        try {
            return this.field.get(entity);
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            return null;
        }
    }

    public Field getField() {
        return this.field;
    }
}

