/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.baseutil.reflect.copy;

import com.jfirer.baseutil.reflect.ReflectUtil;
import com.jfirer.baseutil.reflect.copy.PropertyCopyDescriptor;
import com.jfirer.baseutil.reflect.copy.PropertyCopyDescriptorFactory;
import java.lang.reflect.Field;
import java.util.Map;

public abstract class AbstractPropertyCopyDescriptorFactory
implements PropertyCopyDescriptorFactory {
    @Override
    public <S, D> PropertyCopyDescriptor<S, D> getInstance(Class<S> s, Class<D> d, String fromProperty, String toProperty) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <S, D> PropertyCopyDescriptor<S, D> getInstance(Class<S> s, Class<D> d, final Field fromProperty, final Field toProperty) {
        boolean hasTransfer = this.hasTransfer(fromProperty, toProperty);
        boolean isEnum = this.canEnumCopy(fromProperty.getType(), toProperty.getType());
        if (fromProperty.getType() != toProperty.getType() && !hasTransfer && !isEnum) {
            return new PropertyCopyDescriptor<S, D>(){

                @Override
                public String fromProperty() {
                    return fromProperty.getName();
                }

                @Override
                public String toProperty() {
                    return toProperty.getName();
                }

                @Override
                public void process(S source, D des) throws Exception {
                }
            };
        }
        fromProperty.setAccessible(true);
        toProperty.setAccessible(true);
        if (isEnum) {
            return this.generateEnumCopyPropertyCopyDescriptor(s, d, fromProperty, toProperty);
        }
        return this.generateDefaultCopyPropertyDescriptor(s, d, fromProperty, toProperty);
    }

    private boolean hasTransfer(Field fromProperty, Field toProperty) {
        boolean hasTransfer = false;
        if (fromProperty.getType().isPrimitive()) {
            if (fromProperty.getType() == Integer.TYPE && toProperty.getType() == Integer.class) {
                hasTransfer = true;
            } else if (fromProperty.getType() == Boolean.TYPE && toProperty.getType() == Boolean.class) {
                hasTransfer = true;
            } else if (fromProperty.getType() == Character.TYPE && toProperty.getType() == Character.class) {
                hasTransfer = true;
            } else if (fromProperty.getType() == Byte.TYPE && toProperty.getType() == Byte.class) {
                hasTransfer = true;
            } else if (fromProperty.getType() == Short.TYPE && toProperty.getType() == Short.class) {
                hasTransfer = true;
            } else if (fromProperty.getType() == Long.TYPE && toProperty.getType() == Long.class) {
                hasTransfer = true;
            } else if (fromProperty.getType() == Float.TYPE && toProperty.getType() == Float.class) {
                hasTransfer = true;
            } else if (fromProperty.getType() == Double.TYPE && toProperty.getType() == Double.class) {
                hasTransfer = true;
            }
        }
        return hasTransfer;
    }

    private boolean canEnumCopy(Class<?> srcType, Class<?> desType) {
        if (!Enum.class.isAssignableFrom(srcType) || !Enum.class.isAssignableFrom(desType)) {
            return false;
        }
        Map<String, Enum<?>> allEnumInstances = ReflectUtil.getAllEnumInstances(srcType);
        boolean miss = false;
        for (Map.Entry<String, Enum<?>> entry : allEnumInstances.entrySet()) {
            try {
                Enum.valueOf(desType, entry.getKey());
            }
            catch (Exception e) {
                miss = true;
                break;
            }
        }
        return !miss;
    }

    protected abstract <S, D> PropertyCopyDescriptor<S, D> generateEnumCopyPropertyCopyDescriptor(Class<S> var1, Class<D> var2, Field var3, Field var4);

    protected abstract <S, D> PropertyCopyDescriptor<S, D> generateDefaultCopyPropertyDescriptor(Class<S> var1, Class<D> var2, Field var3, Field var4);
}

