/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.baseutil.smc.model;

import com.jfirer.baseutil.smc.SmcHelper;
import com.jfirer.baseutil.smc.model.ClassModel;

public class ConstructorModel {
    private final ClassModel classModel;
    private Class[] paramTypes;
    private String[] paramNames;
    private String body;

    public ConstructorModel(ClassModel classModel) {
        this.classModel = classModel;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String[] getParamNames() {
        return this.paramNames;
    }

    public void setParamNames(String ... paramNames) {
        this.paramNames = paramNames;
    }

    public Class[] getParamTypes() {
        return this.paramTypes;
    }

    public void setParamTypes(Class ... paramTypes) {
        this.paramTypes = paramTypes;
    }

    public String toString() {
        StringBuilder cache = new StringBuilder();
        cache.append("public ").append(this.classModel.getClassName());
        if (this.paramTypes == null || this.paramTypes.length == 0) {
            cache.append("()\r\n{");
        } else {
            Boolean miss = null;
            cache.append("(");
            for (int i = 0; i < this.paramTypes.length; ++i) {
                cache.append(SmcHelper.getReferenceName(this.paramTypes[i], this.classModel)).append(" ");
                if (miss == null) {
                    miss = this.paramNames == null || this.paramNames.length != this.paramTypes.length;
                }
                if (miss.booleanValue()) {
                    cache.append("$").append(i).append(",");
                    continue;
                }
                cache.append(this.paramNames[i]).append(",");
            }
            cache.setLength(cache.length() - 1);
            cache.append(")\r\n{");
        }
        cache.append(this.body).append("}\r\n");
        return cache.toString();
    }
}

