/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.baseutil.uniqueid;

import com.jfirer.baseutil.StringUtil;
import com.jfirer.baseutil.exception.UnSupportException;
import com.jfirer.baseutil.uniqueid.ByteTool;
import com.jfirer.baseutil.uniqueid.Uid;
import java.util.concurrent.atomic.AtomicInteger;

public class SummerId
implements Uid {
    private static final int countMask = 65535;
    private final AtomicInteger count = new AtomicInteger(0);
    private final byte workedId;

    public SummerId(int workerId) {
        if (workerId < 0 || workerId > 255) {
            throw new UnSupportException("workerid\u7684\u53d6\u503c\u8303\u56f4\u4e3a0-255");
        }
        this.workedId = (byte)(workerId & 0xFF);
    }

    @Override
    public String generate() {
        return StringUtil.toHexString(this.generateBytes());
    }

    @Override
    public long generateLong() {
        byte[] result = this.generateBytes();
        long tmp = ((long)result[0] & 0xFFL) << 56;
        tmp |= ((long)result[1] & 0xFFL) << 48;
        tmp |= ((long)result[2] & 0xFFL) << 40;
        tmp |= ((long)result[3] & 0xFFL) << 32;
        tmp |= ((long)result[4] & 0xFFL) << 24;
        tmp |= ((long)result[5] & 0xFFL) << 16;
        tmp |= ((long)result[6] & 0xFFL) << 8;
        return tmp |= (long)result[7] & 0xFFL;
    }

    @Override
    public String generateDigits() {
        long tmp = this.generateLong();
        char[] value = new char[]{ByteTool.toDigit((int)(tmp >>> 58 & 0x3FL)), ByteTool.toDigit((int)(tmp >>> 52 & 0x3FL)), ByteTool.toDigit((int)(tmp >>> 46 & 0x3FL)), ByteTool.toDigit((int)(tmp >>> 40 & 0x3FL)), ByteTool.toDigit((int)(tmp >>> 34 & 0x3FL)), ByteTool.toDigit((int)(tmp >>> 28 & 0x3FL)), ByteTool.toDigit((int)(tmp >>> 22 & 0x3FL)), ByteTool.toDigit((int)(tmp >>> 16 & 0x3FL)), ByteTool.toDigit((int)(tmp >>> 10 & 0x3FL)), ByteTool.toDigit((int)(tmp >>> 4 & 0x3FL)), ByteTool.toDigit((int)(tmp & 0xFL))};
        return String.valueOf(value);
    }

    @Override
    public byte[] generateBytes() {
        byte[] result = new byte[8];
        long time = System.currentTimeMillis() - 1548989749033L;
        result[0] = (byte)(time >>> 32);
        result[1] = (byte)(time >>> 24);
        result[2] = (byte)(time >>> 16);
        result[3] = (byte)(time >>> 8);
        result[4] = (byte)time;
        result[5] = this.workedId;
        int tmp = this.count.getAndIncrement() & 0xFFFF;
        result[6] = (byte)(tmp >>> 8);
        result[7] = (byte)tmp;
        return result;
    }
}

