/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.protobuf;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.RequestConverterFunction;
import com.linecorp.armeria.server.protobuf.ProtobufRequestConverterFunctionProvider;
import com.linecorp.armeria.server.protobuf.ProtobufResponseConverterFunction;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public final class ProtobufRequestConverterFunction
implements RequestConverterFunction {
    private static final ClassValue<MethodHandle> methodCache;
    private static final JsonFormat.Parser defaultJsonParser;
    private static final ObjectMapper mapper;
    private static final MethodHandle unknownMethodHandle;
    private final ExtensionRegistry extensionRegistry;
    private final JsonFormat.Parser jsonParser;
    private final ResultType resultType;

    ProtobufRequestConverterFunction(ResultType resultType) {
        this(defaultJsonParser, ExtensionRegistry.getEmptyRegistry(), resultType);
    }

    public ProtobufRequestConverterFunction() {
        this(defaultJsonParser, ExtensionRegistry.getEmptyRegistry());
    }

    public ProtobufRequestConverterFunction(JsonFormat.Parser jsonParser, ExtensionRegistry extensionRegistry) {
        this(jsonParser, extensionRegistry, ResultType.UNKNOWN);
    }

    private ProtobufRequestConverterFunction(JsonFormat.Parser jsonParser, ExtensionRegistry extensionRegistry, ResultType resultType) {
        this.jsonParser = Objects.requireNonNull(jsonParser, "jsonParser");
        this.extensionRegistry = Objects.requireNonNull(extensionRegistry, "extensionRegistry");
        this.resultType = Objects.requireNonNull(resultType, "resultType");
    }

    @Nullable
    public Object convertRequest(ServiceRequestContext ctx, AggregatedHttpRequest request, Class<?> expectedResultType, @Nullable ParameterizedType expectedParameterizedResultType) throws Exception {
        Charset charset;
        MediaType contentType = request.contentType();
        Charset charset2 = charset = contentType == null ? StandardCharsets.UTF_8 : contentType.charset(StandardCharsets.UTF_8);
        if (this.resultType == ResultType.PROTOBUF || this.resultType == ResultType.UNKNOWN && Message.class.isAssignableFrom(expectedResultType)) {
            Message.Builder messageBuilder = ProtobufRequestConverterFunction.getMessageBuilder(expectedResultType);
            if (ProtobufRequestConverterFunction.isProtobuf(contentType)) {
                try (InputStream is = request.content().toInputStream();){
                    Message message = messageBuilder.mergeFrom(is, (ExtensionRegistryLite)this.extensionRegistry).build();
                    return message;
                }
            }
            if (ProtobufRequestConverterFunction.isJson(contentType)) {
                this.jsonParser.merge(request.content(charset), messageBuilder);
                return messageBuilder.build();
            }
        }
        if (!ProtobufRequestConverterFunction.isJson(contentType) || expectedParameterizedResultType == null) {
            return RequestConverterFunction.fallthrough();
        }
        ResultType resultType = this.resultType;
        if (resultType == ResultType.UNKNOWN) {
            resultType = ProtobufRequestConverterFunctionProvider.toResultType(expectedParameterizedResultType);
        }
        if (resultType == ResultType.UNKNOWN || resultType == ResultType.PROTOBUF) {
            return RequestConverterFunction.fallthrough();
        }
        Type[] typeArguments = expectedParameterizedResultType.getActualTypeArguments();
        String content = request.content(charset);
        JsonNode jsonNode = mapper.readTree(content);
        switch (resultType) {
            case LIST_PROTOBUF: 
            case SET_PROTOBUF: {
                if (!jsonNode.isArray()) break;
                Object builder = resultType == ResultType.LIST_PROTOBUF ? ImmutableList.builderWithExpectedSize((int)jsonNode.size()) : ImmutableSet.builderWithExpectedSize((int)jsonNode.size());
                for (JsonNode node : jsonNode) {
                    Message.Builder msgBuilder = ProtobufRequestConverterFunction.getMessageBuilder((Class)typeArguments[0]);
                    this.jsonParser.merge(mapper.writeValueAsString((Object)node), msgBuilder);
                    builder.add((Object)msgBuilder.build());
                }
                return builder.build();
            }
            case MAP_PROTOBUF: {
                if (!jsonNode.isObject()) break;
                ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)jsonNode.size());
                Iterator i = jsonNode.fields();
                while (i.hasNext()) {
                    Map.Entry e = (Map.Entry)i.next();
                    Message.Builder msgBuilder = ProtobufRequestConverterFunction.getMessageBuilder((Class)typeArguments[1]);
                    this.jsonParser.merge(mapper.writeValueAsString(e.getValue()), msgBuilder);
                    builder.put((Object)((String)e.getKey()), (Object)msgBuilder.build());
                }
                return builder.build();
            }
        }
        return RequestConverterFunction.fallthrough();
    }

    static boolean isProtobuf(@Nullable MediaType contentType) {
        return contentType == null || contentType.is(MediaType.PROTOBUF) || contentType.is(ProtobufResponseConverterFunction.X_PROTOBUF) || contentType.is(MediaType.OCTET_STREAM);
    }

    static boolean isJson(@Nullable MediaType contentType) {
        return contentType != null && contentType.isJson();
    }

    private static Message.Builder getMessageBuilder(Class<?> clazz) {
        MethodHandle methodHandle = methodCache.get(clazz);
        if (methodHandle == unknownMethodHandle) {
            throw new IllegalStateException("Failed to find a static newBuilder() method from " + clazz);
        }
        try {
            return methodHandle.invoke();
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Failed to create an empty instance of " + clazz + " using newBuilder() method", throwable);
        }
    }

    static {
        MethodHandle methodHandle;
        methodCache = new ClassValue<MethodHandle>(){

            @Override
            protected MethodHandle computeValue(Class<?> type) {
                try {
                    Class<?> builderClass = Class.forName(type.getName() + "$Builder");
                    MethodHandles.Lookup publicLookup = MethodHandles.publicLookup();
                    return publicLookup.findStatic(type, "newBuilder", MethodType.methodType(builderClass));
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException ignored) {
                    return unknownMethodHandle;
                }
            }
        };
        defaultJsonParser = JsonFormat.parser().ignoringUnknownFields();
        mapper = new ObjectMapper();
        MethodHandles.Lookup publicLookup = MethodHandles.publicLookup();
        MethodType mt = MethodType.methodType(Void.TYPE);
        try {
            methodHandle = publicLookup.findConstructor(ProtobufRequestConverterFunction.class, mt);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            methodHandle = null;
        }
        assert (methodHandle != null);
        unknownMethodHandle = methodHandle;
    }

    static enum ResultType {
        UNKNOWN,
        PROTOBUF,
        LIST_PROTOBUF,
        SET_PROTOBUF,
        MAP_PROTOBUF;

    }
}

