/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.lich.static_analysis.detectors;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UTypeReferenceExpression;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0002\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0006*\u00020\u0011H\u0002J\u0014\u0010\u0013\u001a\u00020\r*\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J$\u0010\u0016\u001a\u00020\r*\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/linecorp/lich/static_analysis/detectors/LichFactoryDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "typeArgument", "Lcom/intellij/psi/impl/source/PsiClassReferenceType;", "Lorg/jetbrains/uast/UTypeReferenceExpression;", "getTypeArgument", "(Lorg/jetbrains/uast/UTypeReferenceExpression;)Lcom/intellij/psi/impl/source/PsiClassReferenceType;", "applicableSuperClasses", "", "", "visitClass", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "declaration", "Lorg/jetbrains/uast/UClass;", "findFactorySupertype", "reportObject", "node", "Lorg/jetbrains/uast/UElement;", "reportTypeArgument", "parentClass", "factory", "Lcom/linecorp/lich/static_analysis/detectors/LichFactoryDetector$Factory;", "Companion", "Factory", "static-analysis"})
public final class LichFactoryDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue TYPE_ARGUMENT_ISSUE = Issue.Companion.create("InvalidTypeArgumentInFactory", "The factory's type argument should be the companion object's parent class.", "Factories in companion objects should never create instances of classes outside of the scope of the companion object's parent class. Change the type argument of this factory to the companion object's parent class or use a top level *object* declaration instead.", Category.CORRECTNESS, 6, Severity.ERROR, new Implementation(LichFactoryDetector.class, Scope.JAVA_FILE_SCOPE));
    @NotNull
    private static final Issue OBJECT_ISSUE = Issue.Companion.create("FactoryShouldBeObject", "Factories should be implemented by *object declarations*.", "In order to avoid multiple instances of the same factory, you should implement factories using an *object declaration*.", Category.CORRECTNESS, 6, Severity.ERROR, new Implementation(LichFactoryDetector.class, Scope.JAVA_FILE_SCOPE));

    @NotNull
    public List<String> applicableSuperClasses() {
        return Factory.Companion.getQualifiedNames();
    }

    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        Object typeArgumentCanonical;
        UElement uElement;
        Factory factoryType;
        UTypeReferenceExpression factorySupertypeDeclaration;
        block11: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            if (!Lint.isKotlin((PsiElement)((PsiElement)declaration)) || Factory.Companion.contains(declaration.getQualifiedName())) {
                return;
            }
            PsiElement declarationPsi = declaration.getSourcePsi();
            if (!(declarationPsi instanceof KtObjectDeclaration) || ((KtObjectDeclaration)declarationPsi).isObjectLiteral()) {
                this.reportObject(context, (UElement)declaration);
                return;
            }
            if (!((KtObjectDeclaration)declarationPsi).isCompanion()) {
                return;
            }
            UTypeReferenceExpression uTypeReferenceExpression = this.findFactorySupertype(declaration);
            if (uTypeReferenceExpression == null) {
                return;
            }
            factorySupertypeDeclaration = uTypeReferenceExpression;
            Factory factory = Factory.Companion.find(factorySupertypeDeclaration.getQualifiedName());
            if (factory == null) {
                return;
            }
            factoryType = factory;
            UElement $this$findClosestParentByType_u24default$iv = (UElement)declaration;
            boolean ancestorLevel$iv = true;
            boolean $i$f$findClosestParentByType = false;
            UElement uElement2 = $this$findClosestParentByType_u24default$iv;
            int currentAncestorLevel$iv = 0;
            for (UElement node$iv = uElement2.getUastParent(); node$iv != null; node$iv = node$iv.getUastParent()) {
                if (node$iv instanceof UClass) {
                    int n = currentAncestorLevel$iv;
                    currentAncestorLevel$iv = n + 1;
                }
                if (currentAncestorLevel$iv != ancestorLevel$iv) continue;
                UElement uElement3 = node$iv;
                if (!(uElement3 instanceof UClass)) {
                    uElement3 = null;
                }
                uElement = (UElement)((UClass)uElement3);
                break block11;
            }
            uElement = null;
        }
        UClass uClass = (UClass)uElement;
        if (uClass == null) {
            return;
        }
        UClass parentClass = uClass;
        PsiClassReferenceType typeArgument = this.getTypeArgument(factorySupertypeDeclaration);
        Object object = typeArgument;
        object = object == null ? null : object.getCanonicalText();
        boolean bl = false;
        Object object2 = object;
        if (object2 == null) {
            object2 = typeArgumentCanonical = "";
        }
        if (!Intrinsics.areEqual((Object)parentClass.getQualifiedName(), (Object)typeArgumentCanonical)) {
            this.reportTypeArgument(context, (UElement)factorySupertypeDeclaration, parentClass, factoryType);
        }
    }

    private final UTypeReferenceExpression findFactorySupertype(UClass $this$findFactorySupertype) {
        Object v0;
        block1: {
            Iterable iterable = $this$findFactorySupertype.getUastSuperTypes();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                UTypeReferenceExpression superClass = (UTypeReferenceExpression)t;
                boolean bl3 = false;
                if (!Factory.Companion.contains(superClass.getQualifiedName())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final PsiClassReferenceType getTypeArgument(UTypeReferenceExpression $this$typeArgument) {
        PsiClassType psiClassType;
        Object object = $this$typeArgument.getType();
        PsiClassType psiClassType2 = psiClassType = object instanceof PsiClassType ? (PsiClassType)object : null;
        JvmType jvmType = psiClassType == null ? null : ((object = psiClassType.typeArguments()) == null ? null : (JvmType)CollectionsKt.first((Iterable)object));
        return jvmType instanceof PsiClassReferenceType ? (PsiClassReferenceType)jvmType : null;
    }

    private final void reportTypeArgument(JavaContext $this$reportTypeArgument, UElement node, UClass parentClass, Factory factory) {
        LintFix lintFix = LintFix.create().replace().name("Replace " + factory.getShortName() + "'s type argument with " + parentClass.getName()).with(factory.getShortName() + '<' + parentClass.getName() + '>').reformat(true).shortenNames().build();
        Intrinsics.checkNotNullExpressionValue((Object)lintFix, (String)"create().replace()\n            .name(\"Replace ${factory.shortName}'s type argument with ${parentClass.name}\")\n            .with(\"${factory.shortName}<${parentClass.name}>\")\n            .reformat(true)\n            .shortenNames()\n            .build()");
        LintFix fix = lintFix;
        $this$reportTypeArgument.report(TYPE_ARGUMENT_ISSUE, node, $this$reportTypeArgument.getNameLocation(node), "This " + factory.getShortName() + "'s type argument should be " + parentClass.getName() + '.', fix);
    }

    private final void reportObject(JavaContext $this$reportObject, UElement node) {
        JavaContext.report$default((JavaContext)$this$reportObject, (Issue)OBJECT_ISSUE, (UElement)node, (Location)$this$reportObject.getNameLocation(node), (String)"Factories should be implemented by *object declarations*.", null, (int)16, null);
    }

    @NotNull
    public static final Issue getTYPE_ARGUMENT_ISSUE() {
        return Companion.getTYPE_ARGUMENT_ISSUE();
    }

    @NotNull
    public static final Issue getOBJECT_ISSUE() {
        return Companion.getOBJECT_ISSUE();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/linecorp/lich/static_analysis/detectors/LichFactoryDetector$Companion;", "", "()V", "OBJECT_ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getOBJECT_ISSUE$annotations", "getOBJECT_ISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "TYPE_ARGUMENT_ISSUE", "getTYPE_ARGUMENT_ISSUE$annotations", "getTYPE_ARGUMENT_ISSUE", "static-analysis"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getTYPE_ARGUMENT_ISSUE() {
            return TYPE_ARGUMENT_ISSUE;
        }

        @JvmStatic
        public static /* synthetic */ void getTYPE_ARGUMENT_ISSUE$annotations() {
        }

        @NotNull
        public final Issue getOBJECT_ISSUE() {
            return OBJECT_ISSUE;
        }

        @JvmStatic
        public static /* synthetic */ void getOBJECT_ISSUE$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0082\u0001\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000bB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\tj\u0002\b\n\u00a8\u0006\f"}, d2={"Lcom/linecorp/lich/static_analysis/detectors/LichFactoryDetector$Factory;", "", "qualifiedName", "", "shortName", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getQualifiedName", "()Ljava/lang/String;", "getShortName", "VIEWMODEL", "COMPONENT", "Companion", "static-analysis"})
    private static final class Factory
    extends Enum<Factory> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String qualifiedName;
        @NotNull
        private final String shortName;
        @NotNull
        private static final List<String> qualifiedNames;
        public static final /* enum */ Factory VIEWMODEL;
        public static final /* enum */ Factory COMPONENT;
        private static final /* synthetic */ Factory[] $VALUES;

        private Factory(String qualifiedName, String shortName) {
            this.qualifiedName = qualifiedName;
            this.shortName = shortName;
        }

        @NotNull
        public final String getQualifiedName() {
            return this.qualifiedName;
        }

        @NotNull
        public final String getShortName() {
            return this.shortName;
        }

        public static Factory[] values() {
            Factory[] factoryArray = $VALUES;
            return Arrays.copyOf(factoryArray, factoryArray.length);
        }

        public static Factory valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(Factory.class, value);
        }

        /*
         * WARNING - void declaration
         */
        static {
            void var3_3;
            void $this$mapTo$iv$iv;
            VIEWMODEL = new Factory("com.linecorp.lich.viewmodel.ViewModelFactory", "ViewModelFactory");
            COMPONENT = new Factory("com.linecorp.lich.component.ComponentFactory", "ComponentFactory");
            $VALUES = factoryArray = new Factory[]{Factory.VIEWMODEL, Factory.COMPONENT};
            Companion = new Companion(null);
            Factory[] $this$map$iv = Factory.values();
            boolean $i$f$map = false;
            Factory[] factoryArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var5_5 = $this$mapTo$iv$iv;
            int n = ((void)var5_5).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var9_9 = item$iv$iv = var5_5[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getQualifiedName();
                collection.add(string);
            }
            qualifiedNames = (List)var3_3;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0005J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\n\u001a\u0004\u0018\u00010\u0005R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/linecorp/lich/static_analysis/detectors/LichFactoryDetector$Factory$Companion;", "", "()V", "qualifiedNames", "", "", "getQualifiedNames", "()Ljava/util/List;", "contains", "", "qualifiedName", "find", "Lcom/linecorp/lich/static_analysis/detectors/LichFactoryDetector$Factory;", "static-analysis"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<String> getQualifiedNames() {
                return qualifiedNames;
            }

            public final boolean contains(@Nullable String qualifiedName) {
                return CollectionsKt.contains((Iterable)this.getQualifiedNames(), (Object)qualifiedName);
            }

            @Nullable
            public final Factory find(@Nullable String qualifiedName) {
                Factory factory;
                block1: {
                    Factory[] factoryArray = Factory.values();
                    boolean bl = false;
                    Factory[] factoryArray2 = factoryArray;
                    boolean bl2 = false;
                    Factory[] factoryArray3 = factoryArray2;
                    int n = factoryArray3.length;
                    for (int i = 0; i < n; ++i) {
                        Factory factory2;
                        Factory it = factory2 = factoryArray3[i];
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)qualifiedName)) continue;
                        factory = factory2;
                        break block1;
                    }
                    factory = null;
                }
                return factory;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

