/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.eventhub.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.eventhub.EventHubNamespace;
import com.microsoft.azure.management.eventhub.EventHubNamespaceAuthorizationRule;
import com.microsoft.azure.management.eventhub.KeyType;
import com.microsoft.azure.management.eventhub.implementation.AccessKeysInner;
import com.microsoft.azure.management.eventhub.implementation.Ancestors;
import com.microsoft.azure.management.eventhub.implementation.AuthorizationRuleBaseImpl;
import com.microsoft.azure.management.eventhub.implementation.AuthorizationRuleInner;
import com.microsoft.azure.management.eventhub.implementation.EventHubManagementClientImpl;
import com.microsoft.azure.management.eventhub.implementation.EventHubManager;
import com.microsoft.azure.management.eventhub.implementation.RegenerateAccessKeyParametersInner;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.util.Objects;
import rx.Observable;

@LangDefinition
class EventHubNamespaceAuthorizationRuleImpl
extends AuthorizationRuleBaseImpl<EventHubNamespaceAuthorizationRule, EventHubNamespaceAuthorizationRuleImpl>
implements EventHubNamespaceAuthorizationRule,
EventHubNamespaceAuthorizationRule.Definition,
EventHubNamespaceAuthorizationRule.Update {
    private Ancestors.OneAncestor ancestor;

    EventHubNamespaceAuthorizationRuleImpl(String name, AuthorizationRuleInner inner, EventHubManager manager) {
        super(name, inner, manager);
        Ancestors ancestors = new Ancestors();
        ancestors.getClass();
        this.ancestor = ancestors.new Ancestors.OneAncestor(inner.id());
    }

    EventHubNamespaceAuthorizationRuleImpl(String name, EventHubManager manager) {
        super(name, new AuthorizationRuleInner(), manager);
    }

    @Override
    public String namespaceResourceGroupName() {
        return this.ancestor().resourceGroupName();
    }

    @Override
    public String namespaceName() {
        return this.ancestor().ancestor1Name();
    }

    @Override
    public EventHubNamespaceAuthorizationRuleImpl withExistingNamespaceId(String namespaceResourceId) {
        Ancestors ancestors = new Ancestors();
        ancestors.getClass();
        this.ancestor = ancestors.new Ancestors.OneAncestor(this.selfId(namespaceResourceId));
        return this;
    }

    @Override
    public EventHubNamespaceAuthorizationRuleImpl withExistingNamespace(String resourceGroupName, String namespaceName) {
        Ancestors ancestors = new Ancestors();
        ancestors.getClass();
        this.ancestor = ancestors.new Ancestors.OneAncestor(resourceGroupName, namespaceName);
        return this;
    }

    @Override
    public EventHubNamespaceAuthorizationRuleImpl withExistingNamespace(EventHubNamespace namespace) {
        Ancestors ancestors = new Ancestors();
        ancestors.getClass();
        this.ancestor = ancestors.new Ancestors.OneAncestor(this.selfId(namespace.id()));
        return this;
    }

    @Override
    protected Observable<AuthorizationRuleInner> getInnerAsync() {
        return ((EventHubManagementClientImpl)((Object)this.manager.inner())).namespaces().getAuthorizationRuleAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name());
    }

    @Override
    public Observable<EventHubNamespaceAuthorizationRule> createResourceAsync() {
        return ((EventHubManagementClientImpl)((Object)this.manager.inner())).namespaces().createOrUpdateAuthorizationRuleAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name(), ((AuthorizationRuleInner)this.inner()).rights()).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    @Override
    protected Observable<AccessKeysInner> getKeysInnerAsync() {
        return ((EventHubManagementClientImpl)((Object)this.manager.inner())).namespaces().listKeysAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name());
    }

    @Override
    protected Observable<AccessKeysInner> regenerateKeysInnerAsync(KeyType keyType) {
        RegenerateAccessKeyParametersInner regenKeyInner = new RegenerateAccessKeyParametersInner().withKeyType(keyType);
        return ((EventHubManagementClientImpl)((Object)this.manager.inner())).namespaces().regenerateKeysAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name(), regenKeyInner);
    }

    private Ancestors.OneAncestor ancestor() {
        Objects.requireNonNull(this.ancestor);
        return this.ancestor;
    }

    private String selfId(String parentId) {
        return String.format("%s/authorizationRules/%s", parentId, this.name());
    }
}

