/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.RefreshableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import com.microsoft.azure.management.sql.ReplicationLink;
import com.microsoft.azure.management.sql.ReplicationRole;
import com.microsoft.azure.management.sql.ReplicationState;
import com.microsoft.azure.management.sql.implementation.ReplicationLinkInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import org.joda.time.DateTime;
import rx.Completable;
import rx.Observable;

@LangDefinition
class ReplicationLinkImpl
extends RefreshableWrapperImpl<ReplicationLinkInner, ReplicationLink>
implements ReplicationLink {
    private final String sqlServerName;
    private final String resourceGroupName;
    private final SqlServerManager sqlServerManager;
    private final ResourceId resourceId;

    protected ReplicationLinkImpl(String resourceGroupName, String sqlServerName, ReplicationLinkInner innerObject, SqlServerManager sqlServerManager) {
        super((Object)innerObject);
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlServerManager = sqlServerManager;
        this.resourceId = ResourceId.fromString((String)((ReplicationLinkInner)this.inner()).id());
    }

    protected Observable<ReplicationLinkInner> getInnerAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).replicationLinks().getAsync(this.resourceGroupName, this.sqlServerName, this.databaseName(), this.name());
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String databaseName() {
        return this.resourceId.parent().name();
    }

    @Override
    public String partnerServer() {
        return ((ReplicationLinkInner)this.inner()).partnerServer();
    }

    @Override
    public String partnerDatabase() {
        return ((ReplicationLinkInner)this.inner()).partnerDatabase();
    }

    @Override
    public String partnerLocation() {
        return ((ReplicationLinkInner)this.inner()).partnerLocation();
    }

    @Override
    public ReplicationRole role() {
        return ((ReplicationLinkInner)this.inner()).role();
    }

    @Override
    public ReplicationRole partnerRole() {
        return ((ReplicationLinkInner)this.inner()).partnerRole();
    }

    @Override
    public DateTime startTime() {
        return ((ReplicationLinkInner)this.inner()).startTime();
    }

    @Override
    public int percentComplete() {
        return Utils.toPrimitiveInt((Integer)((ReplicationLinkInner)this.inner()).percentComplete());
    }

    @Override
    public ReplicationState replicationState() {
        return ((ReplicationLinkInner)this.inner()).replicationState();
    }

    @Override
    public String location() {
        return ((ReplicationLinkInner)this.inner()).location();
    }

    @Override
    public boolean isTerminationAllowed() {
        return ((ReplicationLinkInner)this.inner()).isTerminationAllowed();
    }

    @Override
    public String replicationMode() {
        return ((ReplicationLinkInner)this.inner()).replicationMode();
    }

    @Override
    public void delete() {
        ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).replicationLinks().delete(this.resourceGroupName, this.sqlServerName, this.databaseName(), this.name());
    }

    @Override
    public void failover() {
        ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).replicationLinks().failover(this.resourceGroupName, this.sqlServerName, this.databaseName(), this.name());
    }

    @Override
    public Completable failoverAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).replicationLinks().failoverAsync(this.resourceGroupName, this.sqlServerName, this.databaseName(), this.name()).toCompletable();
    }

    @Override
    public ServiceFuture<Void> failoverAsync(ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Completable)this.failoverAsync(), callback);
    }

    @Override
    public void forceFailoverAllowDataLoss() {
        ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).replicationLinks().failoverAllowDataLoss(this.resourceGroupName, this.sqlServerName, this.databaseName(), this.name());
    }

    @Override
    public Completable forceFailoverAllowDataLossAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).replicationLinks().failoverAllowDataLossAsync(this.resourceGroupName, this.sqlServerName, this.databaseName(), this.name()).toCompletable();
    }

    @Override
    public ServiceFuture<Void> forceFailoverAllowDataLossAsync(ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Completable)this.forceFailoverAllowDataLossAsync(), callback);
    }

    public String name() {
        return ((ReplicationLinkInner)this.inner()).name();
    }

    public String id() {
        return ((ReplicationLinkInner)this.inner()).id();
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }
}

