/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.management;

import com.microsoft.azure.servicebus.management.EntityNameHelper;
import com.microsoft.azure.servicebus.management.EntityStatus;
import com.microsoft.azure.servicebus.management.ManagementClientConstants;
import com.microsoft.azure.servicebus.management.RuleDescriptionSerializer;
import com.microsoft.azure.servicebus.management.SerializerUtil;
import com.microsoft.azure.servicebus.management.SubscriptionDescription;
import com.microsoft.azure.servicebus.primitives.MessagingEntityNotFoundException;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class SubscriptionDescriptionSerializer {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(SubscriptionDescriptionSerializer.class);

    SubscriptionDescriptionSerializer() {
    }

    static String serialize(SubscriptionDescription subscriptionDescription) throws ServiceBusException {
        DocumentBuilder dBuilder;
        try {
            DocumentBuilderFactory dbFactory = SerializerUtil.getDocumentBuilderFactory();
            dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ServiceBusException(false, (Throwable)e);
        }
        Document doc = dBuilder.newDocument();
        Element rootElement = doc.createElementNS("http://www.w3.org/2005/Atom", "entry");
        doc.appendChild(rootElement);
        Element contentElement = doc.createElementNS("http://www.w3.org/2005/Atom", "content");
        rootElement.appendChild(contentElement);
        contentElement.setAttribute("type", "application/xml");
        Element sdElement = doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SubscriptionDescription");
        contentElement.appendChild(sdElement);
        sdElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "LockDuration").appendChild(doc.createTextNode(subscriptionDescription.lockDuration.toString())).getParentNode());
        sdElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "RequiresSession").appendChild(doc.createTextNode(Boolean.toString(subscriptionDescription.requiresSession))).getParentNode());
        if (subscriptionDescription.defaultMessageTimeToLive.compareTo(ManagementClientConstants.MAX_DURATION) < 0) {
            sdElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DefaultMessageTimeToLive").appendChild(doc.createTextNode(subscriptionDescription.defaultMessageTimeToLive.toString())).getParentNode());
        }
        sdElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DeadLetteringOnMessageExpiration").appendChild(doc.createTextNode(Boolean.toString(subscriptionDescription.enableDeadLetteringOnMessageExpiration))).getParentNode());
        sdElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DeadLetteringOnFilterEvaluationExceptions").appendChild(doc.createTextNode(Boolean.toString(subscriptionDescription.enableDeadLetteringOnFilterEvaluationException))).getParentNode());
        if (subscriptionDescription.defaultRule != null) {
            sdElement.appendChild(RuleDescriptionSerializer.serializeRule(doc, subscriptionDescription.defaultRule, "DefaultRuleDescription"));
        }
        sdElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "MaxDeliveryCount").appendChild(doc.createTextNode(Integer.toString(subscriptionDescription.maxDeliveryCount))).getParentNode());
        sdElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "EnableBatchedOperations").appendChild(doc.createTextNode(Boolean.toString(subscriptionDescription.enableBatchedOperations))).getParentNode());
        sdElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Status").appendChild(doc.createTextNode(subscriptionDescription.status.name())).getParentNode());
        if (subscriptionDescription.forwardTo != null) {
            sdElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ForwardTo").appendChild(doc.createTextNode(subscriptionDescription.forwardTo)).getParentNode());
        }
        if (subscriptionDescription.userMetadata != null) {
            sdElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "UserMetadata").appendChild(doc.createTextNode(subscriptionDescription.userMetadata)).getParentNode());
        }
        if (subscriptionDescription.autoDeleteOnIdle.compareTo(ManagementClientConstants.MAX_DURATION) < 0) {
            sdElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AutoDeleteOnIdle").appendChild(doc.createTextNode(subscriptionDescription.autoDeleteOnIdle.toString())).getParentNode());
        }
        if (subscriptionDescription.forwardDeadLetteredMessagesTo != null) {
            sdElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ForwardDeadLetteredMessagesTo").appendChild(doc.createTextNode(subscriptionDescription.forwardDeadLetteredMessagesTo)).getParentNode());
        }
        StringWriter output = new StringWriter();
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(doc), new StreamResult(output));
        }
        catch (TransformerException e) {
            throw new ServiceBusException(false, (Throwable)e);
        }
        return output.toString();
    }

    static List<SubscriptionDescription> parseCollectionFromContent(String topicName, String xml) {
        ArrayList<SubscriptionDescription> subList;
        block4: {
            subList = new ArrayList<SubscriptionDescription>();
            try {
                DocumentBuilderFactory dbf = SerializerUtil.getDocumentBuilderFactory();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(new ByteArrayInputStream(xml.getBytes("utf-8")));
                Element doc = dom.getDocumentElement();
                doc.normalize();
                NodeList entries = doc.getChildNodes();
                for (int i = 0; i < entries.getLength(); ++i) {
                    Node node = entries.item(i);
                    if (!node.getNodeName().equals("entry")) continue;
                    subList.add(SubscriptionDescriptionSerializer.parseFromEntry(topicName, node));
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                if (TRACE_LOGGER.isErrorEnabled()) {
                    TRACE_LOGGER.info("Exception while parsing response.", (Throwable)e);
                }
                if (!TRACE_LOGGER.isDebugEnabled()) break block4;
                TRACE_LOGGER.debug("XML which failed to parse: \n %s", (Object)xml);
            }
        }
        return subList;
    }

    static SubscriptionDescription parseFromContent(String topicName, String xml) throws MessagingEntityNotFoundException {
        block4: {
            try {
                DocumentBuilderFactory dbf = SerializerUtil.getDocumentBuilderFactory();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(new ByteArrayInputStream(xml.getBytes("utf-8")));
                Element doc = dom.getDocumentElement();
                doc.normalize();
                if ("entry".equals(doc.getTagName())) {
                    return SubscriptionDescriptionSerializer.parseFromEntry(topicName, doc);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                if (TRACE_LOGGER.isErrorEnabled()) {
                    TRACE_LOGGER.info("Exception while parsing response.", (Throwable)e);
                }
                if (!TRACE_LOGGER.isDebugEnabled()) break block4;
                TRACE_LOGGER.debug("XML which failed to parse: \n %s", (Object)xml);
            }
        }
        throw new MessagingEntityNotFoundException("Subscription was not found");
    }

    private static SubscriptionDescription parseFromEntry(String topicName, Node xEntry) {
        SubscriptionDescription sd = null;
        NodeList nList = xEntry.getChildNodes();
        block36: for (int i = 0; i < nList.getLength(); ++i) {
            Node node = nList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            switch (element.getTagName()) {
                case "title": {
                    sd = new SubscriptionDescription(topicName, element.getFirstChild().getNodeValue());
                    continue block36;
                }
                case "content": {
                    NodeList qdNodes = element.getFirstChild().getChildNodes();
                    block37: for (int j = 0; j < qdNodes.getLength(); ++j) {
                        node = qdNodes.item(j);
                        if (node.getNodeType() != 1) continue;
                        element = (Element)node;
                        switch (element.getTagName()) {
                            case "RequiresSession": {
                                sd.requiresSession = Boolean.parseBoolean(element.getFirstChild().getNodeValue());
                                continue block37;
                            }
                            case "DeadLetteringOnMessageExpiration": {
                                sd.enableDeadLetteringOnMessageExpiration = Boolean.parseBoolean(element.getFirstChild().getNodeValue());
                                continue block37;
                            }
                            case "DeadLetteringOnFilterEvaluationExceptions": {
                                sd.enableDeadLetteringOnFilterEvaluationException = Boolean.parseBoolean(element.getFirstChild().getNodeValue());
                                continue block37;
                            }
                            case "LockDuration": {
                                sd.lockDuration = Duration.parse(element.getFirstChild().getNodeValue());
                                continue block37;
                            }
                            case "DefaultMessageTimeToLive": {
                                sd.defaultMessageTimeToLive = Duration.parse(element.getFirstChild().getNodeValue());
                                continue block37;
                            }
                            case "MaxDeliveryCount": {
                                sd.maxDeliveryCount = Integer.parseInt(element.getFirstChild().getNodeValue());
                                continue block37;
                            }
                            case "EnableBatchedOperations": {
                                sd.enableBatchedOperations = Boolean.parseBoolean(element.getFirstChild().getNodeValue());
                                continue block37;
                            }
                            case "Status": {
                                sd.status = EntityStatus.valueOf(element.getFirstChild().getNodeValue());
                                continue block37;
                            }
                            case "AutoDeleteOnIdle": {
                                sd.autoDeleteOnIdle = Duration.parse(element.getFirstChild().getNodeValue());
                                continue block37;
                            }
                            case "UserMetadata": {
                                sd.userMetadata = element.getFirstChild().getNodeValue();
                                continue block37;
                            }
                            case "ForwardTo": {
                                Node fwd = element.getFirstChild();
                                if (fwd == null) continue block37;
                                sd.forwardTo = fwd.getNodeValue();
                                continue block37;
                            }
                            case "ForwardDeadLetteredMessagesTo": {
                                Node fwdDlq = element.getFirstChild();
                                if (fwdDlq == null) continue block37;
                                sd.forwardDeadLetteredMessagesTo = fwdDlq.getNodeValue();
                                continue block37;
                            }
                        }
                    }
                    continue block36;
                }
            }
        }
        return sd;
    }

    static void normalizeDescription(SubscriptionDescription subscriptionDescription, URI baseAddress) {
        if (subscriptionDescription.getForwardTo() != null) {
            subscriptionDescription.setForwardTo(EntityNameHelper.normalizeForwardToAddress(subscriptionDescription.getForwardTo(), baseAddress));
        }
        if (subscriptionDescription.getForwardDeadLetteredMessagesTo() != null) {
            subscriptionDescription.setForwardDeadLetteredMessagesTo(EntityNameHelper.normalizeForwardToAddress(subscriptionDescription.getForwardDeadLetteredMessagesTo(), baseAddress));
        }
    }
}

