/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.holder;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.GradientDrawable;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.core.content.ContextCompat;
import com.mikepenz.materialdrawer.util.UtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J$\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u001c\u001a\u00020\u00042\b\b\u0001\u0010\u001d\u001a\u00020\u0004H\u0016R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\n\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\u001f"}, d2={"Lcom/mikepenz/materialdrawer/holder/ColorHolder;", "", "()V", "<set-?>", "", "colorInt", "getColorInt", "()I", "setColorInt$materialdrawer", "(I)V", "colorRes", "getColorRes", "setColorRes$materialdrawer", "applyTo", "", "ctx", "Landroid/content/Context;", "drawable", "Landroid/graphics/drawable/GradientDrawable;", "applyToBackground", "view", "Landroid/view/View;", "applyToOr", "textView", "Landroid/widget/TextView;", "colorDefault", "Landroid/content/res/ColorStateList;", "color", "colorStyle", "colorDefaultRes", "Companion", "materialdrawer"})
public class ColorHolder {
    private int colorInt;
    private int colorRes = -1;
    public static final Companion Companion = new Companion(null);

    public final int getColorInt() {
        return this.colorInt;
    }

    public final void setColorInt$materialdrawer(int n) {
        this.colorInt = n;
    }

    public final int getColorRes() {
        return this.colorRes;
    }

    public final void setColorRes$materialdrawer(int n) {
        this.colorRes = n;
    }

    public void applyTo(@NotNull Context ctx, @NotNull GradientDrawable drawable2) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)drawable2, (String)"drawable");
        if (this.colorInt != 0) {
            drawable2.setColor(this.colorInt);
        } else if (this.colorRes != -1) {
            drawable2.setColor(ContextCompat.getColor((Context)ctx, (int)this.colorRes));
        }
    }

    public void applyToBackground(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        if (this.colorInt != 0) {
            view.setBackgroundColor(this.colorInt);
        } else if (this.colorRes != -1) {
            view.setBackgroundResource(this.colorRes);
        }
    }

    public void applyToOr(@NotNull TextView textView, @Nullable ColorStateList colorDefault) {
        block1: {
            block2: {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)textView, (String)"textView");
                    if (this.colorInt == 0) break block0;
                    textView.setTextColor(this.colorInt);
                    break block1;
                }
                if (this.colorRes == -1) break block2;
                textView.setTextColor(ContextCompat.getColor((Context)textView.getContext(), (int)this.colorRes));
                break block1;
            }
            if (colorDefault == null) break block1;
            textView.setTextColor(colorDefault);
        }
    }

    public int color(@NotNull Context ctx, @AttrRes int colorStyle, @ColorRes int colorDefaultRes) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        int color2 = this.color(ctx);
        return color2 == 0 ? UtilsKt.getThemeColorFromAttrOrRes(ctx, colorStyle, colorDefaultRes) : color2;
    }

    public int color(@NotNull Context ctx) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        if (this.colorInt == 0 && this.colorRes != -1) {
            this.colorInt = ContextCompat.getColor((Context)ctx, (int)this.colorRes);
        }
        return this.colorInt;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\"\u0010\u000b\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\rJ,\u0010\u0010\u001a\u00020\u00112\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00112\b\b\u0001\u0010\t\u001a\u00020\u0011J\u0010\u0010\u0013\u001a\u00020\u00062\b\b\u0001\u0010\u0014\u001a\u00020\u0011J\u0010\u0010\u0015\u001a\u00020\u00062\b\b\u0001\u0010\u0016\u001a\u00020\u0011\u00a8\u0006\u0017"}, d2={"Lcom/mikepenz/materialdrawer/holder/ColorHolder$Companion;", "", "()V", "applyToOr", "", "colorHolder", "Lcom/mikepenz/materialdrawer/holder/ColorHolder;", "textView", "Landroid/widget/TextView;", "colorDefault", "Landroid/content/res/ColorStateList;", "applyToOrTransparent", "ctx", "Landroid/content/Context;", "gradientDrawable", "Landroid/graphics/drawable/GradientDrawable;", "color", "", "colorStyle", "fromColor", "colorInt", "fromColorRes", "colorRes", "materialdrawer"})
    public static final class Companion {
        @NotNull
        public final ColorHolder fromColorRes(@ColorRes int colorRes) {
            ColorHolder colorHolder = new ColorHolder();
            colorHolder.setColorRes$materialdrawer(colorRes);
            return colorHolder;
        }

        @NotNull
        public final ColorHolder fromColor(@ColorInt int colorInt) {
            ColorHolder colorHolder = new ColorHolder();
            colorHolder.setColorInt$materialdrawer(colorInt);
            return colorHolder;
        }

        public final int color(@Nullable ColorHolder colorHolder, @NotNull Context ctx, @AttrRes int colorStyle, @ColorRes int colorDefault) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            ColorHolder colorHolder2 = colorHolder;
            return colorHolder2 != null ? colorHolder2.color(ctx, colorStyle, colorDefault) : UtilsKt.getThemeColorFromAttrOrRes(ctx, colorStyle, colorDefault);
        }

        public final int color(@Nullable ColorHolder colorHolder, @NotNull Context ctx) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            ColorHolder colorHolder2 = colorHolder;
            return colorHolder2 != null ? colorHolder2.color(ctx) : 0;
        }

        public final void applyToOr(@Nullable ColorHolder colorHolder, @Nullable TextView textView, @Nullable ColorStateList colorDefault) {
            block1: {
                block0: {
                    if (colorHolder == null || textView == null) break block0;
                    colorHolder.applyToOr(textView, colorDefault);
                    break block1;
                }
                TextView textView2 = textView;
                if (textView2 == null) break block1;
                textView2.setTextColor(colorDefault);
            }
        }

        public final void applyToOrTransparent(@Nullable ColorHolder colorHolder, @NotNull Context ctx, @Nullable GradientDrawable gradientDrawable) {
            block1: {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
                    if (colorHolder == null || gradientDrawable == null) break block0;
                    colorHolder.applyTo(ctx, gradientDrawable);
                    break block1;
                }
                GradientDrawable gradientDrawable2 = gradientDrawable;
                if (gradientDrawable2 == null) break block1;
                gradientDrawable2.setColor(0);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

