/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.holder.BadgeStyle;
import com.mikepenz.materialdrawer.holder.ColorHolder;
import com.mikepenz.materialdrawer.holder.StringHolder;
import com.mikepenz.materialdrawer.model.AbstractDrawerItem;
import com.mikepenz.materialdrawer.model.BaseDescribeableDrawerItem;
import com.mikepenz.materialdrawer.model.BaseViewHolder;
import com.mikepenz.materialdrawer.model.interfaces.ColorfulBadgeable;
import com.mikepenz.materialdrawer.model.interfaces.IDrawerItem;
import com.mikepenz.materialdrawer.util.FixStateListDrawable;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001;B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001e\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u00022\f\u00106\u001a\b\u0012\u0004\u0012\u00020807H\u0016J\u0010\u00109\u001a\u00020\u00022\u0006\u0010'\u001a\u00020$H\u0016J]\u0010:\u001a\u00020\u00002S\u0010,\u001aO\u0012\u0015\u0012\u0013\u0018\u00010$\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0017\u0012\u0015\u0012\u0002\b\u00030(\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b()\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b(*\u0012\u0004\u0012\u00020+\u0018\u00010#H\u0017R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\f8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u000eR[\u0010\"\u001aO\u0012\u0015\u0012\u0013\u0018\u00010$\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0017\u0012\u0015\u0012\u0002\b\u00030(\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b()\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b(*\u0012\u0004\u0012\u00020+\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R:\u0010,\u001a\"\u0012\u0006\u0012\u0004\u0018\u00010$\u0012\b\u0012\u0006\u0012\u0002\b\u00030(\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020+\u0018\u00010#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u0014\u00101\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u000e\u00a8\u0006<"}, d2={"Lcom/mikepenz/materialdrawer/model/ExpandableBadgeDrawerItem;", "Lcom/mikepenz/materialdrawer/model/BaseDescribeableDrawerItem;", "Lcom/mikepenz/materialdrawer/model/ExpandableBadgeDrawerItem$ViewHolder;", "Lcom/mikepenz/materialdrawer/model/interfaces/ColorfulBadgeable;", "()V", "arrowColor", "Lcom/mikepenz/materialdrawer/holder/ColorHolder;", "getArrowColor", "()Lcom/mikepenz/materialdrawer/holder/ColorHolder;", "setArrowColor", "(Lcom/mikepenz/materialdrawer/holder/ColorHolder;)V", "arrowRotationAngleEnd", "", "getArrowRotationAngleEnd", "()I", "setArrowRotationAngleEnd", "(I)V", "arrowRotationAngleStart", "getArrowRotationAngleStart", "setArrowRotationAngleStart", "badge", "Lcom/mikepenz/materialdrawer/holder/StringHolder;", "getBadge", "()Lcom/mikepenz/materialdrawer/holder/StringHolder;", "setBadge", "(Lcom/mikepenz/materialdrawer/holder/StringHolder;)V", "badgeStyle", "Lcom/mikepenz/materialdrawer/holder/BadgeStyle;", "getBadgeStyle", "()Lcom/mikepenz/materialdrawer/holder/BadgeStyle;", "setBadgeStyle", "(Lcom/mikepenz/materialdrawer/holder/BadgeStyle;)V", "layoutRes", "getLayoutRes", "mOnDrawerItemClickListener", "Lkotlin/Function3;", "Landroid/view/View;", "Lkotlin/ParameterName;", "name", "v", "Lcom/mikepenz/materialdrawer/model/interfaces/IDrawerItem;", "item", "position", "", "onDrawerItemClickListener", "getOnDrawerItemClickListener", "()Lkotlin/jvm/functions/Function3;", "setOnDrawerItemClickListener", "(Lkotlin/jvm/functions/Function3;)V", "type", "getType", "bindView", "", "holder", "payloads", "", "", "getViewHolder", "withOnDrawerItemClickListener", "ViewHolder", "materialdrawer"})
public class ExpandableBadgeDrawerItem
extends BaseDescribeableDrawerItem<ExpandableBadgeDrawerItem, ViewHolder>
implements ColorfulBadgeable {
    private Function3<? super View, ? super IDrawerItem<?>, ? super Integer, Boolean> mOnDrawerItemClickListener;
    @Nullable
    private ColorHolder arrowColor;
    private int arrowRotationAngleStart;
    private int arrowRotationAngleEnd = 180;
    @Nullable
    private StringHolder badge;
    @Nullable
    private BadgeStyle badgeStyle = new BadgeStyle();
    @Nullable
    private Function3<? super View, ? super IDrawerItem<?>, ? super Integer, Boolean> onDrawerItemClickListener = new Function3<View, IDrawerItem<?>, Integer, Boolean>(this){
        final /* synthetic */ ExpandableBadgeDrawerItem this$0;

        public final boolean invoke(@Nullable View view, @NotNull IDrawerItem<?> drawerItem, int position) {
            Object object;
            block3: {
                Intrinsics.checkParameterIsNotNull(drawerItem, (String)"drawerItem");
                if (!(drawerItem instanceof AbstractDrawerItem) || !drawerItem.isEnabled() || drawerItem.getSubItems() == null) break block3;
                View view2 = view;
                if (view2 != null) {
                    View view3 = view2;
                    boolean bl = false;
                    boolean bl2 = false;
                    View it = view3;
                    boolean bl3 = false;
                    if (drawerItem.isExpanded()) {
                        ViewCompat.animate((View)view.findViewById(R.id.material_drawer_arrow)).rotation((float)this.this$0.getArrowRotationAngleEnd()).start();
                    } else {
                        ViewCompat.animate((View)view.findViewById(R.id.material_drawer_arrow)).rotation((float)this.this$0.getArrowRotationAngleStart()).start();
                    }
                }
            }
            return (object = ExpandableBadgeDrawerItem.access$getMOnDrawerItemClickListener$p(this.this$0)) != null && (object = (Boolean)object.invoke((Object)view, drawerItem, (Object)position)) != null ? (Boolean)object : false;
        }
        {
            this.this$0 = expandableBadgeDrawerItem;
            super(3);
        }
    };

    @Nullable
    public final ColorHolder getArrowColor() {
        return this.arrowColor;
    }

    public final void setArrowColor(@Nullable ColorHolder colorHolder) {
        this.arrowColor = colorHolder;
    }

    public final int getArrowRotationAngleStart() {
        return this.arrowRotationAngleStart;
    }

    public final void setArrowRotationAngleStart(int n) {
        this.arrowRotationAngleStart = n;
    }

    public final int getArrowRotationAngleEnd() {
        return this.arrowRotationAngleEnd;
    }

    public final void setArrowRotationAngleEnd(int n) {
        this.arrowRotationAngleEnd = n;
    }

    @Override
    @Nullable
    public StringHolder getBadge() {
        return this.badge;
    }

    @Override
    public void setBadge(@Nullable StringHolder stringHolder) {
        this.badge = stringHolder;
    }

    @Override
    @Nullable
    public BadgeStyle getBadgeStyle() {
        return this.badgeStyle;
    }

    @Override
    public void setBadgeStyle(@Nullable BadgeStyle badgeStyle) {
        this.badgeStyle = badgeStyle;
    }

    @Override
    public int getType() {
        return R.id.material_drawer_item_expandable_badge;
    }

    @Override
    @LayoutRes
    public int getLayoutRes() {
        return R.layout.material_drawer_item_expandable_badge;
    }

    @Override
    @Nullable
    public Function3<View, IDrawerItem<?>, Integer, Boolean> getOnDrawerItemClickListener() {
        return this.onDrawerItemClickListener;
    }

    @Override
    public void setOnDrawerItemClickListener(@Nullable Function3<? super View, ? super IDrawerItem<?>, ? super Integer, Boolean> function3) {
        this.onDrawerItemClickListener = function3;
    }

    @Override
    public void bindView(@NotNull ViewHolder holder, @NotNull List<? extends Object> payloads) {
        ColorHolder colorHolder;
        block15: {
            Context ctx;
            block14: {
                Intrinsics.checkParameterIsNotNull((Object)((Object)holder), (String)"holder");
                Intrinsics.checkParameterIsNotNull(payloads, (String)"payloads");
                super.bindView((RecyclerView.ViewHolder)holder, payloads);
                View view = holder.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"holder.itemView");
                ctx = view.getContext();
                this.bindViewHelper(holder);
                boolean badgeVisible = StringHolder.Companion.applyToOrHide(this.getBadge(), holder.getBadge());
                if (badgeVisible) {
                    BadgeStyle badgeStyle = this.getBadgeStyle();
                    if (badgeStyle != null) {
                        TextView textView = holder.getBadge();
                        Context context = ctx;
                        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"ctx");
                        badgeStyle.style(textView, this.getColor(context));
                    }
                    holder.getBadge().setVisibility(0);
                } else {
                    holder.getBadge().setVisibility(8);
                }
                if (this.getTypeface() != null) {
                    holder.getBadge().setTypeface(this.getTypeface());
                }
                if ((colorHolder = this.arrowColor) == null) break block14;
                Context context = ctx;
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"ctx");
                int n = colorHolder.color(context);
                boolean bl = false;
                boolean bl2 = false;
                int it = n;
                boolean bl3 = false;
                colorHolder = ColorStateList.valueOf((int)it);
                if (colorHolder != null) break block15;
            }
            Context context = ctx;
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"ctx");
            colorHolder = this.getIconColor(context);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)colorHolder, (String)"this.arrowColor?.color(c\u2026t) } ?: getIconColor(ctx)");
        ColorHolder arrowColor = colorHolder;
        if (Build.VERSION.SDK_INT >= 21) {
            holder.getArrow().setImageTintList((ColorStateList)arrowColor);
        } else if (holder.getArrow().getDrawable() instanceof FixStateListDrawable) {
            Drawable drawable2 = holder.getArrow().getDrawable();
            if (drawable2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.mikepenz.materialdrawer.util.FixStateListDrawable");
            }
            ((FixStateListDrawable)drawable2).setColor((ColorStateList)arrowColor);
        } else {
            ImageView imageView = holder.getArrow();
            Drawable drawable3 = holder.getArrow().getDrawable();
            Intrinsics.checkExpressionValueIsNotNull((Object)drawable3, (String)"holder.arrow.drawable");
            imageView.setImageDrawable((Drawable)new FixStateListDrawable(drawable3, (ColorStateList)arrowColor));
        }
        holder.getArrow().clearAnimation();
        if (!this.isExpanded()) {
            holder.getArrow().setRotation((float)this.arrowRotationAngleStart);
        } else {
            holder.getArrow().setRotation((float)this.arrowRotationAngleEnd);
        }
        IDrawerItem iDrawerItem = this;
        View view = holder.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"holder.itemView");
        this.onPostBindView(iDrawerItem, view);
    }

    @Override
    @Deprecated(message="Please consider to replace with the actual property setter")
    @NotNull
    public ExpandableBadgeDrawerItem withOnDrawerItemClickListener(@Nullable Function3<? super View, ? super IDrawerItem<?>, ? super Integer, Boolean> onDrawerItemClickListener2) {
        this.mOnDrawerItemClickListener = onDrawerItemClickListener2;
        return this;
    }

    @Override
    @NotNull
    public ViewHolder getViewHolder(@NotNull View v) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        return new ViewHolder(v);
    }

    public static final /* synthetic */ Function3 access$getMOnDrawerItemClickListener$p(ExpandableBadgeDrawerItem $this) {
        return $this.mOnDrawerItemClickListener;
    }

    public static final /* synthetic */ void access$setMOnDrawerItemClickListener$p(ExpandableBadgeDrawerItem $this, Function3 function3) {
        $this.mOnDrawerItemClickListener = function3;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/mikepenz/materialdrawer/model/ExpandableBadgeDrawerItem$ViewHolder;", "Lcom/mikepenz/materialdrawer/model/BaseViewHolder;", "view", "Landroid/view/View;", "(Landroid/view/View;)V", "arrow", "Landroid/widget/ImageView;", "getArrow", "()Landroid/widget/ImageView;", "badge", "Landroid/widget/TextView;", "getBadge", "()Landroid/widget/TextView;", "materialdrawer"})
    public static final class ViewHolder
    extends BaseViewHolder {
        @NotNull
        private final ImageView arrow;
        @NotNull
        private final TextView badge;

        @NotNull
        public final ImageView getArrow() {
            return this.arrow;
        }

        @NotNull
        public final TextView getBadge() {
            return this.badge;
        }

        public ViewHolder(@NotNull View view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            super(view);
            View view2 = view.findViewById(R.id.material_drawer_arrow);
            Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"view.findViewById(R.id.material_drawer_arrow)");
            this.arrow = (ImageView)view2;
            View view3 = view.findViewById(R.id.material_drawer_badge);
            Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"view.findViewById(R.id.material_drawer_badge)");
            this.badge = (TextView)view3;
            this.arrow.setImageDrawable(AppCompatResources.getDrawable((Context)view.getContext(), (int)R.drawable.material_drawer_ico_chevron_down));
        }
    }
}

