/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.parser.xml;

import com.nepxion.discovery.common.entity.AddressWeightEntity;
import com.nepxion.discovery.common.entity.ConditionType;
import com.nepxion.discovery.common.entity.CountFilterEntity;
import com.nepxion.discovery.common.entity.DiscoveryEntity;
import com.nepxion.discovery.common.entity.FilterHolderEntity;
import com.nepxion.discovery.common.entity.FilterType;
import com.nepxion.discovery.common.entity.HostFilterEntity;
import com.nepxion.discovery.common.entity.MapWeightEntity;
import com.nepxion.discovery.common.entity.ParameterEntity;
import com.nepxion.discovery.common.entity.ParameterServiceEntity;
import com.nepxion.discovery.common.entity.RegionEntity;
import com.nepxion.discovery.common.entity.RegionFilterEntity;
import com.nepxion.discovery.common.entity.RegionWeightEntity;
import com.nepxion.discovery.common.entity.RegisterEntity;
import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.common.entity.StrategyBlacklistEntity;
import com.nepxion.discovery.common.entity.StrategyConditionBlueGreenEntity;
import com.nepxion.discovery.common.entity.StrategyConditionGrayEntity;
import com.nepxion.discovery.common.entity.StrategyCustomizationEntity;
import com.nepxion.discovery.common.entity.StrategyEntity;
import com.nepxion.discovery.common.entity.StrategyHeaderEntity;
import com.nepxion.discovery.common.entity.StrategyRouteEntity;
import com.nepxion.discovery.common.entity.StrategyRouteType;
import com.nepxion.discovery.common.entity.VersionEntity;
import com.nepxion.discovery.common.entity.VersionFilterEntity;
import com.nepxion.discovery.common.entity.VersionWeightEntity;
import com.nepxion.discovery.common.entity.WeightEntity;
import com.nepxion.discovery.common.entity.WeightEntityWrapper;
import com.nepxion.discovery.common.entity.WeightFilterEntity;
import com.nepxion.discovery.common.entity.WeightType;
import com.nepxion.discovery.common.exception.DiscoveryException;
import com.nepxion.discovery.common.util.StringUtil;
import com.nepxion.discovery.plugin.framework.parser.PluginConfigParser;
import com.nepxion.discovery.plugin.framework.parser.xml.dom4j.Dom4JReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlConfigParser
implements PluginConfigParser {
    private static final Logger LOG = LoggerFactory.getLogger(XmlConfigParser.class);

    @Override
    public RuleEntity parse(String config) {
        if (StringUtils.isEmpty((CharSequence)config)) {
            throw new DiscoveryException("Config is null or empty");
        }
        try {
            Document document = Dom4JReader.getDocument(config);
            Element rootElement = document.getRootElement();
            return this.parseRoot(config, rootElement);
        }
        catch (Exception e) {
            throw new DiscoveryException(e.getMessage(), (Throwable)e);
        }
    }

    private RuleEntity parseRoot(String config, Element element) {
        LOG.info("Start to parse rule from xml...");
        int registerElementCount = element.elements("register").size();
        if (registerElementCount > 1) {
            throw new DiscoveryException("Allow only one element[register] to be configed");
        }
        int discoveryElementCount = element.elements("discovery").size();
        if (discoveryElementCount > 1) {
            throw new DiscoveryException("Allow only one element[discovery] to be configed");
        }
        int strategyElementCount = element.elements("strategy").size();
        if (strategyElementCount > 1) {
            throw new DiscoveryException("Allow only one element[strategy] to be configed");
        }
        int strategyCustomizationElementCount = element.elements("strategy-customization").size();
        if (strategyCustomizationElementCount > 1) {
            throw new DiscoveryException("Allow only one element[strategy-customization] to be configed");
        }
        int strategyBlacklistElementCount = element.elements("strategy-blacklist").size();
        if (strategyBlacklistElementCount > 1) {
            throw new DiscoveryException("Allow only one element[strategy-blacklist] to be configed");
        }
        int parameterElementCount = element.elements("parameter").size();
        if (parameterElementCount > 1) {
            throw new DiscoveryException("Allow only one element[parameter] to be configed");
        }
        RegisterEntity registerEntity = null;
        DiscoveryEntity discoveryEntity = null;
        StrategyEntity strategyEntity = null;
        StrategyCustomizationEntity strategyCustomizationEntity = null;
        StrategyBlacklistEntity strategyBlacklistEntity = null;
        ParameterEntity parameterEntity = null;
        Iterator elementIterator = element.elementIterator();
        while (elementIterator.hasNext()) {
            Element childElement = (Element)elementIterator.next();
            if (StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"register")) {
                registerEntity = new RegisterEntity();
                this.parseRegister(childElement, registerEntity);
                continue;
            }
            if (StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"discovery")) {
                discoveryEntity = new DiscoveryEntity();
                this.parseDiscovery(childElement, discoveryEntity);
                continue;
            }
            if (StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"strategy")) {
                strategyEntity = new StrategyEntity();
                this.parseStrategy(childElement, strategyEntity);
                continue;
            }
            if (StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"strategy-customization")) {
                strategyCustomizationEntity = new StrategyCustomizationEntity();
                this.parseStrategyCustomization(childElement, strategyCustomizationEntity);
                continue;
            }
            if (StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"strategy-blacklist")) {
                strategyBlacklistEntity = new StrategyBlacklistEntity();
                this.parseStrategyBlacklist(childElement, strategyBlacklistEntity);
                continue;
            }
            if (!StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"parameter")) continue;
            parameterEntity = new ParameterEntity();
            this.parseParameter(childElement, parameterEntity);
        }
        RuleEntity ruleEntity = new RuleEntity();
        ruleEntity.setRegisterEntity(registerEntity);
        ruleEntity.setDiscoveryEntity(discoveryEntity);
        ruleEntity.setStrategyEntity(strategyEntity);
        ruleEntity.setStrategyCustomizationEntity(strategyCustomizationEntity);
        ruleEntity.setStrategyBlacklistEntity(strategyBlacklistEntity);
        ruleEntity.setParameterEntity(parameterEntity);
        ruleEntity.setContent(config);
        LOG.info("Rule content=\n{}", (Object)config);
        return ruleEntity;
    }

    private void parseRegister(Element element, RegisterEntity registerEntity) {
        Iterator elementIterator = element.elementIterator();
        while (elementIterator.hasNext()) {
            Element childElement = (Element)elementIterator.next();
            if (StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"blacklist")) {
                this.parseHostFilter(childElement, "blacklist", (FilterHolderEntity)registerEntity);
                continue;
            }
            if (StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"whitelist")) {
                this.parseHostFilter(childElement, "whitelist", (FilterHolderEntity)registerEntity);
                continue;
            }
            if (!StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"count")) continue;
            this.parseCountFilter(childElement, registerEntity);
        }
    }

    private void parseDiscovery(Element element, DiscoveryEntity discoveryEntity) {
        Iterator elementIterator = element.elementIterator();
        while (elementIterator.hasNext()) {
            Element childElement = (Element)elementIterator.next();
            if (StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"blacklist")) {
                this.parseHostFilter(childElement, "blacklist", (FilterHolderEntity)discoveryEntity);
                continue;
            }
            if (StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"whitelist")) {
                this.parseHostFilter(childElement, "whitelist", (FilterHolderEntity)discoveryEntity);
                continue;
            }
            if (StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"version")) {
                this.parseVersionFilter(childElement, discoveryEntity);
                continue;
            }
            if (StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"region")) {
                this.parseRegionFilter(childElement, discoveryEntity);
                continue;
            }
            if (!StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"weight")) continue;
            this.parseWeightFilter(childElement, discoveryEntity);
        }
    }

    private void parseStrategy(Element element, StrategyEntity strategyEntity) {
        int versionElementCount = element.elements("version").size();
        if (versionElementCount > 1) {
            throw new DiscoveryException("Allow only one element[version] to be configed");
        }
        int regionElementCount = element.elements("region").size();
        if (regionElementCount > 1) {
            throw new DiscoveryException("Allow only one element[region] to be configed");
        }
        int addressElementCount = element.elements("address").size();
        if (addressElementCount > 1) {
            throw new DiscoveryException("Allow only one element[address] to be configed");
        }
        int versionWeightElementCount = element.elements("version-weight").size();
        if (versionWeightElementCount > 1) {
            throw new DiscoveryException("Allow only one element[version-weight] to be configed");
        }
        int regionWeightElementCount = element.elements("region-weight").size();
        if (regionWeightElementCount > 1) {
            throw new DiscoveryException("Allow only one element[region-weight] to be configed");
        }
        Iterator elementIterator = element.elementIterator();
        while (elementIterator.hasNext()) {
            Element childElement = (Element)elementIterator.next();
            if (StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"version")) {
                String versionValue = childElement.getTextTrim();
                strategyEntity.setVersionValue(versionValue);
                continue;
            }
            if (StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"region")) {
                String regionValue = childElement.getTextTrim();
                strategyEntity.setRegionValue(regionValue);
                continue;
            }
            if (StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"address")) {
                String addressValue = childElement.getTextTrim();
                strategyEntity.setAddressValue(addressValue);
                continue;
            }
            if (StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"version-weight")) {
                String versionWeightValue = childElement.getTextTrim();
                strategyEntity.setVersionWeightValue(versionWeightValue);
                continue;
            }
            if (!StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"region-weight")) continue;
            String regionWeightValue = childElement.getTextTrim();
            strategyEntity.setRegionWeightValue(regionWeightValue);
        }
    }

    private void parseStrategyCustomization(Element element, StrategyCustomizationEntity strategyCustomizationEntity) {
        Iterator elementIterator = element.elementIterator();
        while (elementIterator.hasNext()) {
            Element childElement = (Element)elementIterator.next();
            if (StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"conditions")) {
                Attribute typeAttribute = childElement.attribute("type");
                if (typeAttribute == null) {
                    throw new DiscoveryException("Attribute[type] in element[" + childElement.getName() + "] is missing");
                }
                String type = typeAttribute.getData().toString().trim();
                ConditionType conditionType = ConditionType.fromString((String)type);
                switch (conditionType) {
                    case BLUE_GREEN: {
                        this.parseStrategyConditionBlueGreen(childElement, strategyCustomizationEntity);
                        break;
                    }
                    case GRAY: {
                        this.parseStrategyConditionGray(childElement, strategyCustomizationEntity);
                    }
                }
                continue;
            }
            if (StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"routes")) {
                this.parseStrategyRoute(childElement, strategyCustomizationEntity);
                continue;
            }
            if (!StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"headers")) continue;
            this.parseStrategyHeader(childElement, strategyCustomizationEntity);
        }
    }

    private void parseStrategyBlacklist(Element element, StrategyBlacklistEntity strategyBlacklistEntity) {
        ArrayList idList = new ArrayList();
        ArrayList addressList = new ArrayList();
        Iterator elementIterator = element.elementIterator();
        while (elementIterator.hasNext()) {
            Element childElement = (Element)elementIterator.next();
            Attribute valueAttribute = childElement.attribute("value");
            if (valueAttribute == null) {
                throw new DiscoveryException("Attribute[value] in element[" + childElement.getName() + "] is missing");
            }
            String value = valueAttribute.getData().toString().trim();
            List valueList = StringUtil.splitToList((String)value);
            if (!CollectionUtils.isNotEmpty((Collection)valueList)) continue;
            if (StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"id")) {
                idList.addAll(valueList);
                continue;
            }
            if (!StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"address")) continue;
            addressList.addAll(valueList);
        }
        if (CollectionUtils.isNotEmpty(idList)) {
            strategyBlacklistEntity.setIdList(idList);
        }
        if (CollectionUtils.isNotEmpty(addressList)) {
            strategyBlacklistEntity.setAddressList(addressList);
        }
    }

    private void parseParameter(Element element, ParameterEntity parameterEntity) {
        Map parameterServiceMap = parameterEntity.getParameterServiceMap();
        Iterator elementIterator = element.elementIterator();
        while (elementIterator.hasNext()) {
            Element childElement = (Element)elementIterator.next();
            if (!StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"service")) continue;
            Attribute serviceNameAttribute = childElement.attribute("service-name");
            if (serviceNameAttribute == null) {
                throw new DiscoveryException("Attribute[service-name] in element[" + childElement.getName() + "] is missing");
            }
            String serviceName = serviceNameAttribute.getData().toString().trim();
            ParameterServiceEntity parameterServiceEntity = new ParameterServiceEntity();
            Iterator iterator = childElement.attributeIterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                String key = attribute.getName();
                String value = attribute.getData().toString().trim();
                parameterServiceEntity.getParameterMap().put(key, value);
            }
            ArrayList<ParameterServiceEntity> parameterServiceEntityList = (ArrayList<ParameterServiceEntity>)parameterServiceMap.get(serviceName);
            if (parameterServiceEntityList == null) {
                parameterServiceEntityList = new ArrayList<ParameterServiceEntity>();
                parameterServiceMap.put(serviceName, parameterServiceEntityList);
            }
            parameterServiceEntityList.add(parameterServiceEntity);
        }
    }

    private void parseHostFilter(Element element, String filterTypeValue, FilterHolderEntity filterHolderEntity) {
        HostFilterEntity hostFilterEntity = filterHolderEntity.getHostFilterEntity();
        if (hostFilterEntity != null) {
            throw new DiscoveryException("Allow only one filter element to be configed, [blacklist] or [whitelist]");
        }
        hostFilterEntity = new HostFilterEntity();
        hostFilterEntity.setFilterType(FilterType.fromString((String)filterTypeValue));
        Attribute globalFilterAttribute = element.attribute("filter-value");
        if (globalFilterAttribute != null) {
            String globalFilterValue = globalFilterAttribute.getData().toString().trim();
            List globalFilterValueList = StringUtil.splitToList((String)globalFilterValue);
            hostFilterEntity.setFilterValueList(globalFilterValueList);
        }
        Map filterMap = hostFilterEntity.getFilterMap();
        Iterator elementIterator = element.elementIterator();
        while (elementIterator.hasNext()) {
            Element childElement = (Element)elementIterator.next();
            if (!StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"service")) continue;
            Attribute serviceNameAttribute = childElement.attribute("service-name");
            if (serviceNameAttribute == null) {
                throw new DiscoveryException("Attribute[service-name] in element[" + childElement.getName() + "] is missing");
            }
            String serviceName = serviceNameAttribute.getData().toString().trim();
            Attribute filterValueAttribute = childElement.attribute("filter-value");
            List filterValueList = null;
            if (filterValueAttribute != null) {
                String filterValue = filterValueAttribute.getData().toString().trim();
                filterValueList = StringUtil.splitToList((String)filterValue);
            }
            filterMap.put(serviceName, filterValueList);
        }
        filterHolderEntity.setHostFilterEntity(hostFilterEntity);
    }

    private void parseCountFilter(Element element, RegisterEntity registerEntity) {
        String globalFilterValue;
        CountFilterEntity countFilterEntity = registerEntity.getCountFilterEntity();
        if (countFilterEntity != null) {
            throw new DiscoveryException("Allow only one element[count] to be configed");
        }
        countFilterEntity = new CountFilterEntity();
        Attribute globalFilterAttribute = element.attribute("filter-value");
        if (globalFilterAttribute != null && StringUtils.isNotEmpty((CharSequence)(globalFilterValue = globalFilterAttribute.getData().toString().trim()))) {
            Integer globalValue = null;
            try {
                globalValue = Integer.valueOf(globalFilterValue);
            }
            catch (Exception e) {
                throw new DiscoveryException("Attribute[filter-value] value in element[" + element.getName() + "] is invalid, must be int type", (Throwable)e);
            }
            countFilterEntity.setFilterValue(globalValue);
        }
        Map filterMap = countFilterEntity.getFilterMap();
        Iterator elementIterator = element.elementIterator();
        while (elementIterator.hasNext()) {
            String filterValue;
            Element childElement = (Element)elementIterator.next();
            if (!StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"service")) continue;
            Attribute serviceNameAttribute = childElement.attribute("service-name");
            if (serviceNameAttribute == null) {
                throw new DiscoveryException("Attribute[service-name] in element[" + childElement.getName() + "] is missing");
            }
            String serviceName = serviceNameAttribute.getData().toString().trim();
            Integer value = null;
            Attribute filterValueAttribute = childElement.attribute("filter-value");
            if (filterValueAttribute != null && StringUtils.isNotEmpty((CharSequence)(filterValue = filterValueAttribute.getData().toString().trim()))) {
                try {
                    value = Integer.valueOf(filterValue);
                }
                catch (Exception e) {
                    throw new DiscoveryException("Attribute[filter-value] value in element[" + childElement.getName() + "] is invalid, must be int type", (Throwable)e);
                }
            }
            filterMap.put(serviceName, value);
        }
        registerEntity.setCountFilterEntity(countFilterEntity);
    }

    private void parseVersionFilter(Element element, DiscoveryEntity discoveryEntity) {
        VersionFilterEntity versionFilterEntity = discoveryEntity.getVersionFilterEntity();
        if (versionFilterEntity != null) {
            throw new DiscoveryException("Allow only one element[version] to be configed");
        }
        versionFilterEntity = new VersionFilterEntity();
        Map versionEntityMap = versionFilterEntity.getVersionEntityMap();
        Iterator elementIterator = element.elementIterator();
        while (elementIterator.hasNext()) {
            ArrayList<VersionEntity> versionEntityList;
            Attribute providerVersionValueAttribute;
            Element childElement = (Element)elementIterator.next();
            if (!StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"service")) continue;
            VersionEntity versionEntity = new VersionEntity();
            Attribute consumerServiceNameAttribute = childElement.attribute("consumer-service-name");
            if (consumerServiceNameAttribute == null) {
                throw new DiscoveryException("Attribute[consumer-service-name] in element[" + childElement.getName() + "] is missing");
            }
            String consumerServiceName = consumerServiceNameAttribute.getData().toString().trim();
            versionEntity.setConsumerServiceName(consumerServiceName);
            Attribute providerServiceNameAttribute = childElement.attribute("provider-service-name");
            if (providerServiceNameAttribute == null) {
                throw new DiscoveryException("Attribute[provider-service-name] in element[" + childElement.getName() + "] is missing");
            }
            String providerServiceName = providerServiceNameAttribute.getData().toString().trim();
            versionEntity.setProviderServiceName(providerServiceName);
            Attribute consumerVersionValueAttribute = childElement.attribute("consumer-version-value");
            if (consumerVersionValueAttribute != null) {
                String consumerVersionValue = consumerVersionValueAttribute.getData().toString().trim();
                List consumerVersionValueList = StringUtil.splitToList((String)consumerVersionValue);
                versionEntity.setConsumerVersionValueList(consumerVersionValueList);
            }
            if ((providerVersionValueAttribute = childElement.attribute("provider-version-value")) != null) {
                String providerVersionValue = providerVersionValueAttribute.getData().toString().trim();
                List providerVersionValueList = StringUtil.splitToList((String)providerVersionValue);
                versionEntity.setProviderVersionValueList(providerVersionValueList);
            }
            if ((versionEntityList = (ArrayList<VersionEntity>)versionEntityMap.get(consumerServiceName)) == null) {
                versionEntityList = new ArrayList<VersionEntity>();
                versionEntityMap.put(consumerServiceName, versionEntityList);
            }
            versionEntityList.add(versionEntity);
        }
        discoveryEntity.setVersionFilterEntity(versionFilterEntity);
    }

    private void parseRegionFilter(Element element, DiscoveryEntity discoveryEntity) {
        RegionFilterEntity regionFilterEntity = discoveryEntity.getRegionFilterEntity();
        if (regionFilterEntity != null) {
            throw new DiscoveryException("Allow only one element[region] to be configed");
        }
        regionFilterEntity = new RegionFilterEntity();
        Map regionEntityMap = regionFilterEntity.getRegionEntityMap();
        Iterator elementIterator = element.elementIterator();
        while (elementIterator.hasNext()) {
            ArrayList<RegionEntity> regionEntityList;
            Attribute providerRegionValueAttribute;
            Element childElement = (Element)elementIterator.next();
            if (!StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"service")) continue;
            RegionEntity regionEntity = new RegionEntity();
            Attribute consumerServiceNameAttribute = childElement.attribute("consumer-service-name");
            if (consumerServiceNameAttribute == null) {
                throw new DiscoveryException("Attribute[consumer-service-name] in element[" + childElement.getName() + "] is missing");
            }
            String consumerServiceName = consumerServiceNameAttribute.getData().toString().trim();
            regionEntity.setConsumerServiceName(consumerServiceName);
            Attribute providerServiceNameAttribute = childElement.attribute("provider-service-name");
            if (providerServiceNameAttribute == null) {
                throw new DiscoveryException("Attribute[provider-service-name] in element[" + childElement.getName() + "] is missing");
            }
            String providerServiceName = providerServiceNameAttribute.getData().toString().trim();
            regionEntity.setProviderServiceName(providerServiceName);
            Attribute consumerRegionValueAttribute = childElement.attribute("consumer-region-value");
            if (consumerRegionValueAttribute != null) {
                String consumerRegionValue = consumerRegionValueAttribute.getData().toString().trim();
                List consumerRegionValueList = StringUtil.splitToList((String)consumerRegionValue);
                regionEntity.setConsumerRegionValueList(consumerRegionValueList);
            }
            if ((providerRegionValueAttribute = childElement.attribute("provider-region-value")) != null) {
                String providerRegionValue = providerRegionValueAttribute.getData().toString().trim();
                List providerRegionValueList = StringUtil.splitToList((String)providerRegionValue);
                regionEntity.setProviderRegionValueList(providerRegionValueList);
            }
            if ((regionEntityList = (ArrayList<RegionEntity>)regionEntityMap.get(consumerServiceName)) == null) {
                regionEntityList = new ArrayList<RegionEntity>();
                regionEntityMap.put(consumerServiceName, regionEntityList);
            }
            regionEntityList.add(regionEntity);
        }
        discoveryEntity.setRegionFilterEntity(regionFilterEntity);
    }

    private void parseWeightFilter(Element element, DiscoveryEntity discoveryEntity) {
        WeightFilterEntity weightFilterEntity = discoveryEntity.getWeightFilterEntity();
        if (weightFilterEntity != null) {
            throw new DiscoveryException("Allow only one element[weight] to be configed");
        }
        weightFilterEntity = new WeightFilterEntity();
        LinkedHashMap<String, ArrayList<WeightEntity>> versionWeightEntityMap = new LinkedHashMap<String, ArrayList<WeightEntity>>();
        ArrayList<WeightEntity> versionWeightEntityList = new ArrayList<WeightEntity>();
        weightFilterEntity.setVersionWeightEntityMap(versionWeightEntityMap);
        weightFilterEntity.setVersionWeightEntityList(versionWeightEntityList);
        LinkedHashMap<String, ArrayList<WeightEntity>> regionWeightEntityMap = new LinkedHashMap<String, ArrayList<WeightEntity>>();
        ArrayList<WeightEntity> regionWeightEntityList = new ArrayList<WeightEntity>();
        weightFilterEntity.setRegionWeightEntityMap(regionWeightEntityMap);
        weightFilterEntity.setRegionWeightEntityList(regionWeightEntityList);
        Iterator elementIterator = element.elementIterator();
        while (elementIterator.hasNext()) {
            String providerWeightValue;
            Attribute providerWeightValueAttribute;
            Element childElement = (Element)elementIterator.next();
            if (StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"service")) {
                WeightEntity weightEntity = new WeightEntity();
                Attribute typeAttribute = childElement.attribute("type");
                if (typeAttribute == null) {
                    throw new DiscoveryException("Attribute[type] in element[" + childElement.getName() + "] is missing");
                }
                String type = typeAttribute.getData().toString().trim();
                WeightType weightType = WeightType.fromString((String)type);
                weightEntity.setType(weightType);
                Attribute consumerServiceNameAttribute = childElement.attribute("consumer-service-name");
                String consumerServiceName = null;
                if (consumerServiceNameAttribute != null) {
                    consumerServiceName = consumerServiceNameAttribute.getData().toString().trim();
                }
                weightEntity.setConsumerServiceName(consumerServiceName);
                Attribute providerServiceNameAttribute = childElement.attribute("provider-service-name");
                if (providerServiceNameAttribute == null) {
                    throw new DiscoveryException("Attribute[provider-service-name] in element[" + childElement.getName() + "] is missing");
                }
                String providerServiceName = providerServiceNameAttribute.getData().toString().trim();
                weightEntity.setProviderServiceName(providerServiceName);
                Attribute providerWeightValueAttribute2 = childElement.attribute("provider-weight-value");
                if (providerWeightValueAttribute2 == null) {
                    throw new DiscoveryException("Attribute[provider-weight-value] in element[" + childElement.getName() + "] is missing");
                }
                String providerWeightValue2 = providerWeightValueAttribute2.getData().toString().trim();
                WeightEntityWrapper.parseWeightEntity((MapWeightEntity)weightEntity, (String)providerWeightValue2);
                if (StringUtils.isNotEmpty((CharSequence)consumerServiceName)) {
                    List<Object> list;
                    if (weightType == WeightType.VERSION) {
                        list = (ArrayList<WeightEntity>)versionWeightEntityMap.get(consumerServiceName);
                        if (list == null) {
                            list = new ArrayList<WeightEntity>();
                            versionWeightEntityMap.put(consumerServiceName, (ArrayList<WeightEntity>)list);
                        }
                        list.add(weightEntity);
                        continue;
                    }
                    if (weightType != WeightType.REGION) continue;
                    list = (List)regionWeightEntityMap.get(consumerServiceName);
                    if (list == null) {
                        list = new ArrayList();
                        regionWeightEntityMap.put(consumerServiceName, (ArrayList<WeightEntity>)list);
                    }
                    list.add(weightEntity);
                    continue;
                }
                if (weightType == WeightType.VERSION) {
                    versionWeightEntityList.add(weightEntity);
                    continue;
                }
                if (weightType != WeightType.REGION) continue;
                regionWeightEntityList.add(weightEntity);
                continue;
            }
            if (StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"version")) {
                VersionWeightEntity versionWeightEntity = weightFilterEntity.getVersionWeightEntity();
                if (versionWeightEntity != null) {
                    throw new DiscoveryException("Allow only one element[version] to be configed");
                }
                versionWeightEntity = new VersionWeightEntity();
                providerWeightValueAttribute = childElement.attribute("provider-weight-value");
                if (providerWeightValueAttribute == null) {
                    throw new DiscoveryException("Attribute[provider-weight-value] in element[" + childElement.getName() + "] is missing");
                }
                providerWeightValue = providerWeightValueAttribute.getData().toString().trim();
                WeightEntityWrapper.parseWeightEntity((MapWeightEntity)versionWeightEntity, (String)providerWeightValue);
                weightFilterEntity.setVersionWeightEntity(versionWeightEntity);
                continue;
            }
            if (!StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"region")) continue;
            RegionWeightEntity regionWeightEntity = weightFilterEntity.getRegionWeightEntity();
            if (regionWeightEntity != null) {
                throw new DiscoveryException("Allow only one element[region] to be configed");
            }
            regionWeightEntity = new RegionWeightEntity();
            providerWeightValueAttribute = childElement.attribute("provider-weight-value");
            if (providerWeightValueAttribute == null) {
                throw new DiscoveryException("Attribute[provider-weight-value] in element[" + childElement.getName() + "] is missing");
            }
            providerWeightValue = providerWeightValueAttribute.getData().toString().trim();
            WeightEntityWrapper.parseWeightEntity((MapWeightEntity)regionWeightEntity, (String)providerWeightValue);
            weightFilterEntity.setRegionWeightEntity(regionWeightEntity);
        }
        discoveryEntity.setWeightFilterEntity(weightFilterEntity);
    }

    private void parseStrategyConditionBlueGreen(Element element, StrategyCustomizationEntity strategyCustomizationEntity) {
        ArrayList<StrategyConditionBlueGreenEntity> strategyConditionBlueGreenEntityList = strategyCustomizationEntity.getStrategyConditionBlueGreenEntityList();
        if (strategyConditionBlueGreenEntityList != null) {
            throw new DiscoveryException("Allow only one element[conditions] for attribute[type]'s value with '" + ConditionType.BLUE_GREEN + "' to be configed");
        }
        strategyConditionBlueGreenEntityList = new ArrayList<StrategyConditionBlueGreenEntity>();
        strategyCustomizationEntity.setStrategyConditionBlueGreenEntityList(strategyConditionBlueGreenEntityList);
        Iterator elementIterator = element.elementIterator();
        while (elementIterator.hasNext()) {
            Attribute regionWeightIdAttribute;
            Attribute versionWeightIdAttribute;
            Attribute addressIdAttribute;
            Attribute regionIdAttribute;
            Element childElement = (Element)elementIterator.next();
            if (!StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"condition")) continue;
            StrategyConditionBlueGreenEntity strategyConditionBlueGreenEntity = new StrategyConditionBlueGreenEntity();
            Attribute idAttribute = childElement.attribute("id");
            if (idAttribute == null) {
                throw new DiscoveryException("Attribute[id] in element[" + childElement.getName() + "] is missing");
            }
            String id = idAttribute.getData().toString().trim();
            strategyConditionBlueGreenEntity.setId(id);
            Attribute headerAttribute = childElement.attribute("header");
            if (headerAttribute == null) {
                throw new DiscoveryException("Attribute[header] in element[" + childElement.getName() + "] is missing");
            }
            String header = headerAttribute.getData().toString().trim();
            strategyConditionBlueGreenEntity.setConditionHeader(header);
            Attribute versionIdAttribute = childElement.attribute("version-id");
            if (versionIdAttribute != null) {
                String versionId = versionIdAttribute.getData().toString().trim();
                strategyConditionBlueGreenEntity.setVersionId(versionId);
            }
            if ((regionIdAttribute = childElement.attribute("region-id")) != null) {
                String regionId = regionIdAttribute.getData().toString().trim();
                strategyConditionBlueGreenEntity.setRegionId(regionId);
            }
            if ((addressIdAttribute = childElement.attribute("address-id")) != null) {
                String addressId = addressIdAttribute.getData().toString().trim();
                strategyConditionBlueGreenEntity.setAddressId(addressId);
            }
            if ((versionWeightIdAttribute = childElement.attribute("version-weight-id")) != null) {
                String versionWeightId = versionWeightIdAttribute.getData().toString().trim();
                strategyConditionBlueGreenEntity.setVersionWeightId(versionWeightId);
            }
            if ((regionWeightIdAttribute = childElement.attribute("region-weight-id")) != null) {
                String regionWeightId = regionWeightIdAttribute.getData().toString().trim();
                strategyConditionBlueGreenEntity.setRegionWeightId(regionWeightId);
            }
            strategyConditionBlueGreenEntityList.add(strategyConditionBlueGreenEntity);
        }
    }

    private void parseStrategyConditionGray(Element element, StrategyCustomizationEntity strategyCustomizationEntity) {
        ArrayList<StrategyConditionGrayEntity> strategyConditionGrayEntityList = strategyCustomizationEntity.getStrategyConditionGrayEntityList();
        if (strategyConditionGrayEntityList != null) {
            throw new DiscoveryException("Allow only one element[conditions] for attribute[type]'s value with '" + ConditionType.GRAY + "' to be configed");
        }
        strategyConditionGrayEntityList = new ArrayList<StrategyConditionGrayEntity>();
        strategyCustomizationEntity.setStrategyConditionGrayEntityList(strategyConditionGrayEntityList);
        Iterator elementIterator = element.elementIterator();
        while (elementIterator.hasNext()) {
            Attribute addressIdAttribute;
            Attribute regionIdAttribute;
            Attribute versionIdAttribute;
            Element childElement = (Element)elementIterator.next();
            if (!StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"condition")) continue;
            StrategyConditionGrayEntity strategyConditionGrayEntity = new StrategyConditionGrayEntity();
            Attribute idAttribute = childElement.attribute("id");
            if (idAttribute == null) {
                throw new DiscoveryException("Attribute[id] in element[" + childElement.getName() + "] is missing");
            }
            String id = idAttribute.getData().toString().trim();
            strategyConditionGrayEntity.setId(id);
            Attribute headerAttribute = childElement.attribute("header");
            if (headerAttribute != null) {
                String header = headerAttribute.getData().toString().trim();
                strategyConditionGrayEntity.setConditionHeader(header);
            }
            if ((versionIdAttribute = childElement.attribute("version-id")) != null) {
                String versionId = versionIdAttribute.getData().toString().trim();
                VersionWeightEntity versionWeightEntity = new VersionWeightEntity();
                WeightEntityWrapper.parseWeightEntity((MapWeightEntity)versionWeightEntity, (String)versionId);
                strategyConditionGrayEntity.setVersionWeightEntity(versionWeightEntity);
            }
            if ((regionIdAttribute = childElement.attribute("region-id")) != null) {
                String regionId = regionIdAttribute.getData().toString().trim();
                RegionWeightEntity regionWeightEntity = new RegionWeightEntity();
                WeightEntityWrapper.parseWeightEntity((MapWeightEntity)regionWeightEntity, (String)regionId);
                strategyConditionGrayEntity.setRegionWeightEntity(regionWeightEntity);
            }
            if ((addressIdAttribute = childElement.attribute("address-id")) != null) {
                String addressId = addressIdAttribute.getData().toString().trim();
                AddressWeightEntity addressWeightEntity = new AddressWeightEntity();
                WeightEntityWrapper.parseWeightEntity((MapWeightEntity)addressWeightEntity, (String)addressId);
                strategyConditionGrayEntity.setAddressWeightEntity(addressWeightEntity);
            }
            strategyConditionGrayEntityList.add(strategyConditionGrayEntity);
        }
    }

    private void parseStrategyRoute(Element element, StrategyCustomizationEntity strategyCustomizationEntity) {
        ArrayList<StrategyRouteEntity> strategyRouteEntityList = strategyCustomizationEntity.getStrategyRouteEntityList();
        if (strategyRouteEntityList != null) {
            throw new DiscoveryException("Allow only one element[routes] to be configed");
        }
        strategyRouteEntityList = new ArrayList<StrategyRouteEntity>();
        strategyCustomizationEntity.setStrategyRouteEntityList(strategyRouteEntityList);
        Iterator elementIterator = element.elementIterator();
        while (elementIterator.hasNext()) {
            Element childElement = (Element)elementIterator.next();
            if (!StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"route")) continue;
            StrategyRouteEntity strategyRouteEntity = new StrategyRouteEntity();
            Attribute idAttribute = childElement.attribute("id");
            if (idAttribute == null) {
                throw new DiscoveryException("Attribute[id] in element[" + childElement.getName() + "] is missing");
            }
            String id = idAttribute.getData().toString().trim();
            strategyRouteEntity.setId(id);
            Attribute typeAttribute = childElement.attribute("type");
            if (typeAttribute == null) {
                throw new DiscoveryException("Attribute[type] in element[" + childElement.getName() + "] is missing");
            }
            String type = typeAttribute.getData().toString().trim();
            StrategyRouteType strategyRouteType = StrategyRouteType.fromString((String)type);
            strategyRouteEntity.setType(strategyRouteType);
            String value = childElement.getTextTrim();
            strategyRouteEntity.setValue(value);
            strategyRouteEntityList.add(strategyRouteEntity);
        }
    }

    private void parseStrategyHeader(Element element, StrategyCustomizationEntity strategyCustomizationEntity) {
        StrategyHeaderEntity strategyHeaderEntity = strategyCustomizationEntity.getStrategyHeaderEntity();
        if (strategyHeaderEntity != null) {
            throw new DiscoveryException("Allow only one element[headers] to be configed");
        }
        strategyHeaderEntity = new StrategyHeaderEntity();
        strategyCustomizationEntity.setStrategyHeaderEntity(strategyHeaderEntity);
        Iterator elementIterator = element.elementIterator();
        while (elementIterator.hasNext()) {
            Element childElement = (Element)elementIterator.next();
            if (!StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"header")) continue;
            Attribute keyAttribute = childElement.attribute("key");
            if (keyAttribute == null) {
                throw new DiscoveryException("Attribute[key] in element[" + childElement.getName() + "] is missing");
            }
            String key = keyAttribute.getData().toString().trim();
            Attribute valueAttribute = childElement.attribute("value");
            if (valueAttribute == null) {
                throw new DiscoveryException("Attribute[value] in element[" + childElement.getName() + "] is missing");
            }
            String value = valueAttribute.getData().toString().trim();
            strategyHeaderEntity.getHeaderMap().put(key, value);
        }
    }
}

