/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.eventbus.thread.policy;

import com.nepxion.eventbus.thread.policy.RejectedRunnable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RejectedPolicyWithReport
implements RejectedExecutionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RejectedPolicyWithReport.class);
    private final String threadName;

    public RejectedPolicyWithReport() {
        this(null);
    }

    public RejectedPolicyWithReport(String threadName) {
        this.threadName = threadName;
    }

    @Override
    public void rejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
        if (this.threadName != null) {
            LOG.error("Thread pool [{}] is exhausted, executor={}", (Object)this.threadName, (Object)executor.toString());
        }
        if (runnable instanceof RejectedRunnable) {
            ((RejectedRunnable)runnable).rejected();
        } else if (!executor.isShutdown()) {
            BlockingQueue<Runnable> queue = executor.getQueue();
            int discardSize = queue.size() >> 1;
            for (int i = 0; i < discardSize; ++i) {
                queue.poll();
            }
            try {
                queue.put(runnable);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

