/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud;

import com.netease.cloud.Request;
import com.netease.cloud.WebServiceRequest;
import com.netease.cloud.http.HttpMethodName;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class DefaultRequest<T>
implements Request<T> {
    private String resourcePath;
    private Map<String, String> parameters = new HashMap<String, String>();
    private Map<String, String> headers = new HashMap<String, String>();
    private URI endpoint;
    private String serviceName;
    private final WebServiceRequest originalRequest;
    private HttpMethodName httpMethod = HttpMethodName.POST;
    private InputStream content;

    public DefaultRequest(WebServiceRequest originalRequest, String serviceName) {
        this.serviceName = serviceName;
        this.originalRequest = originalRequest;
    }

    public DefaultRequest(String serviceName) {
        this(null, serviceName);
    }

    @Override
    public WebServiceRequest getOriginalRequest() {
        return this.originalRequest;
    }

    @Override
    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    @Override
    public void addParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public Request<T> withParameter(String name, String value) {
        this.addParameter(name, value);
        return this;
    }

    @Override
    public HttpMethodName getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public void setHttpMethod(HttpMethodName httpMethod) {
        this.httpMethod = httpMethod;
    }

    @Override
    public void setEndpoint(URI endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public URI getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public InputStream getContent() {
        return this.content;
    }

    @Override
    public void setContent(InputStream content) {
        this.content = content;
    }

    @Override
    public void setHeaders(Map<String, String> headers) {
        this.headers.clear();
        this.headers.putAll(headers);
    }

    @Override
    public void setParameters(Map<String, String> parameters) {
        this.parameters.clear();
        this.parameters.putAll(parameters);
    }

    public String toString() {
        String value;
        StringBuilder builder = new StringBuilder();
        builder.append(this.getHttpMethod().toString() + " ");
        builder.append(this.getEndpoint().toString() + " ");
        builder.append("/" + (this.getResourcePath() != null ? this.getResourcePath() : "") + " ");
        if (!this.getParameters().isEmpty()) {
            builder.append("Parameters: (");
            for (String key : this.getParameters().keySet()) {
                value = this.getParameters().get(key);
                builder.append(key + ": " + value + ", ");
            }
            builder.append(") ");
        }
        if (!this.getHeaders().isEmpty()) {
            builder.append("Headers: (");
            for (String key : this.getHeaders().keySet()) {
                value = this.getHeaders().get(key);
                builder.append(key + ": " + value + ", ");
            }
            builder.append(") ");
        }
        return builder.toString();
    }
}

