/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.auth;

import com.netease.cloud.auth.Credentials;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertiesCredentials
implements Credentials {
    private final String accessKey;
    private final String secretAccessKey;

    public PropertiesCredentials(File file) throws FileNotFoundException, IOException, IllegalArgumentException {
        if (!file.exists()) {
            throw new FileNotFoundException("File doesn't exist:  " + file.getAbsolutePath());
        }
        Properties accountProperties = new Properties();
        accountProperties.load(new FileInputStream(file));
        if (accountProperties.getProperty("accessKey") == null || accountProperties.getProperty("secretKey") == null) {
            throw new IllegalArgumentException("The specified file (" + file.getAbsolutePath() + ") doesn't contain the expected properties 'accessKey' and 'secretKey'.");
        }
        this.accessKey = accountProperties.getProperty("accessKey");
        this.secretAccessKey = accountProperties.getProperty("secretKey");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesCredentials(InputStream inputStream) throws IOException {
        Properties accountProperties = new Properties();
        try {
            accountProperties.load(inputStream);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        if (accountProperties.getProperty("accessKey") == null || accountProperties.getProperty("secretKey") == null) {
            throw new IllegalArgumentException("The specified properties data doesn't contain the expected properties 'accessKey' and 'secretKey'.");
        }
        this.accessKey = accountProperties.getProperty("accessKey");
        this.secretAccessKey = accountProperties.getProperty("secretKey");
    }

    @Override
    public String getAccessKeyId() {
        return this.accessKey;
    }

    @Override
    public String getSecretKey() {
        return this.secretAccessKey;
    }
}

