/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.http;

import com.netease.cloud.ClientException;
import com.netease.cloud.ServiceException;
import com.netease.cloud.http.HttpResponse;
import com.netease.cloud.http.HttpResponseHandler;
import com.netease.cloud.transform.Unmarshaller;
import com.netease.cloud.util.XpathUtils;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DefaultErrorResponseHandler
implements HttpResponseHandler<ServiceException> {
    private List<Unmarshaller<ServiceException, Node>> unmarshallerList;

    public DefaultErrorResponseHandler(List<Unmarshaller<ServiceException, Node>> unmarshallerList) {
        this.unmarshallerList = unmarshallerList;
    }

    @Override
    public ServiceException handle(HttpResponse errorResponse) throws Exception {
        Document document = XpathUtils.documentFrom(errorResponse.getContent());
        for (Unmarshaller<ServiceException, Node> unmarshaller : this.unmarshallerList) {
            ServiceException ase = unmarshaller.unmarshall(document);
            if (ase == null) continue;
            ase.setStatusCode(errorResponse.getStatusCode());
            return ase;
        }
        throw new ClientException("Unable to unmarshall error response from service");
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }
}

