/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.http;

import com.netease.cloud.ClientConfiguration;
import com.netease.cloud.http.NeteaseHttpClient;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

class HttpClientFactory {
    HttpClientFactory() {
    }

    public CloseableHttpClient createHttpClient(ClientConfiguration config, PoolingHttpClientConnectionManager poolingHttpClientConnectionManager) {
        String userAgent = config.getUserAgent();
        if (!userAgent.equals(ClientConfiguration.DEFAULT_USER_AGENT)) {
            userAgent = userAgent + ", " + ClientConfiguration.DEFAULT_USER_AGENT;
        }
        int socketSendBufferSizeHint = config.getSocketBufferSizeHints()[0];
        int socketReceiveBufferSizeHint = config.getSocketBufferSizeHints()[1];
        ConnectionConfig connectionConfig = socketSendBufferSizeHint > 0 || socketReceiveBufferSizeHint > 0 ? ConnectionConfig.custom().setBufferSize(Math.max(socketSendBufferSizeHint, socketReceiveBufferSizeHint)).build() : ConnectionConfig.custom().build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(config.getConnectionTimeout()).setConnectionRequestTimeout(config.getConnectionTimeout()).build();
        DefaultProxyRoutePlanner defaultProxyRoutePlanner = null;
        SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(config.getSocketTimeout()).build();
        BasicCredentialsProvider credentialsProvider = null;
        String proxyHost = config.getProxyHost();
        int proxyPort = config.getProxyPort();
        if (proxyHost != null && proxyPort > 0) {
            NeteaseHttpClient.log.info("Configuring Proxy. Proxy Host: " + proxyHost + " Proxy Port: " + proxyPort);
            HttpHost proxyHttpHost = new HttpHost(proxyHost, proxyPort);
            defaultProxyRoutePlanner = new DefaultProxyRoutePlanner(proxyHttpHost);
            String proxyUsername = config.getProxyUsername();
            String proxyPassword = config.getProxyPassword();
            String proxyDomain = config.getProxyDomain();
            String proxyWorkstation = config.getProxyWorkstation();
            if (proxyUsername != null && proxyPassword != null) {
                credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new NTCredentials(proxyUsername, proxyPassword, proxyWorkstation, proxyDomain));
            }
        }
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManager).setDefaultConnectionConfig(connectionConfig).setUserAgent(userAgent).setDefaultSocketConfig(socketConfig).setDefaultRequestConfig(requestConfig).setDefaultCredentialsProvider(credentialsProvider).setRoutePlanner(defaultProxyRoutePlanner).build();
    }
}

