/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.http;

import com.netease.cloud.ClientConfiguration;
import com.netease.cloud.ClientException;
import com.netease.cloud.Request;
import com.netease.cloud.ResponseMetadata;
import com.netease.cloud.ServiceException;
import com.netease.cloud.WebServiceRequest;
import com.netease.cloud.WebServiceResponse;
import com.netease.cloud.handlers.RequestHandler;
import com.netease.cloud.http.ConnectionManagerFactory;
import com.netease.cloud.http.ExecutionContext;
import com.netease.cloud.http.HttpClientFactory;
import com.netease.cloud.http.HttpMethodReleaseInputStream;
import com.netease.cloud.http.HttpRequestFactory;
import com.netease.cloud.http.HttpResponse;
import com.netease.cloud.http.HttpResponseHandler;
import com.netease.cloud.http.IdleConnectionReaper;
import com.netease.cloud.internal.CustomBackoffStrategy;
import com.netease.cloud.util.ResponseMetadataCache;
import com.netease.cloud.util.TimingInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeteaseHttpClient {
    private static final Log requestLog = LogFactory.getLog((String)"com.netease.cloud.request");
    static final Logger log = LoggerFactory.getLogger(NeteaseHttpClient.class);
    private CloseableHttpClient httpClient;
    private PoolingHttpClientConnectionManager poolingHttpClientConnectionManager;
    private static final int MAX_BACKOFF_IN_MILLISECONDS = 20000;
    private final ClientConfiguration config;
    private ResponseMetadataCache responseMetadataCache = new ResponseMetadataCache(50);
    private static final Random random = new Random();
    private static HttpRequestFactory httpRequestFactory = new HttpRequestFactory();
    private static HttpClientFactory httpClientFactory = new HttpClientFactory();

    public NeteaseHttpClient(ClientConfiguration clientConfiguration) {
        this.config = clientConfiguration;
        this.poolingHttpClientConnectionManager = ConnectionManagerFactory.createPoolingClientConnManager(this.config);
        this.httpClient = httpClientFactory.createHttpClient(this.config, this.poolingHttpClientConnectionManager);
    }

    public ResponseMetadata getResponseMetadataForRequest(WebServiceRequest request) {
        return this.responseMetadataCache.get(request);
    }

    public <T> T execute(Request<?> request, HttpResponseHandler<WebServiceResponse<T>> responseHandler, HttpResponseHandler<ServiceException> errorResponseHandler, ExecutionContext executionContext) throws ClientException, ServiceException {
        long startTime = System.currentTimeMillis();
        if (executionContext == null) {
            throw new ClientException("Internal SDK Error: No execution context parameter specified.");
        }
        List<RequestHandler> requestHandlers = executionContext.getRequestHandlers();
        if (requestHandlers == null) {
            requestHandlers = new ArrayList<RequestHandler>();
        }
        for (RequestHandler requestHandler : requestHandlers) {
            requestHandler.beforeRequest(request);
        }
        try {
            TimingInfo timingInfo = new TimingInfo(startTime);
            executionContext.setTimingInfo(timingInfo);
            T t = this.executeHelper(request, responseHandler, errorResponseHandler, executionContext);
            timingInfo.setEndTime(System.currentTimeMillis());
            for (RequestHandler handler : requestHandlers) {
                try {
                    handler.afterResponse(request, t, timingInfo);
                }
                catch (ClassCastException classCastException) {}
            }
            return t;
        }
        catch (ClientException e) {
            for (RequestHandler handler : requestHandlers) {
                handler.afterError(request, e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T executeHelper(Request<?> request, HttpResponseHandler<WebServiceResponse<T>> responseHandler, HttpResponseHandler<ServiceException> errorResponseHandler, ExecutionContext executionContext) throws ClientException, ServiceException {
        boolean leaveHttpConnectionOpen = false;
        if (requestLog.isDebugEnabled()) {
            requestLog.debug((Object)("Sending Request: " + request.toString()));
        }
        this.applyRequestData(request);
        int retryCount = 0;
        URI redirectedURI = null;
        HttpEntity entity = null;
        ServiceException exception = null;
        HashMap<String, String> originalParameters = new HashMap<String, String>();
        originalParameters.putAll(request.getParameters());
        HashMap<String, String> originalHeaders = new HashMap<String, String>();
        originalHeaders.putAll(request.getHeaders());
        while (true) {
            if (retryCount > 0) {
                request.setParameters(originalParameters);
                request.setHeaders(originalHeaders);
            }
            if (executionContext.getSigner() != null && executionContext.getCredentials() != null) {
                executionContext.getSigner().sign(request, executionContext.getCredentials());
            } else if (executionContext.getToken() != null) {
                request.addHeader("x-nos-token", executionContext.getToken());
            }
            HttpRequestBase httpRequest = httpRequestFactory.createHttpRequest(request, this.config, entity, executionContext);
            if (httpRequest instanceof HttpEntityEnclosingRequest) {
                entity = ((HttpEntityEnclosingRequest)httpRequest).getEntity();
            }
            if (redirectedURI != null) {
                httpRequest.setURI(redirectedURI);
            }
            CloseableHttpResponse response = null;
            try {
                InputStream content;
                if (retryCount > 0) {
                    this.pauseExponentially(retryCount, exception, executionContext.getCustomBackoffStrategy());
                    if (entity != null && (content = entity.getContent()).markSupported()) {
                        content.reset();
                    }
                }
                exception = null;
                ++retryCount;
                response = this.httpClient.execute((HttpUriRequest)httpRequest);
                if (this.isRequestSuccessful((org.apache.http.HttpResponse)response)) {
                    leaveHttpConnectionOpen = responseHandler.needsConnectionLeftOpen();
                    content = this.handleResponse(request, responseHandler, httpRequest, (org.apache.http.HttpResponse)response, executionContext);
                    return (T)content;
                }
                if (this.isTemporaryRedirect((org.apache.http.HttpResponse)response)) {
                    Header[] locationHeaders = response.getHeaders("location");
                    String redirectedLocation = locationHeaders[0].getValue();
                    log.debug("Redirecting to: " + redirectedLocation);
                    redirectedURI = URI.create(redirectedLocation);
                    httpRequest.setURI(redirectedURI);
                    continue;
                }
                leaveHttpConnectionOpen = errorResponseHandler.needsConnectionLeftOpen();
                exception = this.handleErrorResponse(request, errorResponseHandler, httpRequest, (org.apache.http.HttpResponse)response);
                if (this.shouldRetry(httpRequest, exception, retryCount)) continue;
                throw exception;
            }
            catch (IOException ioe) {
                log.warn("Unable to execute HTTP request: " + ioe.getMessage(), (Throwable)ioe);
                if (this.shouldRetry(httpRequest, ioe, retryCount)) continue;
                throw new ClientException("Unable to execute HTTP request: " + ioe.getMessage(), ioe);
            }
            finally {
                if (leaveHttpConnectionOpen) continue;
                try {
                    response.getEntity().getContent().close();
                }
                catch (Throwable throwable) {}
                continue;
            }
            break;
        }
    }

    private void applyRequestData(Request<?> request) {
        if (request.getOriginalRequest() != null && request.getOriginalRequest().getRequestClientOptions() != null && request.getOriginalRequest().getRequestClientOptions().getClientMarker() != null) {
            request.addHeader("User-Agent", NeteaseHttpClient.createUserAgentString(this.config.getUserAgent(), request.getOriginalRequest().getRequestClientOptions().getClientMarker()));
        }
    }

    private static String createUserAgentString(String existingUserAgentString, String userAgent) {
        if (existingUserAgentString.contains(userAgent)) {
            return existingUserAgentString;
        }
        return existingUserAgentString + " " + userAgent;
    }

    public void shutdown() {
        IdleConnectionReaper.removeConnectionManager((HttpClientConnectionManager)this.poolingHttpClientConnectionManager);
        this.poolingHttpClientConnectionManager.shutdown();
    }

    private boolean shouldRetry(HttpRequestBase method, Exception exception, int retries) {
        HttpEntity entity;
        if (retries > this.config.getMaxErrorRetry()) {
            return false;
        }
        if (method instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)method).getEntity()) != null && !entity.isRepeatable()) {
            return false;
        }
        if (exception instanceof NoHttpResponseException || exception instanceof SocketException || exception instanceof SocketTimeoutException) {
            if (log.isDebugEnabled()) {
                log.debug("Retrying on " + exception.getClass().getName() + ": " + exception.getMessage());
            }
            return true;
        }
        if (exception instanceof ServiceException) {
            ServiceException ase = (ServiceException)exception;
            if (ase.getStatusCode() == 500 || ase.getStatusCode() == 503) {
                return true;
            }
            if (this.isThrottlingException(ase)) {
                return true;
            }
        }
        return false;
    }

    private boolean isTemporaryRedirect(org.apache.http.HttpResponse response) {
        int status = response.getStatusLine().getStatusCode();
        return status == 307 && response.getHeaders("Location") != null && response.getHeaders("Location").length > 0;
    }

    private boolean isRequestSuccessful(org.apache.http.HttpResponse response) {
        int status = response.getStatusLine().getStatusCode();
        return status / 100 == 2;
    }

    private <T> T handleResponse(Request<?> request, HttpResponseHandler<WebServiceResponse<T>> responseHandler, HttpRequestBase method, org.apache.http.HttpResponse apacheHttpResponse, ExecutionContext executionContext) throws IOException {
        HttpResponse httpResponse = this.createResponse(method, request, apacheHttpResponse);
        if (responseHandler.needsConnectionLeftOpen() && method instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest httpEntityEnclosingRequest = (HttpEntityEnclosingRequest)method;
            httpResponse.setContent(new HttpMethodReleaseInputStream(httpEntityEnclosingRequest));
        }
        try {
            WebServiceResponse<T> Response = responseHandler.handle(httpResponse);
            if (Response == null) {
                throw new RuntimeException("Unable to unmarshall response metadata");
            }
            this.responseMetadataCache.add(request.getOriginalRequest(), Response.getResponseMetadata());
            if (requestLog.isDebugEnabled()) {
                requestLog.debug((Object)("Received successful response: " + apacheHttpResponse.getStatusLine().getStatusCode() + ", Request ID: " + Response.getRequestId()));
            }
            return Response.getResult();
        }
        catch (Exception e) {
            String errorMessage = "Unable to unmarshall response (" + e.getMessage() + ")";
            throw new ClientException(errorMessage, e);
        }
    }

    private ServiceException handleErrorResponse(Request<?> request, HttpResponseHandler<ServiceException> errorResponseHandler, HttpRequestBase method, org.apache.http.HttpResponse apacheHttpResponse) throws IOException {
        int status = apacheHttpResponse.getStatusLine().getStatusCode();
        HttpResponse response = this.createResponse(method, request, apacheHttpResponse);
        if (errorResponseHandler.needsConnectionLeftOpen() && method instanceof HttpEntityEnclosingRequestBase) {
            HttpEntityEnclosingRequestBase entityEnclosingRequest = (HttpEntityEnclosingRequestBase)method;
            response.setContent(new HttpMethodReleaseInputStream((HttpEntityEnclosingRequest)entityEnclosingRequest));
        }
        ServiceException exception = null;
        InputStream oldInputStream = response.getContent();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (null != oldInputStream) {
            int len;
            byte[] buf = new byte[1024];
            while ((len = oldInputStream.read(buf)) > -1) {
                baos.write(buf, 0, len);
            }
            baos.flush();
        }
        ByteArrayInputStream copyInputStream1 = oldInputStream == null ? null : new ByteArrayInputStream(baos.toByteArray());
        ByteArrayInputStream copyInputStream2 = oldInputStream == null ? null : new ByteArrayInputStream(baos.toByteArray());
        try {
            response.setContent(copyInputStream1);
            exception = errorResponseHandler.handle(response);
            requestLog.debug((Object)("Received error response: " + exception.toString()));
            response.setContent(oldInputStream);
        }
        catch (Exception e) {
            response.setContent(oldInputStream);
            if (status == 404) {
                exception = new ServiceException("Request object not exist");
                exception.setServiceName(request.getServiceName());
                exception.setStatusCode(404);
                exception.setErrorType(ServiceException.ErrorType.Client);
                exception.setErrorCode("Request object not exist");
            }
            if (status == 413) {
                exception = new ServiceException("Request entity too large");
                exception.setServiceName(request.getServiceName());
                exception.setStatusCode(413);
                exception.setErrorType(ServiceException.ErrorType.Client);
                exception.setErrorCode("Request entity too large");
            }
            if (status == 503 && "Service Unavailable".equalsIgnoreCase(apacheHttpResponse.getStatusLine().getReasonPhrase())) {
                exception = new ServiceException("Service unavailable");
                exception.setServiceName(request.getServiceName());
                exception.setStatusCode(503);
                exception.setErrorType(ServiceException.ErrorType.Service);
                exception.setErrorCode("Service unavailable");
            }
            StringBuilder errorMessage = new StringBuilder("Unable to unmarshall error response");
            errorMessage.append("code:");
            errorMessage.append(response.getStatusCode());
            errorMessage.append("; ");
            Map<String, String> headers = response.getHeaders();
            for (String key : headers.keySet()) {
                errorMessage.append(key);
                errorMessage.append(":");
                errorMessage.append(headers.get(key));
                errorMessage.append("; ");
            }
            errorMessage.append("\n");
            errorMessage.append("body:");
            int by = 0;
            if (copyInputStream2 != null) {
                while ((by = ((InputStream)copyInputStream2).read()) != -1) {
                    errorMessage.append((char)by);
                }
            }
            if (copyInputStream1 != null) {
                ((InputStream)copyInputStream1).close();
            }
            if (copyInputStream2 != null) {
                ((InputStream)copyInputStream2).close();
            }
            throw new ClientException(errorMessage.toString(), e);
        }
        if (copyInputStream1 != null) {
            ((InputStream)copyInputStream1).close();
        }
        if (copyInputStream2 != null) {
            ((InputStream)copyInputStream2).close();
        }
        exception.setStatusCode(status);
        exception.setServiceName(request.getServiceName());
        exception.fillInStackTrace();
        return exception;
    }

    private HttpResponse createResponse(HttpRequestBase method, Request<?> request, org.apache.http.HttpResponse apacheHttpResponse) throws IOException {
        HttpResponse httpResponse = new HttpResponse(request, method);
        if (apacheHttpResponse.getEntity() != null) {
            httpResponse.setContent(apacheHttpResponse.getEntity().getContent());
        }
        httpResponse.setStatusCode(apacheHttpResponse.getStatusLine().getStatusCode());
        httpResponse.setStatusText(apacheHttpResponse.getStatusLine().getReasonPhrase());
        for (Header header : apacheHttpResponse.getAllHeaders()) {
            httpResponse.addHeader(header.getName(), header.getValue());
        }
        return httpResponse;
    }

    private void pauseExponentially(int retries, ServiceException previousException, CustomBackoffStrategy backoffStrategy) {
        long delay = 0L;
        if (backoffStrategy != null) {
            delay = backoffStrategy.getBackoffPeriod(retries);
        } else {
            long scaleFactor = 300L;
            if (this.isThrottlingException(previousException)) {
                scaleFactor = 500 + random.nextInt(100);
            }
            delay = (long)(Math.pow(2.0, retries) * (double)scaleFactor);
        }
        delay = Math.min(delay, 20000L);
        if (log.isDebugEnabled()) {
            log.debug("Retriable error detected, will retry in " + delay + "ms, attempt number: " + retries);
        }
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            throw new ClientException(e.getMessage(), e);
        }
    }

    private boolean isThrottlingException(ServiceException ase) {
        if (ase == null) {
            return false;
        }
        return "Throttling".equals(ase.getErrorCode()) || "ThrottlingException".equals(ase.getErrorCode()) || "ProvisionedThroughputExceededException".equals(ase.getErrorCode());
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }
}

