/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.http;

import com.netease.cloud.Request;
import com.netease.cloud.http.NeteaseHttpClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.InputStreamEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RepeatableInputStreamRequestEntity
extends BasicHttpEntity {
    private boolean firstAttempt = true;
    private InputStreamEntity inputStreamRequestEntity;
    private InputStream content;
    private static final Logger log = LoggerFactory.getLogger(NeteaseHttpClient.class);

    RepeatableInputStreamRequestEntity(Request<?> request) {
        this.setChunked(false);
        long contentLength = -1L;
        try {
            String contentLengthString = request.getHeaders().get("Content-Length");
            if (contentLengthString != null) {
                contentLength = Long.parseLong(contentLengthString);
            }
        }
        catch (NumberFormatException nfe) {
            log.warn("Unable to parse content length from request.  Buffering contents in memory.");
        }
        String contentType = request.getHeaders().get("Content-Type");
        this.inputStreamRequestEntity = new InputStreamEntity(request.getContent(), contentLength);
        this.inputStreamRequestEntity.setContentType(contentType);
        this.content = request.getContent();
        this.setContent(this.content);
        this.setContentType(contentType);
        this.setContentLength(contentLength);
    }

    public boolean isChunked() {
        return false;
    }

    public boolean isRepeatable() {
        return this.content.markSupported() || this.inputStreamRequestEntity.isRepeatable();
    }

    public void writeTo(OutputStream output) throws IOException {
        if (!this.firstAttempt && this.isRepeatable()) {
            this.content.reset();
        }
        this.firstAttempt = false;
        this.inputStreamRequestEntity.writeTo(output);
    }
}

