/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.internal;

import com.netease.cloud.exception.AbortedException;
import com.netease.cloud.internal.Releasable;
import com.netease.cloud.util.IOUtils;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.LogFactory;

public abstract class SdkInputStream
extends FilterInputStream
implements Releasable {
    protected SdkInputStream(InputStream in) {
        super(in);
    }

    protected abstract InputStream getWrappedInputStream();

    protected static boolean shouldAbort() {
        return Thread.interrupted();
    }

    protected final void abortIfNeeded() {
        if (SdkInputStream.shouldAbort()) {
            try {
                this.abort();
            }
            catch (IOException e) {
                LogFactory.getLog(this.getClass()).debug((Object)"FYI", (Throwable)e);
            }
            throw new AbortedException();
        }
    }

    protected void abort() throws IOException {
    }

    @Override
    public void release() {
        IOUtils.closeQuietly(this, null);
        InputStream in = this.getWrappedInputStream();
        if (in instanceof Releasable) {
            Releasable r = (Releasable)((Object)in);
            r.release();
        }
    }
}

