/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.internal.crypto;

import com.netease.cloud.ClientException;
import com.netease.cloud.ServiceException;
import com.netease.cloud.auth.CredentialsProvider;
import com.netease.cloud.internal.NOSDirect;
import com.netease.cloud.internal.crypto.CryptoConfiguration;
import com.netease.cloud.internal.crypto.CryptoMode;
import com.netease.cloud.internal.crypto.EncryptionMaterialsProvider;
import com.netease.cloud.internal.crypto.NOSCryptoModule;
import com.netease.cloud.internal.crypto.NOSCryptoModuleAE;
import com.netease.cloud.services.nos.model.AbortMultipartUploadRequest;
import com.netease.cloud.services.nos.model.CompleteMultipartUploadRequest;
import com.netease.cloud.services.nos.model.CompleteMultipartUploadResult;
import com.netease.cloud.services.nos.model.GetObjectRequest;
import com.netease.cloud.services.nos.model.InitiateMultipartUploadRequest;
import com.netease.cloud.services.nos.model.InitiateMultipartUploadResult;
import com.netease.cloud.services.nos.model.NOSObject;
import com.netease.cloud.services.nos.model.ObjectMetadata;
import com.netease.cloud.services.nos.model.PutObjectRequest;
import com.netease.cloud.services.nos.model.PutObjectResult;
import com.netease.cloud.services.nos.model.UploadPartRequest;
import com.netease.cloud.services.nos.model.UploadPartResult;
import java.io.File;

public class CryptoModuleDispatcher
extends NOSCryptoModule {
    private final CryptoMode defaultCryptoMode;
    private final NOSCryptoModuleAE ae;

    public CryptoModuleDispatcher(NOSDirect NOS, CredentialsProvider credentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfig) {
        cryptoConfig = cryptoConfig.clone();
        CryptoMode cryptoMode = cryptoConfig.getCryptoMode();
        if (cryptoMode == null) {
            cryptoMode = CryptoMode.AuthenticatedEncryption;
            cryptoConfig.setCryptoMode(cryptoMode);
        }
        cryptoConfig = cryptoConfig.readOnly();
        this.defaultCryptoMode = cryptoConfig.getCryptoMode();
        switch (this.defaultCryptoMode) {
            case AuthenticatedEncryption: {
                this.ae = new NOSCryptoModuleAE(NOS, credentialsProvider, encryptionMaterialsProvider, cryptoConfig);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public PutObjectResult putObjectSecurely(PutObjectRequest putObjectRequest) {
        return this.ae.putObjectSecurely(putObjectRequest);
    }

    @Override
    public NOSObject getObjectSecurely(GetObjectRequest req) {
        return this.ae.getObjectSecurely(req);
    }

    @Override
    public ObjectMetadata getObjectSecurely(GetObjectRequest req, File destinationFile) {
        return this.ae.getObjectSecurely(req, destinationFile);
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUploadSecurely(CompleteMultipartUploadRequest req) throws ClientException, ServiceException {
        return this.ae.completeMultipartUploadSecurely(req);
    }

    @Override
    public void abortMultipartUploadSecurely(AbortMultipartUploadRequest req) {
        this.ae.abortMultipartUploadSecurely(req);
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUploadSecurely(InitiateMultipartUploadRequest req) throws ClientException, ServiceException {
        return this.ae.initiateMultipartUploadSecurely(req);
    }

    @Override
    public UploadPartResult uploadPartSecurely(UploadPartRequest req) throws ClientException {
        return this.ae.uploadPartSecurely(req);
    }
}

