/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.internal.crypto;

import com.netease.cloud.ClientException;
import com.netease.cloud.internal.crypto.CipherLite;
import com.netease.cloud.internal.crypto.ContentCryptoMaterial;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.annotation.GuardedBy;

public class MultipartUploadCryptoContext {
    private final String bucketName;
    private final String key;
    private boolean hasFinalPartBeenSeen;
    private Map<String, String> materialsDescription;
    private final ContentCryptoMaterial cekMaterial;
    @GuardedBy(value="this")
    private int partNumber;
    private volatile boolean partUploadInProgress;

    protected MultipartUploadCryptoContext(String bucketName, String key, ContentCryptoMaterial cekMaterial) {
        this.bucketName = bucketName;
        this.key = key;
        this.cekMaterial = cekMaterial;
    }

    public final String getBucketName() {
        return this.bucketName;
    }

    public final String getKey() {
        return this.key;
    }

    public final boolean hasFinalPartBeenSeen() {
        return this.hasFinalPartBeenSeen;
    }

    public final void setHasFinalPartBeenSeen(boolean hasFinalPartBeenSeen) {
        this.hasFinalPartBeenSeen = hasFinalPartBeenSeen;
    }

    public final Map<String, String> getMaterialsDescription() {
        return this.materialsDescription;
    }

    public final void setMaterialsDescription(Map<String, String> materialsDescription) {
        this.materialsDescription = materialsDescription == null ? null : Collections.unmodifiableMap(new HashMap<String, String>(materialsDescription));
    }

    CipherLite getCipherLite() {
        return this.cekMaterial.getCipherLite();
    }

    ContentCryptoMaterial getContentCryptoMaterial() {
        return this.cekMaterial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void beginPartUpload(int nextPartNumber) throws ClientException {
        if (nextPartNumber < 1) {
            throw new IllegalArgumentException("part number must be at least 1");
        }
        if (this.partUploadInProgress) {
            throw new ClientException("Parts are required to be uploaded in series");
        }
        MultipartUploadCryptoContext multipartUploadCryptoContext = this;
        synchronized (multipartUploadCryptoContext) {
            if (this.partUploadInProgress) {
                throw new ClientException("Parts are required to be uploaded in series");
            }
            if (nextPartNumber - this.partNumber > 1) {
                throw new ClientException("Parts are required to be uploaded in series (partNumber=" + this.partNumber + ", nextPartNumber=" + nextPartNumber + ")");
            }
            this.partNumber = nextPartNumber;
            this.partUploadInProgress = true;
        }
    }

    void endPartUpload() {
        this.partUploadInProgress = false;
    }
}

