/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.internal.crypto;

import com.netease.cloud.ClientException;
import com.netease.cloud.WebServiceRequest;
import com.netease.cloud.auth.CredentialsProvider;
import com.netease.cloud.internal.LengthCheckInputStream;
import com.netease.cloud.internal.NOSDirect;
import com.netease.cloud.internal.ReleasableInputStream;
import com.netease.cloud.internal.ResettableInputStream;
import com.netease.cloud.internal.SdkFilterInputStream;
import com.netease.cloud.internal.crypto.CipherLite;
import com.netease.cloud.internal.crypto.CipherLiteInputStream;
import com.netease.cloud.internal.crypto.ContentCryptoMaterial;
import com.netease.cloud.internal.crypto.ContentCryptoScheme;
import com.netease.cloud.internal.crypto.CryptoConfiguration;
import com.netease.cloud.internal.crypto.CryptoStorageMode;
import com.netease.cloud.internal.crypto.EncryptionMaterials;
import com.netease.cloud.internal.crypto.EncryptionMaterialsFactory;
import com.netease.cloud.internal.crypto.EncryptionMaterialsProvider;
import com.netease.cloud.internal.crypto.MultipartUploadCryptoContext;
import com.netease.cloud.internal.crypto.NOSCryptoModule;
import com.netease.cloud.internal.crypto.NOSCryptoScheme;
import com.netease.cloud.internal.crypto.NOSObjectWrapper;
import com.netease.cloud.internal.crypto.RenewableCipherLiteInputStream;
import com.netease.cloud.services.nos.internal.InputSubstream;
import com.netease.cloud.services.nos.model.AbortMultipartUploadRequest;
import com.netease.cloud.services.nos.model.CompleteMultipartUploadRequest;
import com.netease.cloud.services.nos.model.CompleteMultipartUploadResult;
import com.netease.cloud.services.nos.model.InitiateMultipartUploadRequest;
import com.netease.cloud.services.nos.model.InitiateMultipartUploadResult;
import com.netease.cloud.services.nos.model.MaterialsDescriptionProvider;
import com.netease.cloud.services.nos.model.NosDataSource;
import com.netease.cloud.services.nos.model.ObjectMetadata;
import com.netease.cloud.services.nos.model.PutObjectRequest;
import com.netease.cloud.services.nos.model.PutObjectResult;
import com.netease.cloud.services.nos.model.UploadPartRequest;
import com.netease.cloud.services.nos.model.UploadPartResult;
import java.io.File;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NOSCryptoModuleBase
extends NOSCryptoModule {
    private static final boolean IS_MULTI_PART = true;
    protected static final int DEFAULT_BUFFER_SIZE = 2048;
    protected final EncryptionMaterialsProvider kekMaterialsProvider;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final NOSCryptoScheme cryptoScheme;
    protected final ContentCryptoScheme contentCryptoScheme;
    protected final CryptoConfiguration cryptoConfig;
    protected final Map<String, MultipartUploadCryptoContext> multipartUploadContexts = Collections.synchronizedMap(new HashMap());
    protected final NOSDirect NOS;

    protected NOSCryptoModuleBase(NOSDirect NOS, CredentialsProvider credentialsProvider, EncryptionMaterialsProvider kekMaterialsProvider, CryptoConfiguration cryptoConfig) {
        if (!cryptoConfig.isReadOnly()) {
            throw new IllegalArgumentException("The cryto configuration parameter is required to be read-only");
        }
        this.kekMaterialsProvider = kekMaterialsProvider;
        this.NOS = NOS;
        this.cryptoConfig = cryptoConfig;
        this.cryptoScheme = NOSCryptoScheme.from(cryptoConfig.getCryptoMode());
        this.contentCryptoScheme = this.cryptoScheme.getContentCryptoScheme();
    }

    protected abstract long ciphertextLength(long var1);

    @Override
    public PutObjectResult putObjectSecurely(PutObjectRequest req) {
        return this.putObjectUsingMetadata(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PutObjectResult putObjectUsingMetadata(PutObjectRequest req) {
        ContentCryptoMaterial cekMaterial = this.createContentCryptoMaterial(req);
        File fileOrig = req.getFile();
        InputStream isOrig = req.getInputStream();
        PutObjectRequest wrappedReq = this.wrapWithCipher(req, cekMaterial);
        req.setMetadata(this.updateMetadataWithContentCryptoMaterial(req.getMetadata(), req.getFile(), cekMaterial));
        try {
            PutObjectResult putObjectResult = this.NOS.putObject(wrappedReq);
            return putObjectResult;
        }
        finally {
            NosDataSource.Utils.cleanupDataSource(req, fileOrig, isOrig, wrappedReq.getInputStream(), this.log);
        }
    }

    @Override
    public final void abortMultipartUploadSecurely(AbortMultipartUploadRequest req) {
        this.NOS.abortMultipartUpload(req);
        this.multipartUploadContexts.remove(req.getUploadId());
    }

    abstract MultipartUploadCryptoContext newUploadContext(InitiateMultipartUploadRequest var1, ContentCryptoMaterial var2);

    @Override
    public InitiateMultipartUploadResult initiateMultipartUploadSecurely(InitiateMultipartUploadRequest req) {
        ContentCryptoMaterial cekMaterial = this.createContentCryptoMaterial(req);
        InitiateMultipartUploadResult result = this.NOS.initiateMultipartUpload(req);
        MultipartUploadCryptoContext uploadContext = this.newUploadContext(req, cekMaterial);
        if (req instanceof MaterialsDescriptionProvider) {
            MaterialsDescriptionProvider p = (MaterialsDescriptionProvider)((Object)req);
            uploadContext.setMaterialsDescription(p.getMaterialsDescription());
        }
        this.multipartUploadContexts.put(result.getUploadId(), uploadContext);
        return result;
    }

    abstract CipherLite cipherLiteForNextPart(MultipartUploadCryptoContext var1);

    abstract long computeLastPartSize(UploadPartRequest var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadPartResult uploadPartSecurely(UploadPartRequest req) {
        UploadPartResult result;
        boolean partSizeMultipleOfCipherBlockSize;
        int blockSize = this.contentCryptoScheme.getBlockSizeInBytes();
        boolean isLastPart = req.isLastPart();
        String uploadId = req.getUploadId();
        long partSize = req.getPartSize();
        boolean bl = partSizeMultipleOfCipherBlockSize = 0L == partSize % (long)blockSize;
        if (!isLastPart && !partSizeMultipleOfCipherBlockSize) {
            throw new ClientException("Invalid part size: part sizes for encrypted multipart uploads must be multiples of the cipher block size (" + blockSize + ") with the exception of the last part.");
        }
        MultipartUploadCryptoContext uploadContext = this.multipartUploadContexts.get(uploadId);
        if (uploadContext == null) {
            throw new ClientException("No client-side information available on upload ID " + uploadId);
        }
        uploadContext.beginPartUpload(req.getPartNumber());
        CipherLite cipherLite = this.cipherLiteForNextPart(uploadContext);
        File fileOrig = req.getFile();
        InputStream isOrig = req.getInputStream();
        CipherLiteInputStream isCurr = null;
        try {
            CipherLiteInputStream clis;
            isCurr = clis = this.newMultipartNOSCipherInputStream(req, cipherLite);
            req.setInputStream(isCurr);
            req.setFile(null);
            req.setFileOffset(0L);
            if (isLastPart) {
                long lastPartSize = this.computeLastPartSize(req);
                if (lastPartSize > -1L) {
                    req.setPartSize(lastPartSize);
                }
                if (uploadContext.hasFinalPartBeenSeen()) {
                    throw new ClientException("This part was specified as the last part in a multipart upload, but a previous part was already marked as the last part.  Only the last part of the upload should be marked as the last part.");
                }
            }
            result = this.NOS.uploadPart(req);
        }
        finally {
            NosDataSource.Utils.cleanupDataSource(req, fileOrig, isOrig, isCurr, this.log);
            uploadContext.endPartUpload();
        }
        if (isLastPart) {
            uploadContext.setHasFinalPartBeenSeen(true);
        }
        return result;
    }

    protected final CipherLiteInputStream newMultipartNOSCipherInputStream(UploadPartRequest req, CipherLite cipherLite) {
        File fileOrig = req.getFile();
        InputStream isOrig = req.getInputStream();
        InputStream isCurr = null;
        try {
            if (fileOrig == null) {
                if (isOrig == null) {
                    throw new IllegalArgumentException("A File or InputStream must be specified when uploading part");
                }
                isCurr = isOrig;
            } else {
                isCurr = new ResettableInputStream(fileOrig);
            }
            isCurr = new InputSubstream(isCurr, req.getFileOffset(), req.getPartSize(), req.isLastPart());
            return cipherLite.markSupported() ? new CipherLiteInputStream(isCurr, cipherLite, 2048, true, req.isLastPart()) : new RenewableCipherLiteInputStream(isCurr, cipherLite, 2048, true, req.isLastPart());
        }
        catch (Exception e) {
            NosDataSource.Utils.cleanupDataSource(req, fileOrig, isOrig, isCurr, this.log);
            throw new ClientException("Unable to create cipher input stream", e);
        }
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUploadSecurely(CompleteMultipartUploadRequest req) {
        String uploadId = req.getUploadId();
        MultipartUploadCryptoContext uploadContext = this.multipartUploadContexts.get(uploadId);
        if (this.cryptoConfig.getStorageMode() == CryptoStorageMode.ObjectMetadata) {
            ContentCryptoMaterial cekMaterial = uploadContext.getContentCryptoMaterial();
            for (Map.Entry<String, String> entry : this.updateMetadataWithContentCryptoMaterial(new ObjectMetadata(), null, cekMaterial).getUserMetadata().entrySet()) {
                String k = entry.getKey();
                String v = entry.getValue();
                req.addSpecialHeader("x-nos-meta-" + k, v);
            }
        }
        if (uploadContext != null && !uploadContext.hasFinalPartBeenSeen()) {
            throw new ClientException("Unable to complete an encrypted multipart upload without being told which part was the last.  Without knowing which part was the last, the encrypted data in NOS is incomplete and corrupt.");
        }
        CompleteMultipartUploadResult result = this.NOS.completeMultipartUpload(req);
        this.multipartUploadContexts.remove(uploadId);
        return result;
    }

    protected final ObjectMetadata updateMetadataWithContentCryptoMaterial(ObjectMetadata metadata, File file, ContentCryptoMaterial instruction) {
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        return instruction.toObjectMetadata(metadata, this.cryptoConfig.getCryptoMode());
    }

    protected final ContentCryptoMaterial createContentCryptoMaterial(WebServiceRequest req) {
        EncryptionMaterialsFactory f;
        EncryptionMaterials materials;
        if (req instanceof EncryptionMaterialsFactory && (materials = (f = (EncryptionMaterialsFactory)((Object)req)).getEncryptionMaterials()) != null) {
            return this.buildContentCryptoMaterial(materials, this.cryptoConfig.getCryptoProvider(), req);
        }
        if (req instanceof MaterialsDescriptionProvider) {
            MaterialsDescriptionProvider mdp = (MaterialsDescriptionProvider)((Object)req);
            Map<String, String> matdesc_req = mdp.getMaterialsDescription();
            ContentCryptoMaterial ccm = this.newContentCryptoMaterial(this.kekMaterialsProvider, matdesc_req, this.cryptoConfig.getCryptoProvider(), req);
            if (ccm != null) {
                return ccm;
            }
            if (matdesc_req != null) {
                EncryptionMaterials material = this.kekMaterialsProvider.getEncryptionMaterials();
                throw new ClientException("No material available from the encryption material provider for description " + matdesc_req);
            }
        }
        return this.newContentCryptoMaterial(this.kekMaterialsProvider, this.cryptoConfig.getCryptoProvider(), req);
    }

    private ContentCryptoMaterial newContentCryptoMaterial(EncryptionMaterialsProvider kekMaterialProvider, Map<String, String> materialsDescription, Provider provider, WebServiceRequest req) {
        EncryptionMaterials kekMaterials = kekMaterialProvider.getEncryptionMaterials(materialsDescription);
        if (kekMaterials == null) {
            return null;
        }
        return this.buildContentCryptoMaterial(kekMaterials, provider, req);
    }

    private ContentCryptoMaterial newContentCryptoMaterial(EncryptionMaterialsProvider kekMaterialProvider, Provider provider, WebServiceRequest req) {
        EncryptionMaterials kekMaterials = kekMaterialProvider.getEncryptionMaterials();
        if (kekMaterials == null) {
            throw new ClientException("No material available from the encryption material provider");
        }
        return this.buildContentCryptoMaterial(kekMaterials, provider, req);
    }

    private ContentCryptoMaterial buildContentCryptoMaterial(EncryptionMaterials materials, Provider provider, WebServiceRequest req) {
        byte[] iv = new byte[this.contentCryptoScheme.getIVLengthInBytes()];
        this.cryptoScheme.getSecureRandom().nextBytes(iv);
        return ContentCryptoMaterial.create(this.generateCEK(materials, provider), iv, materials, this.cryptoScheme, provider, req);
    }

    protected final SecretKey generateCEK(EncryptionMaterials kekMaterials, Provider providerIn) {
        String keygenAlgo = this.contentCryptoScheme.getKeyGeneratorAlgorithm();
        try {
            String keyWrapAlgo;
            KeyGenerator generator = providerIn == null ? KeyGenerator.getInstance(keygenAlgo) : KeyGenerator.getInstance(keygenAlgo, providerIn);
            generator.init(this.contentCryptoScheme.getKeyLengthInBits(), this.cryptoScheme.getSecureRandom());
            boolean involvesBCPublicKey = false;
            KeyPair keypair = kekMaterials.getKeyPair();
            if (keypair != null && (keyWrapAlgo = this.cryptoScheme.getKeyWrapScheme().getKeyWrapAlgorithm(keypair.getPublic())) == null) {
                Provider provider = generator.getProvider();
                String providerName = provider == null ? null : provider.getName();
                involvesBCPublicKey = "BC".equals(providerName);
            }
            SecretKey secretKey = generator.generateKey();
            if (!involvesBCPublicKey || secretKey.getEncoded()[0] != 0) {
                return secretKey;
            }
            for (int retry = 0; retry < 10; ++retry) {
                secretKey = generator.generateKey();
                if (secretKey.getEncoded()[0] == 0) continue;
                return secretKey;
            }
            throw new ClientException("Failed to generate secret key");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ClientException("Unable to generate envelope symmetric key:" + e.getMessage(), e);
        }
    }

    protected final <R extends PutObjectRequest> R wrapWithCipher(R request, ContentCryptoMaterial cekMaterial) {
        ObjectMetadata metadata = request.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        if (metadata.getContentMD5() != null) {
            metadata.addUserMetadata("x-nos-meta-unencrypted-content-md5", metadata.getContentMD5());
        }
        metadata.setContentMD5(null);
        long plaintextLength = this.plaintextLength(request, metadata);
        if (plaintextLength >= 0L) {
            metadata.addUserMetadata("x-nos-meta-unencrypted-content-length", Long.toString(plaintextLength));
            metadata.setContentLength(this.ciphertextLength(plaintextLength));
        }
        request.setMetadata(metadata);
        request.setInputStream(this.newNOSCipherLiteInputStream(request, cekMaterial, plaintextLength));
        request.setFile(null);
        return request;
    }

    private CipherLiteInputStream newNOSCipherLiteInputStream(PutObjectRequest req, ContentCryptoMaterial cekMaterial, long plaintextLength) {
        File fileOrig = req.getFile();
        InputStream isOrig = req.getInputStream();
        SdkFilterInputStream isCurr = null;
        try {
            CipherLite cipherLite;
            isCurr = fileOrig == null ? (isOrig == null ? null : ReleasableInputStream.wrap(isOrig)) : new ResettableInputStream(fileOrig);
            if (plaintextLength > -1L) {
                isCurr = new LengthCheckInputStream(isCurr, plaintextLength, false);
            }
            if ((cipherLite = cekMaterial.getCipherLite()).markSupported()) {
                return new CipherLiteInputStream(isCurr, cipherLite, 2048);
            }
            return new RenewableCipherLiteInputStream(isCurr, cipherLite, 2048);
        }
        catch (Exception e) {
            NosDataSource.Utils.cleanupDataSource(req, fileOrig, isOrig, isCurr, this.log);
            throw new ClientException("Unable to create cipher input stream", e);
        }
    }

    protected final long plaintextLength(PutObjectRequest request, ObjectMetadata metadata) {
        if (request.getFile() != null) {
            return request.getFile().length();
        }
        if (request.getInputStream() != null && metadata.getRawMetadata() != null) {
            return metadata.getContentLength();
        }
        return -1L;
    }

    public final NOSCryptoScheme getNOSCryptoScheme() {
        return this.cryptoScheme;
    }

    protected void securityCheck(ContentCryptoMaterial cekMaterial, NOSObjectWrapper retrieved) {
    }

    static long[] getAdjustedCryptoRange(long[] range) {
        if (range == null || range[0] > range[1]) {
            return null;
        }
        long[] adjustedCryptoRange = new long[]{NOSCryptoModuleBase.getCipherBlockLowerBound(range[0]), NOSCryptoModuleBase.getCipherBlockUpperBound(range[1])};
        return adjustedCryptoRange;
    }

    private static long getCipherBlockLowerBound(long leftmostBytePosition) {
        long cipherBlockSize = 16L;
        long offset = leftmostBytePosition % cipherBlockSize;
        long lowerBound = leftmostBytePosition - offset - cipherBlockSize;
        return lowerBound < 0L ? 0L : lowerBound;
    }

    private static long getCipherBlockUpperBound(long rightmostBytePosition) {
        long cipherBlockSize = 16L;
        long offset = cipherBlockSize - rightmostBytePosition % cipherBlockSize;
        long upperBound = rightmostBytePosition + offset + cipherBlockSize;
        return upperBound < 0L ? Long.MAX_VALUE : upperBound;
    }
}

