/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.internal.crypto;

import com.netease.cloud.internal.crypto.ContentCryptoScheme;
import com.netease.cloud.internal.crypto.CryptoMode;
import com.netease.cloud.internal.crypto.NOSKeyWrapScheme;
import java.security.SecureRandom;

final class NOSCryptoScheme {
    static final String AES = "AES";
    static final String RSA = "RSA";
    private static final SecureRandom srand = new SecureRandom();
    private final NOSKeyWrapScheme kwScheme;
    private final ContentCryptoScheme contentCryptoScheme;

    private NOSCryptoScheme(ContentCryptoScheme contentCryptoScheme, NOSKeyWrapScheme kwScheme) {
        this.contentCryptoScheme = contentCryptoScheme;
        this.kwScheme = kwScheme;
    }

    SecureRandom getSecureRandom() {
        return srand;
    }

    ContentCryptoScheme getContentCryptoScheme() {
        return this.contentCryptoScheme;
    }

    NOSKeyWrapScheme getKeyWrapScheme() {
        return this.kwScheme;
    }

    static boolean isAesGcm(String cipherAlgorithm) {
        return ContentCryptoScheme.AES_GCM.getCipherAlgorithm().equals(cipherAlgorithm);
    }

    static NOSCryptoScheme from(CryptoMode mode) {
        switch (mode) {
            case AuthenticatedEncryption: 
            case StrictAuthenticatedEncryption: {
                return new NOSCryptoScheme(ContentCryptoScheme.AES_GCM, new NOSKeyWrapScheme());
            }
        }
        throw new IllegalStateException();
    }
}

