/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.internal.crypto;

import com.netease.cloud.internal.crypto.CryptoRuntime;
import java.security.Key;

class NOSKeyWrapScheme {
    public static final String AESWrap = "AESWrap";
    public static final String RSA_ECB_OAEPWithSHA256AndMGF1Padding = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";

    NOSKeyWrapScheme() {
    }

    String getKeyWrapAlgorithm(Key kek) {
        String algorithm = kek.getAlgorithm();
        if ("AES".equals(algorithm)) {
            return AESWrap;
        }
        if ("RSA".equals(algorithm) && CryptoRuntime.isRsaKeyWrapAvailable()) {
            return RSA_ECB_OAEPWithSHA256AndMGF1Padding;
        }
        throw new IllegalArgumentException("Unsupported key wrap algorithm " + algorithm);
    }

    public String toString() {
        return "NOSKeyWrapScheme";
    }
}

