/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.internal.crypto;

import com.netease.cloud.ClientException;
import com.netease.cloud.internal.crypto.ContentCryptoScheme;
import com.netease.cloud.services.nos.model.NOSObject;
import com.netease.cloud.services.nos.model.NOSObjectInputStream;
import com.netease.cloud.services.nos.model.ObjectMetadata;
import com.netease.cloud.util.StringUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;

class NOSObjectWrapper
implements Closeable {
    private final NOSObject NOSobj;

    NOSObjectWrapper(NOSObject NOSobj) {
        if (NOSobj == null) {
            throw new IllegalArgumentException();
        }
        this.NOSobj = NOSobj;
    }

    ObjectMetadata getObjectMetadata() {
        return this.NOSobj.getObjectMetadata();
    }

    void setObjectMetadata(ObjectMetadata metadata) {
        this.NOSobj.setObjectMetadata(metadata);
    }

    NOSObjectInputStream getObjectContent() {
        return this.NOSobj.getObjectContent();
    }

    void setObjectContent(NOSObjectInputStream objectContent) {
        this.NOSobj.setObjectContent(objectContent);
    }

    void setObjectContent(InputStream objectContent) {
        this.NOSobj.setObjectContent(objectContent);
    }

    String getBucketName() {
        return this.NOSobj.getBucketName();
    }

    void setBucketName(String bucketName) {
        this.NOSobj.setBucketName(bucketName);
    }

    String getKey() {
        return this.NOSobj.getKey();
    }

    void setKey(String key) {
        this.NOSobj.setKey(key);
    }

    public String toString() {
        return this.NOSobj.toString();
    }

    final boolean hasEncryptionInfo() {
        ObjectMetadata metadata = this.NOSobj.getObjectMetadata();
        Map<String, String> userMeta = metadata.getUserMetadata();
        return userMeta != null && userMeta.containsKey("x-nos-meta-iv") && (userMeta.containsKey("x-nos-meta-key-v2") || userMeta.containsKey("x-nos-meta-key"));
    }

    String toJsonString() {
        try {
            return NOSObjectWrapper.from(this.NOSobj.getObjectContent());
        }
        catch (Exception e) {
            throw new ClientException("Error parsing JSON: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String from(InputStream is) throws IOException {
        if (is == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, StringUtils.UTF8));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        finally {
            is.close();
        }
        return sb.toString();
    }

    @Override
    public void close() throws IOException {
        this.NOSobj.close();
    }

    NOSObject getNOSObject() {
        return this.NOSobj;
    }

    ContentCryptoScheme encryptionSchemeOf(Map<String, String> instructionFile) {
        if (instructionFile != null) {
            String cekAlgo = instructionFile.get("x-nos-meta-cek-alg");
            return ContentCryptoScheme.fromCEKAlgo(cekAlgo);
        }
        ObjectMetadata meta = this.NOSobj.getObjectMetadata();
        Map<String, String> userMeta = meta.getUserMetadata();
        String cekAlgo = userMeta.get("x-nos-meta-cek-alg");
        return ContentCryptoScheme.fromCEKAlgo(cekAlgo);
    }
}

