/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.services.nos.internal;

import com.netease.cloud.ClientException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class ChecksumValidatingInputStream
extends FilterInputStream {
    private final byte[] expectedChecksum;
    private final DigestInputStream digestInputStream;
    private final String sourceObject;
    private boolean hasReadAllContent = false;

    public ChecksumValidatingInputStream(InputStream in, byte[] expectedChecksum, String sourceObject) throws NoSuchAlgorithmException {
        super(new DigestInputStream(in, MessageDigest.getInstance("MD5")));
        this.expectedChecksum = expectedChecksum;
        this.sourceObject = sourceObject;
        this.digestInputStream = (DigestInputStream)this.in;
    }

    @Override
    public int read() throws IOException {
        int read = super.read();
        this.hasReadAllContent = read == -1;
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = super.read(b, off, len);
        this.hasReadAllContent = read == 0;
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = super.read(b);
        this.hasReadAllContent = read == 0;
        return read;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (!this.hasReadAllContent) {
            return;
        }
        byte[] clientSideHash = this.digestInputStream.getMessageDigest().digest();
        if (!Arrays.equals(clientSideHash, this.expectedChecksum)) {
            throw new ClientException("Unable to verify integrity of data download.  Client calculated content hash didn't match hash calculated by Nos.  The data read from '" + this.sourceObject + "' may be corrupt.");
        }
    }
}

