/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.services.nos.internal;

import com.netease.cloud.ClientException;
import com.netease.cloud.Request;
import com.netease.cloud.auth.AbstractSigner;
import com.netease.cloud.auth.Credentials;
import com.netease.cloud.auth.SigningAlgorithm;
import com.netease.cloud.services.nos.internal.RestUtils;
import java.util.Date;

public class NosQueryStringSigner<T>
extends AbstractSigner {
    private final String httpVerb;
    private final String resourcePath;
    private final Date expiration;

    public NosQueryStringSigner(String httpVerb, String resourcePath, Date expiration) {
        this.httpVerb = httpVerb;
        this.resourcePath = resourcePath;
        this.expiration = expiration;
        if (resourcePath == null) {
            throw new IllegalArgumentException("Parameter resourcePath is empty");
        }
    }

    @Override
    public void sign(Request<?> request, Credentials credentials) throws ClientException {
        Credentials sanitizedCredentials = this.sanitizeCredentials(credentials);
        String expirationInSeconds = Long.toString(this.expiration.getTime() / 1000L);
        String canonicalString = RestUtils.makeNosCanonicalString(this.httpVerb, this.resourcePath, request, expirationInSeconds);
        String signature = super.signAndBase64Encode(canonicalString, sanitizedCredentials.getSecretKey(), SigningAlgorithm.HmacSHA256);
        request.addParameter("NOSAccessKeyId", sanitizedCredentials.getAccessKeyId());
        request.addParameter("Expires", expirationInSeconds);
        request.addParameter("Signature", signature);
    }
}

