/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.services.nos.internal;

import com.netease.cloud.ClientException;
import com.netease.cloud.Request;
import com.netease.cloud.auth.AbstractSigner;
import com.netease.cloud.auth.Credentials;
import com.netease.cloud.auth.SigningAlgorithm;
import com.netease.cloud.services.nos.internal.RestUtils;
import com.netease.cloud.services.nos.internal.ServiceUtils;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NosSigner
extends AbstractSigner {
    private static final Logger log = LoggerFactory.getLogger(NosSigner.class);
    private final String httpVerb;
    private final String resourcePath;

    public NosSigner(String httpVerb, String resourcePath) {
        this.httpVerb = httpVerb;
        this.resourcePath = resourcePath;
        if (resourcePath == null) {
            throw new IllegalArgumentException("Parameter resourcePath is empty");
        }
    }

    @Override
    public void sign(Request<?> request, Credentials credentials) throws ClientException {
        if (credentials == null) {
            log.debug("Canonical string will not be signed, as no  Secret Key was provided");
            return;
        }
        Credentials sanitizedCredentials = this.sanitizeCredentials(credentials);
        request.addHeader("Date", ServiceUtils.formatRfc822DateShangHai(new Date()));
        String canonicalString = RestUtils.makeNosCanonicalString(this.httpVerb, this.resourcePath, request, null);
        log.debug("Calculated string to sign:\n\"" + canonicalString + "\"");
        String signature = super.signAndBase64Encode(canonicalString, sanitizedCredentials.getSecretKey(), SigningAlgorithm.HmacSHA256);
        request.addHeader("Authorization", "NOS " + sanitizedCredentials.getAccessKeyId() + ":" + signature);
    }
}

