/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.services.nos.internal;

import com.netease.cloud.WebServiceResponse;
import com.netease.cloud.http.HttpResponse;
import com.netease.cloud.services.nos.internal.HeaderHandler;
import com.netease.cloud.services.nos.internal.NosXmlResponseHandler;
import com.netease.cloud.transform.Unmarshaller;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;

public class ResponseHeaderHandlerChain<T>
extends NosXmlResponseHandler<T> {
    private final List<HeaderHandler<T>> headerHandlers;

    public ResponseHeaderHandlerChain(Unmarshaller<T, InputStream> responseUnmarshaller, HeaderHandler<T> ... headerHandlers) {
        super(responseUnmarshaller);
        this.headerHandlers = Arrays.asList(headerHandlers);
    }

    @Override
    public WebServiceResponse<T> handle(HttpResponse response) throws Exception {
        Object Response = super.handle(response);
        Object result = ((WebServiceResponse)Response).getResult();
        if (result != null) {
            for (HeaderHandler handler : this.headerHandlers) {
                handler.handle(result, response);
            }
        }
        return Response;
    }
}

