/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.services.nos.internal;

import com.netease.cloud.Request;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class RestUtils {
    private static final List<String> SIGNED_PARAMETERS = Arrays.asList("acl", "location", "versioning", "versions", "versionId", "uploadId", "uploads", "partNumber", "delete", "deduplication");

    public static <T> String makeNosCanonicalString(String method, String resource, Request<T> request, String expires) {
        String value;
        String key;
        StringBuilder buf = new StringBuilder();
        buf.append(method + "\n");
        Map<String, String> headersMap = request.getHeaders();
        TreeMap<String, String> interestingHeaders = new TreeMap<String, String>();
        if (headersMap != null && headersMap.size() > 0) {
            for (Map.Entry<String, String> entry : headersMap.entrySet()) {
                String lk;
                key = entry.getKey();
                value = entry.getValue();
                if (key == null || !(lk = key.toString().toLowerCase(Locale.getDefault())).equals("content-type") && !lk.equals("content-md5") && !lk.equals("date") && !lk.startsWith("x-nos-")) continue;
                interestingHeaders.put(lk, value);
            }
        }
        if (interestingHeaders.containsKey("x-nos-date")) {
            interestingHeaders.put("date", "");
        }
        if (expires != null) {
            interestingHeaders.put("date", expires);
        }
        if (!interestingHeaders.containsKey("content-type")) {
            interestingHeaders.put("content-type", "");
        }
        if (!interestingHeaders.containsKey("content-md5")) {
            interestingHeaders.put("content-md5", "");
        }
        for (Map.Entry<String, String> entry : request.getParameters().entrySet()) {
            if (!entry.getKey().startsWith("x-nos-")) continue;
            interestingHeaders.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : interestingHeaders.entrySet()) {
            key = (String)entry.getKey();
            value = entry.getValue();
            if (key.startsWith("x-nos-")) {
                buf.append(key).append(':').append((Object)value);
            } else {
                buf.append((Object)value);
            }
            buf.append("\n");
        }
        buf.append(resource);
        Object[] parameterNames = request.getParameters().keySet().toArray(new String[request.getParameters().size()]);
        Arrays.sort(parameterNames);
        int n = 63;
        for (Object parameterName : parameterNames) {
            int n2;
            if (!SIGNED_PARAMETERS.contains(parameterName)) continue;
            buf.append((char)n2);
            buf.append((String)parameterName);
            String parameterValue = request.getParameters().get(parameterName);
            if (parameterValue != null) {
                buf.append("=").append(parameterValue);
            }
            n2 = 38;
        }
        return buf.toString();
    }
}

