/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.services.nos.internal;

import com.netease.cloud.ClientException;
import com.netease.cloud.Request;
import com.netease.cloud.services.nos.internal.Constants;
import com.netease.cloud.services.nos.model.NOSObject;
import com.netease.cloud.services.nos.transfer.Transfer;
import com.netease.cloud.services.nos.transfer.internal.DownloadImpl;
import com.netease.cloud.util.DateUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceUtils {
    private static final Logger log = LoggerFactory.getLogger(ServiceUtils.class);
    protected static final DateUtils dateUtils = new DateUtils();

    public static Date parseIso8601Date(String dateString) throws ParseException {
        return dateUtils.parseIso8601Date(dateString);
    }

    public static String formatIso8601Date(Date date) {
        return dateUtils.formatIso8601Date(date);
    }

    public static Date parseRfc822Date(String dateString) throws ParseException {
        return dateUtils.parseRfc822Date(dateString);
    }

    public static String formatRfc822Date(Date date) {
        return dateUtils.formatRfc822Date(date);
    }

    public static String formatRfc822DateShangHai(Date date) {
        return dateUtils.formatRfc822DateShangHai(date);
    }

    public static boolean isMultipartUploadETag(String eTag) {
        if (eTag == null) {
            return false;
        }
        return eTag.contains("-");
    }

    public static byte[] toByteArray(String s) {
        try {
            return s.getBytes(Constants.DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            log.warn("Encoding " + Constants.DEFAULT_ENCODING + " is not supported", (Throwable)e);
            return s.getBytes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] computeMD5Hash(InputStream is) throws NoSuchAlgorithmException, IOException {
        BufferedInputStream bis = new BufferedInputStream(is);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[16384];
            int bytesRead = -1;
            while ((bytesRead = bis.read(buffer, 0, buffer.length)) != -1) {
                messageDigest.update(buffer, 0, bytesRead);
            }
            byte[] byArray = messageDigest.digest();
            return byArray;
        }
        finally {
            try {
                bis.close();
            }
            catch (Exception e) {
                System.err.println("Unable to close input stream of hash candidate: " + e);
            }
        }
    }

    public static byte[] computeMD5Hash(byte[] data) throws NoSuchAlgorithmException, IOException {
        return ServiceUtils.computeMD5Hash(new ByteArrayInputStream(data));
    }

    public static String removeQuotes(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String urlEncode(String s) {
        if (s == null) {
            return null;
        }
        try {
            String encodedString = URLEncoder.encode(s, Constants.DEFAULT_ENCODING);
            return encodedString.replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientException("Unable to encode path: " + s, e);
        }
    }

    public static URL convertRequestToUrl(Request<?> request) {
        String urlString = request.getEndpoint() + "/" + request.getResourcePath();
        boolean firstParam = true;
        for (String param : request.getParameters().keySet()) {
            if (firstParam) {
                urlString = urlString + "?";
                firstParam = false;
            } else {
                urlString = urlString + "&";
            }
            String value = request.getParameters().get(param);
            urlString = urlString + param + "=" + ServiceUtils.urlEncode(value);
        }
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new ClientException("Unable to convert request to well formed URL: " + e.getMessage(), e);
        }
    }

    public static String join(List<String> strings) {
        String result = "";
        boolean first = true;
        for (String s : strings) {
            if (!first) {
                result = result + ", ";
            }
            result = result + s;
            first = false;
        }
        return result;
    }

    public static void downloadObjectToFile(NOSObject Object2, File destinationFile) {
        File parentDirectory = destinationFile.getParentFile();
        if (parentDirectory != null && !parentDirectory.exists()) {
            parentDirectory.mkdirs();
        }
        OutputStream outputStream = null;
        try {
            int bytesRead;
            outputStream = new BufferedOutputStream(new FileOutputStream(destinationFile));
            byte[] buffer = new byte[10240];
            long contentLength = Object2.getObjectMetadata().getContentLength();
            int byteReadAll = 0;
            while ((bytesRead = Object2.getObjectContent().read(buffer)) > -1) {
                outputStream.write(buffer, 0, bytesRead);
                byteReadAll += bytesRead;
            }
            if ((long)byteReadAll != contentLength) {
                throw new IOException();
            }
        }
        catch (IOException e) {
            try {
                Object2.getObjectContent().abort();
            }
            catch (IOException abortException) {
                log.warn("Couldn't abort stream", (Throwable)e);
            }
            throw new ClientException("Unable to store object contents to disk: " + e.getMessage(), e);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
            try {
                Object2.getObjectContent().close();
            }
            catch (Exception exception) {}
        }
    }

    public static void downloadObjectToFile(DownloadImpl download, File destinationFile, long rangeBegin, long rangeEnd) {
        File parentDirectory = destinationFile.getParentFile();
        if (parentDirectory != null && !parentDirectory.exists()) {
            parentDirectory.mkdirs();
        }
        OutputStream outputStream = null;
        NOSObject nosObject = download.getNosObject();
        try {
            int bytesRead;
            outputStream = new BufferedOutputStream(new FileOutputStream(destinationFile, true));
            byte[] buffer = new byte[10240];
            Map<String, String> rawMetaData = nosObject.getObjectMetadata().getUserMetadata();
            long contentLength = rangeEnd - rangeBegin + 1L;
            int byteReadAll = 0;
            while ((bytesRead = nosObject.getObjectContent().read(buffer)) > -1 && download.getState() == Transfer.TransferState.InProgress) {
                outputStream.write(buffer, 0, bytesRead);
                byteReadAll += bytesRead;
            }
            if ((long)byteReadAll != contentLength && download.getState() == Transfer.TransferState.InProgress) {
                throw new IOException();
            }
        }
        catch (IOException e) {
            try {
                nosObject.getObjectContent().abort();
            }
            catch (IOException abortException) {
                log.warn("Couldn't abort stream", (Throwable)e);
            }
            throw new ClientException("Unable to store object contents to disk: " + e.getMessage(), e);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
            try {
                nosObject.getObjectContent().close();
            }
            catch (Exception exception) {}
        }
    }
}

