/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.services.nos.transfer.internal;

import com.netease.cloud.services.nos.transfer.Transfer;
import com.netease.cloud.services.nos.transfer.TransferProgress;
import com.netease.cloud.services.nos.transfer.internal.AbstractTransfer;
import com.netease.cloud.services.nos.transfer.internal.ProgressListenerChain;
import java.util.Collection;

public abstract class MultipleFileTransfer
extends AbstractTransfer {
    protected final Collection<? extends Transfer> subTransfers;

    MultipleFileTransfer(String description, TransferProgress transferProgress, ProgressListenerChain progressListenerChain, Collection<? extends Transfer> subTransfers) {
        super(description, transferProgress, progressListenerChain);
        this.subTransfers = subTransfers;
    }

    public void collateFinalState() {
        boolean seenCanceled = false;
        for (Transfer transfer : this.subTransfers) {
            if (transfer.getState() == Transfer.TransferState.Failed) {
                this.setState(Transfer.TransferState.Failed);
                return;
            }
            if (transfer.getState() != Transfer.TransferState.Canceled) continue;
            seenCanceled = true;
        }
        if (seenCanceled) {
            this.setState(Transfer.TransferState.Canceled);
        } else {
            this.setState(Transfer.TransferState.Completed);
        }
    }
}

