/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.services.nos.transfer.internal;

import com.netease.cloud.services.nos.model.PutObjectRequest;
import com.netease.cloud.services.nos.transfer.TransferManagerConfiguration;
import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;

public class TransferManagerUtils {
    public static ThreadPoolExecutor createDefaultExecutorService() {
        ThreadFactory threadFactory = new ThreadFactory(){
            private int threadCount = 1;

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName("Nos-transfer-manager-worker-" + this.threadCount++);
                return thread;
            }
        };
        return (ThreadPoolExecutor)Executors.newFixedThreadPool(10, threadFactory);
    }

    public static boolean isUploadParallelizable(PutObjectRequest putObjectRequest) {
        return TransferManagerUtils.getRequestFile(putObjectRequest) != null;
    }

    public static long getContentLength(PutObjectRequest putObjectRequest) {
        File file = TransferManagerUtils.getRequestFile(putObjectRequest);
        if (file != null) {
            return file.length();
        }
        if (putObjectRequest.getInputStream() != null && putObjectRequest.getMetadata().getContentLength() > 0L) {
            return putObjectRequest.getMetadata().getContentLength();
        }
        return -1L;
    }

    public static long calculateOptimalPartSize(PutObjectRequest putObjectRequest, TransferManagerConfiguration configuration) {
        double contentLength = TransferManagerUtils.getContentLength(putObjectRequest);
        double optimalPartSize = contentLength / 10000.0;
        optimalPartSize = Math.ceil(optimalPartSize);
        return (long)Math.max(optimalPartSize, (double)configuration.getMinimumUploadPartSize());
    }

    public static boolean shouldUseMultipartUpload(PutObjectRequest putObjectRequest, TransferManagerConfiguration configuration) {
        long contentLength = TransferManagerUtils.getContentLength(putObjectRequest);
        return contentLength > configuration.getMultipartUploadThreshold();
    }

    public static File getRequestFile(PutObjectRequest putObjectRequest) {
        if (putObjectRequest.getFile() != null) {
            return putObjectRequest.getFile();
        }
        return null;
    }
}

