/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.services.nos.transfer.internal;

import com.netease.cloud.services.nos.Nos;
import com.netease.cloud.services.nos.model.AbortMultipartUploadRequest;
import com.netease.cloud.services.nos.model.CompleteMultipartUploadRequest;
import com.netease.cloud.services.nos.model.CompleteMultipartUploadResult;
import com.netease.cloud.services.nos.model.InitiateMultipartUploadRequest;
import com.netease.cloud.services.nos.model.PartETag;
import com.netease.cloud.services.nos.model.ProgressEvent;
import com.netease.cloud.services.nos.model.PutObjectRequest;
import com.netease.cloud.services.nos.model.PutObjectResult;
import com.netease.cloud.services.nos.model.StorageClass;
import com.netease.cloud.services.nos.model.UploadPartRequest;
import com.netease.cloud.services.nos.transfer.Transfer;
import com.netease.cloud.services.nos.transfer.TransferManager;
import com.netease.cloud.services.nos.transfer.TransferManagerConfiguration;
import com.netease.cloud.services.nos.transfer.internal.ProgressListenerChain;
import com.netease.cloud.services.nos.transfer.internal.TransferManagerUtils;
import com.netease.cloud.services.nos.transfer.internal.UploadImpl;
import com.netease.cloud.services.nos.transfer.internal.UploadPartCallable;
import com.netease.cloud.services.nos.transfer.internal.UploadPartRequestFactory;
import com.netease.cloud.services.nos.transfer.model.UploadResult;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadCallable
implements Callable<UploadResult> {
    private final Nos nos;
    private final ExecutorService threadPool;
    private final PutObjectRequest putObjectRequest;
    private String multipartUploadId;
    private final UploadImpl upload;
    private static final Logger log = LoggerFactory.getLogger(UploadCallable.class);
    private final TransferManagerConfiguration configuration;
    private final ProgressListenerChain progressListenerChain;
    private final List<Future<PartETag>> futures = new ArrayList<Future<PartETag>>();

    public UploadCallable(TransferManager transferManager, ExecutorService threadPool, UploadImpl upload, PutObjectRequest putObjectRequest, ProgressListenerChain progressListenerChain) {
        this.nos = transferManager.getNosClient();
        this.configuration = transferManager.getConfiguration();
        this.threadPool = threadPool;
        this.putObjectRequest = putObjectRequest;
        this.progressListenerChain = progressListenerChain;
        this.upload = upload;
    }

    List<Future<PartETag>> getFutures() {
        return this.futures;
    }

    String getMultipartUploadId() {
        return this.multipartUploadId;
    }

    public boolean isMultipartUpload() {
        return TransferManagerUtils.shouldUseMultipartUpload(this.putObjectRequest, this.configuration);
    }

    @Override
    public UploadResult call() throws Exception {
        this.upload.setState(Transfer.TransferState.InProgress);
        if (this.isMultipartUpload()) {
            this.fireProgressEvent(1);
            return this.uploadInParts();
        }
        return this.uploadInOneChunk();
    }

    private UploadResult uploadInOneChunk() {
        PutObjectResult putObjectResult = this.nos.putObject(this.putObjectRequest);
        UploadResult uploadResult = new UploadResult();
        uploadResult.setBucketName(this.putObjectRequest.getBucketName());
        uploadResult.setKey(this.putObjectRequest.getKey());
        uploadResult.setETag(putObjectResult.getETag());
        uploadResult.setVersionId(putObjectResult.getVersionId());
        return uploadResult;
    }

    private UploadResult uploadInParts() throws Exception {
        String bucketName = this.putObjectRequest.getBucketName();
        String key = this.putObjectRequest.getKey();
        long optimalPartSize = this.getOptimalPartSize(false);
        this.multipartUploadId = this.initiateMultipartUpload(this.putObjectRequest);
        try {
            UploadPartRequestFactory requestFactory = new UploadPartRequestFactory(this.putObjectRequest, this.multipartUploadId, optimalPartSize);
            if (TransferManagerUtils.isUploadParallelizable(this.putObjectRequest)) {
                this.uploadPartsInParallel(requestFactory);
                UploadResult uploadResult = null;
                return uploadResult;
            }
            UploadResult uploadResult = this.uploadPartsInSeries(requestFactory);
            return uploadResult;
        }
        catch (Exception e) {
            this.fireProgressEvent(4);
            try {
                this.nos.abortMultipartUpload(new AbortMultipartUploadRequest(bucketName, key, this.multipartUploadId));
            }
            catch (Exception e2) {
                log.info("Unable to abort multipart upload, you may need to manually remove uploaded parts: " + e2.getMessage(), (Throwable)e2);
            }
            throw e;
        }
        finally {
            if (this.putObjectRequest.getInputStream() != null) {
                try {
                    this.putObjectRequest.getInputStream().close();
                }
                catch (Exception e) {
                    log.warn("Unable to cleanly close input stream: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private long getOptimalPartSize(boolean isUsingEncryption) {
        long optimalPartSize = TransferManagerUtils.calculateOptimalPartSize(this.putObjectRequest, this.configuration);
        if (isUsingEncryption && optimalPartSize % 32L > 0L) {
            optimalPartSize = optimalPartSize - optimalPartSize % 32L + 32L;
        }
        log.debug("Calculated optimal part size: " + optimalPartSize);
        return optimalPartSize;
    }

    private UploadResult uploadPartsInSeries(UploadPartRequestFactory requestFactory) {
        ArrayList<PartETag> partETags = new ArrayList<PartETag>();
        while (requestFactory.hasMoreRequests()) {
            if (this.threadPool.isShutdown()) {
                throw new CancellationException("TransferManager has been shutdown");
            }
            UploadPartRequest uploadPartRequest = requestFactory.getNextUploadPartRequest();
            InputStream inputStream = uploadPartRequest.getInputStream();
            if (inputStream != null && inputStream.markSupported()) {
                if (uploadPartRequest.getPartSize() >= Integer.MAX_VALUE) {
                    inputStream.mark(Integer.MAX_VALUE);
                } else {
                    inputStream.mark((int)uploadPartRequest.getPartSize());
                }
            }
            partETags.add(this.nos.uploadPart(uploadPartRequest).getPartETag());
        }
        CompleteMultipartUploadRequest request = new CompleteMultipartUploadRequest(this.putObjectRequest.getBucketName(), this.putObjectRequest.getKey(), this.multipartUploadId, partETags);
        if (this.putObjectRequest.needSetLogInfo()) {
            request.setLogID(this.putObjectRequest.getLogID());
            request.setLogSeq(this.putObjectRequest.getAndIncrementLogSeq());
        }
        CompleteMultipartUploadResult completeMultipartUploadResult = this.nos.completeMultipartUpload(request);
        this.fireProgressEvent(2);
        UploadResult uploadResult = new UploadResult();
        uploadResult.setBucketName(completeMultipartUploadResult.getBucketName());
        uploadResult.setKey(completeMultipartUploadResult.getKey());
        uploadResult.setETag(completeMultipartUploadResult.getETag());
        uploadResult.setVersionId(completeMultipartUploadResult.getVersionId());
        return uploadResult;
    }

    private void uploadPartsInParallel(UploadPartRequestFactory requestFactory) {
        while (requestFactory.hasMoreRequests()) {
            if (this.threadPool.isShutdown()) {
                throw new CancellationException("TransferManager has been shutdown");
            }
            UploadPartRequest request = requestFactory.getNextUploadPartRequest();
            this.futures.add(this.threadPool.submit(new UploadPartCallable(this.nos, request)));
        }
    }

    private String initiateMultipartUpload(PutObjectRequest putObjectRequest) {
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(putObjectRequest.getBucketName(), putObjectRequest.getKey()).withCannedACL(putObjectRequest.getCannedAcl()).withObjectMetadata(putObjectRequest.getMetadata());
        if (putObjectRequest.needSetLogInfo()) {
            initiateMultipartUploadRequest.setLogID(putObjectRequest.getLogID());
            initiateMultipartUploadRequest.setLogSeq(putObjectRequest.getAndIncrementLogSeq());
        }
        if (putObjectRequest.getStorageClass() != null) {
            initiateMultipartUploadRequest.setStorageClass(StorageClass.fromValue(putObjectRequest.getStorageClass()));
        }
        String uploadId = this.nos.initiateMultipartUpload(initiateMultipartUploadRequest).getUploadId();
        log.debug("Initiated new multipart upload: " + uploadId);
        return uploadId;
    }

    private void fireProgressEvent(int eventType) {
        if (this.progressListenerChain == null) {
            return;
        }
        ProgressEvent event = new ProgressEvent(0);
        event.setEventCode(eventType);
        this.progressListenerChain.progressChanged(event);
    }
}

