/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.services.nos.transfer.internal;

import com.netease.cloud.ClientException;
import com.netease.cloud.services.nos.Nos;
import com.netease.cloud.services.nos.model.CompleteMultipartUploadRequest;
import com.netease.cloud.services.nos.model.CompleteMultipartUploadResult;
import com.netease.cloud.services.nos.model.PartETag;
import com.netease.cloud.services.nos.model.ProgressEvent;
import com.netease.cloud.services.nos.model.PutObjectRequest;
import com.netease.cloud.services.nos.transfer.Transfer;
import com.netease.cloud.services.nos.transfer.TransferManager;
import com.netease.cloud.services.nos.transfer.TransferManagerConfiguration;
import com.netease.cloud.services.nos.transfer.internal.ProgressListenerChain;
import com.netease.cloud.services.nos.transfer.internal.TransferMonitor;
import com.netease.cloud.services.nos.transfer.internal.UploadCallable;
import com.netease.cloud.services.nos.transfer.internal.UploadImpl;
import com.netease.cloud.services.nos.transfer.model.UploadResult;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class UploadMonitor
implements Callable<UploadResult>,
TransferMonitor {
    private final Nos nos;
    private final ExecutorService threadPool;
    private final PutObjectRequest putObjectRequest;
    private ScheduledExecutorService timedThreadPool;
    private final ProgressListenerChain progressListenerChain;
    private final UploadCallable multipartUploadCallable;
    private final UploadImpl transfer;
    private TransferManagerConfiguration configuration;
    private String uploadId;
    private final List<Future<PartETag>> futures = new ArrayList<Future<PartETag>>();
    private boolean isUploadDone = false;
    private Future<UploadResult> nextFuture;
    private int pollInterval = 5000;

    public synchronized Future<UploadResult> getFuture() {
        return this.nextFuture;
    }

    private synchronized void setNextFuture(Future<UploadResult> nextFuture) {
        this.nextFuture = nextFuture;
    }

    @Override
    public synchronized boolean isDone() {
        return this.isUploadDone;
    }

    private synchronized void markAllDone() {
        this.isUploadDone = true;
    }

    public UploadMonitor(TransferManager manager, UploadImpl transfer, ExecutorService threadPool, UploadCallable multipartUploadCallable, PutObjectRequest putObjectRequest, ProgressListenerChain progressListenerChain) {
        this.nos = manager.getNosClient();
        this.configuration = manager.getConfiguration();
        this.multipartUploadCallable = multipartUploadCallable;
        this.threadPool = threadPool;
        this.putObjectRequest = putObjectRequest;
        this.progressListenerChain = progressListenerChain;
        this.transfer = transfer;
        this.setNextFuture(threadPool.submit(this));
    }

    public void setTimedThreadPool(ScheduledExecutorService timedThreadPool) {
        this.timedThreadPool = timedThreadPool;
    }

    @Override
    public UploadResult call() throws Exception {
        try {
            if (this.uploadId == null) {
                return this.upload();
            }
            return this.poll();
        }
        catch (CancellationException e) {
            this.transfer.setState(Transfer.TransferState.Canceled);
            this.fireProgressEvent(8);
            throw new ClientException("Upload canceled");
        }
        catch (Exception e) {
            this.transfer.setState(Transfer.TransferState.Failed);
            this.fireProgressEvent(4);
            throw e;
        }
    }

    private UploadResult poll() throws InterruptedException {
        for (Future<PartETag> f : this.futures) {
            if (f.isDone()) continue;
            this.reschedule();
            return null;
        }
        for (Future<PartETag> f : this.futures) {
            if (!f.isCancelled()) continue;
            throw new CancellationException();
        }
        return this.completeMultipartUpload();
    }

    private UploadResult upload() throws Exception, InterruptedException {
        UploadResult result = this.multipartUploadCallable.call();
        if (result != null) {
            this.uploadComplete();
        } else {
            this.uploadId = this.multipartUploadCallable.getMultipartUploadId();
            this.futures.addAll(this.multipartUploadCallable.getFutures());
            this.reschedule();
        }
        return result;
    }

    private void uploadComplete() {
        this.markAllDone();
        this.transfer.setState(Transfer.TransferState.Completed);
        if (this.multipartUploadCallable.isMultipartUpload()) {
            this.fireProgressEvent(2);
        }
    }

    private void reschedule() {
        this.setNextFuture(this.timedThreadPool.schedule(new Callable<UploadResult>(){

            @Override
            public UploadResult call() throws Exception {
                UploadMonitor.this.setNextFuture(UploadMonitor.this.threadPool.submit(UploadMonitor.this));
                return null;
            }
        }, (long)this.pollInterval, TimeUnit.MILLISECONDS));
    }

    private void fireProgressEvent(int eventType) {
        if (this.progressListenerChain == null) {
            return;
        }
        ProgressEvent event = new ProgressEvent(0);
        event.setEventCode(eventType);
        this.progressListenerChain.progressChanged(event);
    }

    private UploadResult completeMultipartUpload() {
        CompleteMultipartUploadRequest request = new CompleteMultipartUploadRequest(this.putObjectRequest.getBucketName(), this.putObjectRequest.getKey(), this.uploadId, this.collectPartETags());
        if (this.putObjectRequest.needSetLogInfo()) {
            request.setLogID(this.putObjectRequest.getLogID());
            request.setLogSeq(this.putObjectRequest.getAndIncrementLogSeq());
        }
        CompleteMultipartUploadResult completeMultipartUploadResult = this.nos.completeMultipartUpload(request);
        this.uploadComplete();
        UploadResult uploadResult = new UploadResult();
        uploadResult.setBucketName(completeMultipartUploadResult.getBucketName());
        uploadResult.setKey(completeMultipartUploadResult.getKey());
        uploadResult.setETag(completeMultipartUploadResult.getETag());
        uploadResult.setVersionId(completeMultipartUploadResult.getVersionId());
        return uploadResult;
    }

    private List<PartETag> collectPartETags() {
        ArrayList<PartETag> partETags = new ArrayList<PartETag>(this.futures.size());
        for (Future<PartETag> future : this.futures) {
            try {
                partETags.add(future.get());
            }
            catch (Exception e) {
                throw new ClientException("Unable to upload part: " + e.getCause().getMessage(), e.getCause());
            }
        }
        return partETags;
    }
}

