/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.transform;

import com.netease.cloud.ServiceException;
import com.netease.cloud.transform.AbstractErrorUnmarshaller;
import com.netease.cloud.util.XpathUtils;
import org.w3c.dom.Node;

public class StandardErrorUnmarshaller
extends AbstractErrorUnmarshaller<Node> {
    public StandardErrorUnmarshaller() {
    }

    protected StandardErrorUnmarshaller(Class<? extends ServiceException> exceptionClass) {
        super(exceptionClass);
    }

    @Override
    public ServiceException unmarshall(Node in) throws Exception {
        String errorCode = this.parseErrorCode(in);
        String errorType = XpathUtils.asString("ErrorResponse/Error/Type", in);
        String requestId = XpathUtils.asString("ErrorResponse/RequestId", in);
        String message = XpathUtils.asString("ErrorResponse/Error/Message", in);
        ServiceException ase = this.newException(message);
        ase.setErrorCode(errorCode);
        ase.setRequestId(requestId);
        if (errorType == null) {
            ase.setErrorType(ServiceException.ErrorType.Unknown);
        } else if (errorType.equalsIgnoreCase("Receiver")) {
            ase.setErrorType(ServiceException.ErrorType.Service);
        } else if (errorType.equalsIgnoreCase("Sender")) {
            ase.setErrorType(ServiceException.ErrorType.Client);
        }
        return ase;
    }

    public String parseErrorCode(Node in) throws Exception {
        return XpathUtils.asString("ErrorResponse/Error/Code", in);
    }

    public String getErrorPropertyPath(String property) {
        return "ErrorResponse/Error/" + property;
    }
}

