/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.util;

import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateUtils {
    private static final DateTimeFormatter iso8601DateFormat = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS Z").withLocale(Locale.US);
    private static final DateTimeFormatter alternateIso8601DateFormat = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss Z").withLocale(Locale.US);
    private static final DateTimeFormatter alternateIso8601DateFormatUTC = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss Z").withLocale(Locale.US).withZoneUTC();
    private static final DateTimeFormatter rfc822DateFormat = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss ZZZ").withLocale(Locale.US);
    private static final DateTimeFormatter rfc822DateFormatShangHai = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss ZZZ").withLocale(Locale.US).withZone(DateTimeZone.forID((String)"Asia/Shanghai"));

    public Date parseIso8601Date(String dateString) throws ParseException {
        try {
            return new Date(iso8601DateFormat.parseMillis(dateString));
        }
        catch (Exception e) {
            return new Date(alternateIso8601DateFormat.parseMillis(dateString));
        }
    }

    public String formatIso8601Date(Date date) {
        return iso8601DateFormat.print(date.getTime());
    }

    public String formatIso8601DateUTC(Date date) {
        return alternateIso8601DateFormatUTC.print(date.getTime()).replace("+0800", "Z");
    }

    public Date parseRfc822Date(String dateString) throws ParseException {
        long mills = rfc822DateFormat.parseMillis(dateString);
        return new Date(mills);
    }

    public String formatRfc822Date(Date date) {
        return rfc822DateFormat.print(date.getTime());
    }

    public String formatRfc822DateShangHai(Date date) {
        return rfc822DateFormatShangHai.print(date.getTime());
    }
}

