/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.mysql;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.obmysql.OBParser;
import com.oceanbase.tools.sqlparser.obmysql.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.common.CharacterType;
import com.oceanbase.tools.sqlparser.statement.common.DataType;
import com.oceanbase.tools.sqlparser.statement.common.GeneralDataType;
import com.oceanbase.tools.sqlparser.statement.common.NumberType;
import com.oceanbase.tools.sqlparser.statement.common.TimestampType;
import com.oceanbase.tools.sqlparser.statement.common.mysql.CollectionType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;

public class MySQLDataTypeFactory
extends OBParserBaseVisitor<DataType>
implements StatementFactory<DataType> {
    private final ParserRuleContext parserRuleContext;

    public MySQLDataTypeFactory(@NonNull OBParser.Cast_data_typeContext castDataTypeContext) {
        if (castDataTypeContext == null) {
            throw new NullPointerException("castDataTypeContext is marked non-null but is null");
        }
        this.parserRuleContext = castDataTypeContext;
    }

    public MySQLDataTypeFactory(@NonNull OBParser.Data_typeContext dataTypeContext) {
        if (dataTypeContext == null) {
            throw new NullPointerException("dataTypeContext is marked non-null but is null");
        }
        this.parserRuleContext = dataTypeContext;
    }

    @Override
    public DataType generate() {
        return (DataType)this.visit((ParseTree)this.parserRuleContext);
    }

    @Override
    public DataType visitData_type(OBParser.Data_typeContext ctx) {
        if (ctx.STRING_VALUE() != null) {
            return new GeneralDataType(ctx, ctx.STRING_VALUE().getText(), null);
        }
        return (DataType)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public DataType visitCast_data_type(OBParser.Cast_data_typeContext ctx) {
        if (ctx.SIGNED() != null || ctx.UNSIGNED() != null || ctx.INTEGER() != null) {
            StringBuilder builder = new StringBuilder();
            if (ctx.SIGNED() != null) {
                builder.append(ctx.SIGNED().getText());
            } else {
                builder.append(ctx.UNSIGNED().getText());
            }
            if (ctx.INTEGER() != null) {
                builder.append(" ").append(ctx.INTEGER().getText());
            }
            return new GeneralDataType(ctx, builder.toString(), null);
        }
        return (DataType)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public DataType visitBinary_type_i(OBParser.Binary_type_iContext ctx) {
        ArrayList<String> args = new ArrayList<String>();
        String arg = this.getLength(ctx.string_length_i());
        if (arg != null) {
            args.add(arg);
        }
        return new GeneralDataType(ctx, ctx.getChild(0).getText(), args);
    }

    @Override
    public DataType visitGeo_type_i(OBParser.Geo_type_iContext ctx) {
        return new GeneralDataType(ctx, ctx.getChild(0).getText(), null);
    }

    @Override
    public DataType visitCharacter_type_i(OBParser.Character_type_iContext ctx) {
        ParseTree parseTree;
        BigDecimal len = null;
        String arg = this.getLength(ctx.string_length_i());
        if (arg != null) {
            len = new BigDecimal(arg);
        }
        ArrayList<String> names = new ArrayList<String>(2);
        for (int i = 0; i < ctx.getChildCount() && (parseTree = ctx.getChild(i)) instanceof TerminalNode; ++i) {
            names.add(parseTree.getText());
        }
        CharacterType type = new CharacterType(ctx, String.join((CharSequence)" ", names), len);
        if (ctx.BINARY() != null) {
            type.setBinary(true);
        }
        if (ctx.charset_name() != null) {
            type.setCharset(ctx.charset_name().getText());
        }
        if (ctx.collation() != null) {
            type.setCollation(ctx.collation().collation_name().getText());
        }
        return type;
    }

    @Override
    public DataType visitDatetime_type_i(OBParser.Datetime_type_iContext ctx) {
        if (ctx.TIMESTAMP() != null) {
            BigDecimal precision = null;
            if (ctx.precision_int_num() != null) {
                precision = new BigDecimal(this.getArgs(ctx.precision_int_num()).get(0));
            }
            return new TimestampType(ctx, precision, false, false);
        }
        return new GeneralDataType(ctx, ctx.getChild(0).getText(), this.getArgs(ctx.precision_int_num()));
    }

    @Override
    public DataType visitDate_year_type_i(OBParser.Date_year_type_iContext ctx) {
        return new GeneralDataType(ctx, ctx.getChild(0).getText(), this.getArgs(ctx.precision_int_num()));
    }

    @Override
    public DataType visitFloat_type_i(OBParser.Float_type_iContext ctx) {
        String typeName = ctx.getChild(0).getText();
        if (ctx.PRECISION() != null) {
            typeName = typeName + " " + ctx.PRECISION().getText();
        }
        ArrayList<String> args = new ArrayList<String>(this.getArgs(ctx.data_type_precision()));
        args.addAll(this.getArgs(ctx.precision_int_num()));
        BigDecimal first = null;
        BigDecimal second = null;
        if (!args.isEmpty()) {
            first = new BigDecimal((String)args.get(0));
            if (args.size() > 1) {
                second = new BigDecimal((String)args.get(1));
            }
        }
        NumberType numberType = new NumberType(ctx, typeName, first, second);
        this.setNumberTypeOptions(numberType, ctx.UNSIGNED(), ctx.SIGNED(), ctx.ZEROFILL());
        return numberType;
    }

    @Override
    public DataType visitNumber_type_i(OBParser.Number_type_iContext ctx) {
        String typeName = ctx.getChild(0).getText();
        List<String> args = this.getArgs(ctx.precision_int_num());
        BigDecimal first = null;
        BigDecimal second = null;
        if (!args.isEmpty()) {
            first = new BigDecimal(args.get(0));
            if (args.size() > 1) {
                second = new BigDecimal(args.get(1));
            }
        }
        NumberType numberType = new NumberType(ctx, typeName, first, second);
        this.setNumberTypeOptions(numberType, ctx.UNSIGNED(), ctx.SIGNED(), ctx.ZEROFILL());
        return numberType;
    }

    @Override
    public DataType visitJson_type_i(OBParser.Json_type_iContext ctx) {
        return new GeneralDataType(ctx, ctx.JSON().getText(), null);
    }

    @Override
    public DataType visitInt_type_i(OBParser.Int_type_iContext ctx) {
        List<String> args = this.getArgs(ctx.precision_int_num());
        BigDecimal precision = null;
        if (!args.isEmpty()) {
            precision = new BigDecimal(args.get(0));
        }
        NumberType numberType = new NumberType(ctx, ctx.getChild(0).getText(), precision, null);
        this.setNumberTypeOptions(numberType, ctx.UNSIGNED(), ctx.SIGNED(), ctx.ZEROFILL());
        return numberType;
    }

    @Override
    public DataType visitBool_type_i(OBParser.Bool_type_iContext ctx) {
        return new GeneralDataType(ctx, ctx.getChild(0).getText(), null);
    }

    @Override
    public DataType visitText_type_i(OBParser.Text_type_iContext ctx) {
        ParseTree parseTree;
        BigDecimal len = null;
        String arg = this.getLength(ctx.string_length_i());
        if (arg != null) {
            len = new BigDecimal(arg);
        }
        ArrayList<String> names = new ArrayList<String>(2);
        for (int i = 0; i < ctx.getChildCount() && (parseTree = ctx.getChild(i)) instanceof TerminalNode; ++i) {
            names.add(parseTree.getText());
        }
        CharacterType characterType = new CharacterType(ctx, String.join((CharSequence)" ", names), len);
        if (ctx.BINARY() != null) {
            characterType.setBinary(true);
        }
        if (ctx.charset_name() != null) {
            characterType.setCharset(ctx.charset_name().getText());
        }
        if (ctx.collation() != null) {
            characterType.setCollation(ctx.collation().collation_name().getText());
        }
        return characterType;
    }

    @Override
    public DataType visitBlob_type_i(OBParser.Blob_type_iContext ctx) {
        String arg = this.getLength(ctx.string_length_i());
        List<String> args = arg == null ? null : Collections.singletonList(arg);
        return new GeneralDataType(ctx, ctx.getChild(0).getText(), args);
    }

    @Override
    public DataType visitBit_type_i(OBParser.Bit_type_iContext ctx) {
        return new GeneralDataType(ctx, ctx.BIT().getText(), this.getArgs(ctx.precision_int_num()));
    }

    @Override
    public DataType visitCollection_type_i(OBParser.Collection_type_iContext ctx) {
        List<String> args = ctx.string_list().text_string().stream().map(RuleContext::getText).collect(Collectors.toList());
        CollectionType type = new CollectionType(ctx, ctx.getChild(0).getText(), args);
        if (ctx.BINARY() != null) {
            type.setBinary(true);
        }
        if (ctx.charset_name() != null) {
            type.setCharset(ctx.charset_name().getText());
        }
        if (ctx.collation() != null) {
            type.setCollation(ctx.collation().collation_name().getText());
        }
        return type;
    }

    private void setNumberTypeOptions(NumberType numberType, TerminalNode unsigned, TerminalNode signed, TerminalNode zeroFill) {
        if (unsigned != null) {
            numberType.setSigned(false);
        }
        if (signed != null) {
            numberType.setSigned(true);
        }
        if (zeroFill != null) {
            numberType.setZeroFill(true);
        }
    }

    private List<String> getArgs(OBParser.Precision_int_numContext ctx) {
        if (ctx == null) {
            return Collections.emptyList();
        }
        return ctx.INTNUM().stream().map(ParseTree::getText).collect(Collectors.toList());
    }

    private List<String> getArgs(OBParser.Data_type_precisionContext ctx) {
        if (ctx == null) {
            return Collections.emptyList();
        }
        if (ctx.precision_decimal_num() != null) {
            return Collections.singletonList(ctx.precision_decimal_num().DECIMAL_VAL().getText());
        }
        return this.getArgs(ctx.precision_int_num());
    }

    private String getLength(OBParser.String_length_iContext ctx) {
        if (ctx == null) {
            return null;
        }
        return ctx.number_literal().getText();
    }
}

