/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.mysql;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLColumnRefFactory;
import com.oceanbase.tools.sqlparser.obmysql.OBParser;
import com.oceanbase.tools.sqlparser.obmysql.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.expression.BaseExpression;
import com.oceanbase.tools.sqlparser.statement.expression.ConstExpression;
import com.oceanbase.tools.sqlparser.statement.select.mysql.Limit;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.collections4.CollectionUtils;

public class MySQLLimitFactory
extends OBParserBaseVisitor<Limit>
implements StatementFactory<Limit> {
    private final OBParser.Limit_clauseContext limitClauseContext;

    public MySQLLimitFactory(@NonNull OBParser.Limit_clauseContext limitClauseContext) {
        if (limitClauseContext == null) {
            throw new NullPointerException("limitClauseContext is marked non-null but is null");
        }
        this.limitClauseContext = limitClauseContext;
    }

    @Override
    public Limit generate() {
        return (Limit)this.visit((ParseTree)this.limitClauseContext);
    }

    @Override
    public Limit visitLimit_clause(OBParser.Limit_clauseContext ctx) {
        List exprs = ctx.limit_expr().stream().map(c -> {
            if (c.INTNUM() != null) {
                return new ConstExpression(c.INTNUM());
            }
            if (c.QUESTIONMARK() != null) {
                return new ConstExpression(c.QUESTIONMARK());
            }
            MySQLColumnRefFactory factory = new MySQLColumnRefFactory(c.column_ref());
            return (BaseExpression)factory.generate();
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(exprs)) {
            throw new IllegalStateException("Missing limit row count");
        }
        Limit limit = new Limit((ParserRuleContext)ctx, (Expression)exprs.get(0));
        if (exprs.size() > 1) {
            limit.setOffset((Expression)exprs.get(1));
        }
        return limit;
    }
}

