/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.mysql;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLExpressionFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLPartitionElementFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLSubPartitionOptionFactory;
import com.oceanbase.tools.sqlparser.obmysql.OBParser;
import com.oceanbase.tools.sqlparser.obmysql.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.createtable.ColumnPartition;
import com.oceanbase.tools.sqlparser.statement.createtable.HashPartition;
import com.oceanbase.tools.sqlparser.statement.createtable.HashPartitionElement;
import com.oceanbase.tools.sqlparser.statement.createtable.KeyPartition;
import com.oceanbase.tools.sqlparser.statement.createtable.ListPartition;
import com.oceanbase.tools.sqlparser.statement.createtable.ListPartitionElement;
import com.oceanbase.tools.sqlparser.statement.createtable.Partition;
import com.oceanbase.tools.sqlparser.statement.createtable.RangePartition;
import com.oceanbase.tools.sqlparser.statement.createtable.RangePartitionElement;
import com.oceanbase.tools.sqlparser.statement.createtable.SubPartitionOption;
import com.oceanbase.tools.sqlparser.statement.expression.ColumnReference;
import com.oceanbase.tools.sqlparser.statement.expression.ConstExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class MySQLPartitionFactory
extends OBParserBaseVisitor<Partition>
implements StatementFactory<Partition> {
    private final ParserRuleContext parserRuleContext;

    public MySQLPartitionFactory(@NonNull OBParser.Opt_partition_optionContext optPartitionOptionContext) {
        if (optPartitionOptionContext == null) {
            throw new NullPointerException("optPartitionOptionContext is marked non-null but is null");
        }
        this.parserRuleContext = optPartitionOptionContext;
    }

    public MySQLPartitionFactory(@NonNull OBParser.Partition_optionContext partitionOptionContext) {
        if (partitionOptionContext == null) {
            throw new NullPointerException("partitionOptionContext is marked non-null but is null");
        }
        this.parserRuleContext = partitionOptionContext;
    }

    public MySQLPartitionFactory(@NonNull OBParser.Auto_partition_optionContext autoPartitionOptionContext) {
        if (autoPartitionOptionContext == null) {
            throw new NullPointerException("autoPartitionOptionContext is marked non-null but is null");
        }
        this.parserRuleContext = autoPartitionOptionContext;
    }

    public MySQLPartitionFactory(@NonNull OBParser.Hash_partition_optionContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.parserRuleContext = context;
    }

    public MySQLPartitionFactory(@NonNull OBParser.List_partition_optionContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.parserRuleContext = context;
    }

    public MySQLPartitionFactory(@NonNull OBParser.Key_partition_optionContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.parserRuleContext = context;
    }

    public MySQLPartitionFactory(@NonNull OBParser.Range_partition_optionContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.parserRuleContext = context;
    }

    @Override
    public Partition generate() {
        return (Partition)this.visit((ParseTree)this.parserRuleContext);
    }

    @Override
    public Partition visitHash_partition_option(OBParser.Hash_partition_optionContext ctx) {
        List<Expression> targets = Collections.singletonList(new MySQLExpressionFactory(ctx.expr()).generate());
        List<HashPartitionElement> partitionElts = null;
        if (ctx.opt_hash_partition_list() != null) {
            partitionElts = ctx.opt_hash_partition_list().hash_partition_list().hash_partition_element().stream().map(c -> (HashPartitionElement)new MySQLPartitionElementFactory((OBParser.Hash_partition_elementContext)((Object)c)).generate()).collect(Collectors.toList());
        }
        return new HashPartition((ParserRuleContext)ctx, targets, partitionElts, this.getSubPartitionOption(ctx.partition_options()), this.getPartitionNum(ctx.partition_options()));
    }

    @Override
    public Partition visitList_partition_option(OBParser.List_partition_optionContext ctx) {
        List<Expression> targets = ctx.expr() != null ? Collections.singletonList(new MySQLExpressionFactory(ctx.expr()).generate()) : ctx.column_name_list().column_name().stream().map(c -> new ColumnReference((ParserRuleContext)c, null, null, c.getText())).collect(Collectors.toList());
        List<ListPartitionElement> partitionElts = ctx.opt_list_partition_list().list_partition_list().list_partition_element().stream().map(c -> (ListPartitionElement)new MySQLPartitionElementFactory((OBParser.List_partition_elementContext)((Object)c)).generate()).collect(Collectors.toList());
        return new ListPartition(ctx, targets, partitionElts, this.getSubPartitionOption(ctx.partition_options()), this.getPartitionNum(ctx.partition_options()), ctx.COLUMNS() != null);
    }

    @Override
    public Partition visitKey_partition_option(OBParser.Key_partition_optionContext ctx) {
        List<ColumnReference> targets = null;
        if (ctx.column_name_list() != null) {
            targets = ctx.column_name_list().column_name().stream().map(c -> new ColumnReference((ParserRuleContext)c, null, null, c.getText())).collect(Collectors.toList());
        }
        List<HashPartitionElement> partitionElts = null;
        if (ctx.opt_hash_partition_list() != null) {
            partitionElts = ctx.opt_hash_partition_list().hash_partition_list().hash_partition_element().stream().map(c -> (HashPartitionElement)new MySQLPartitionElementFactory((OBParser.Hash_partition_elementContext)((Object)c)).generate()).collect(Collectors.toList());
        }
        return new KeyPartition((ParserRuleContext)ctx, targets, partitionElts, this.getSubPartitionOption(ctx.partition_options()), this.getPartitionNum(ctx.partition_options()));
    }

    @Override
    public Partition visitRange_partition_option(OBParser.Range_partition_optionContext ctx) {
        List<Expression> targets = ctx.expr() != null ? Collections.singletonList(new MySQLExpressionFactory(ctx.expr()).generate()) : ctx.column_name_list().column_name().stream().map(c -> new ColumnReference((ParserRuleContext)c, null, null, c.getText())).collect(Collectors.toList());
        List<RangePartitionElement> partitionElts = ctx.opt_range_partition_list().range_partition_list().range_partition_element().stream().map(c -> (RangePartitionElement)new MySQLPartitionElementFactory((OBParser.Range_partition_elementContext)((Object)c)).generate()).collect(Collectors.toList());
        return new RangePartition(ctx, targets, partitionElts, this.getSubPartitionOption(ctx.partition_options()), this.getPartitionNum(ctx.partition_options()), ctx.COLUMNS() != null);
    }

    @Override
    public Partition visitColumn_partition_option(OBParser.Column_partition_optionContext ctx) {
        List<ColumnReference> targets = this.getColumnReferences(ctx.vertical_column_name());
        if (ctx.aux_column_list() != null) {
            targets.addAll(ctx.aux_column_list().vertical_column_name().stream().flatMap(c -> this.getColumnReferences((OBParser.Vertical_column_nameContext)((Object)c)).stream()).collect(Collectors.toList()));
        }
        return new ColumnPartition((ParserRuleContext)ctx, targets);
    }

    @Override
    public Partition visitAuto_partition_option(OBParser.Auto_partition_optionContext ctx) {
        OBParser.Auto_range_typeContext context = ctx.auto_partition_type().auto_range_type();
        List<Expression> targets = null;
        if (context.column_name_list() != null) {
            targets = context.column_name_list().column_name().stream().map(c -> new ColumnReference((ParserRuleContext)c, null, null, c.getText())).collect(Collectors.toList());
        } else if (context.expr() != null) {
            targets = Collections.singletonList(new MySQLExpressionFactory(context.expr()).generate());
        }
        RangePartition rangePartition = new RangePartition(ctx, targets, null, null, null, context.COLUMNS() != null);
        rangePartition.setAuto(true);
        rangePartition.setPartitionSize(new ConstExpression(ctx.partition_size()));
        return rangePartition;
    }

    private List<ColumnReference> getColumnReferences(OBParser.Vertical_column_nameContext cxt) {
        ArrayList<ColumnReference> list = new ArrayList<ColumnReference>();
        if (cxt.column_name() != null) {
            list.add(new ColumnReference(cxt.column_name(), null, null, cxt.column_name().getText()));
            return list;
        }
        return cxt.column_name_list().column_name().stream().map(c -> new ColumnReference((ParserRuleContext)c, null, null, c.getText())).collect(Collectors.toList());
    }

    private SubPartitionOption getSubPartitionOption(OBParser.Partition_optionsContext context) {
        if (context == null) {
            return null;
        }
        return context.subpartition_option() == null ? null : new MySQLSubPartitionOptionFactory(context.subpartition_option()).generate();
    }

    private Integer getPartitionNum(OBParser.Partition_optionsContext context) {
        if (context == null) {
            return null;
        }
        return context.partition_num() == null ? null : Integer.valueOf(context.partition_num().INTNUM().getText());
    }
}

