/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.mysql;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLExpressionFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLFromReferenceFactory;
import com.oceanbase.tools.sqlparser.obmysql.OBParser;
import com.oceanbase.tools.sqlparser.obmysql.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.common.RelationFactor;
import com.oceanbase.tools.sqlparser.statement.createtable.PartitionOptions;
import com.oceanbase.tools.sqlparser.statement.createtable.SubHashPartitionElement;
import com.oceanbase.tools.sqlparser.statement.createtable.SubListPartitionElement;
import com.oceanbase.tools.sqlparser.statement.createtable.SubPartitionElement;
import com.oceanbase.tools.sqlparser.statement.createtable.SubRangePartitionElement;
import com.oceanbase.tools.sqlparser.statement.expression.ConstExpression;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class MySQLSubPartitionElementFactory
extends OBParserBaseVisitor<SubPartitionElement>
implements StatementFactory<SubPartitionElement> {
    private final ParserRuleContext parserRuleContext;

    public MySQLSubPartitionElementFactory(@NonNull OBParser.Hash_subpartition_elementContext hashElementContext) {
        if (hashElementContext == null) {
            throw new NullPointerException("hashElementContext is marked non-null but is null");
        }
        this.parserRuleContext = hashElementContext;
    }

    public MySQLSubPartitionElementFactory(@NonNull OBParser.Range_subpartition_elementContext rangeElementContext) {
        if (rangeElementContext == null) {
            throw new NullPointerException("rangeElementContext is marked non-null but is null");
        }
        this.parserRuleContext = rangeElementContext;
    }

    public MySQLSubPartitionElementFactory(@NonNull OBParser.List_subpartition_elementContext listElementContext) {
        if (listElementContext == null) {
            throw new NullPointerException("listElementContext is marked non-null but is null");
        }
        this.parserRuleContext = listElementContext;
    }

    @Override
    public SubPartitionElement generate() {
        return (SubPartitionElement)this.visit((ParseTree)this.parserRuleContext);
    }

    @Override
    public SubPartitionElement visitHash_subpartition_element(OBParser.Hash_subpartition_elementContext ctx) {
        RelationFactor factor = MySQLFromReferenceFactory.getRelationFactor(ctx.relation_factor());
        SubHashPartitionElement element = new SubHashPartitionElement((ParserRuleContext)ctx, factor.getRelation());
        element.setSchema(factor.getSchema());
        element.setUserVariable(factor.getUserVariable());
        element.setPartitionOptions(MySQLSubPartitionElementFactory.getPartitionOptions(ctx.partition_attributes_option()));
        return element;
    }

    @Override
    public SubPartitionElement visitRange_subpartition_element(OBParser.Range_subpartition_elementContext ctx) {
        RelationFactor factor = MySQLFromReferenceFactory.getRelationFactor(ctx.relation_factor());
        List<Expression> rangeExprs = MySQLSubPartitionElementFactory.getRangePartitionExprs(ctx.range_partition_expr());
        SubRangePartitionElement element = new SubRangePartitionElement(ctx, factor.getRelation(), rangeExprs);
        element.setSchema(factor.getSchema());
        element.setUserVariable(factor.getUserVariable());
        element.setPartitionOptions(MySQLSubPartitionElementFactory.getPartitionOptions(ctx.partition_attributes_option()));
        return element;
    }

    @Override
    public SubPartitionElement visitList_subpartition_element(OBParser.List_subpartition_elementContext ctx) {
        RelationFactor factor = MySQLFromReferenceFactory.getRelationFactor(ctx.relation_factor());
        List<Expression> listExprs = MySQLSubPartitionElementFactory.getListPartitionExprs(ctx.list_partition_expr());
        SubListPartitionElement element = new SubListPartitionElement(ctx, factor.getRelation(), listExprs);
        element.setSchema(factor.getSchema());
        element.setUserVariable(factor.getUserVariable());
        element.setPartitionOptions(MySQLSubPartitionElementFactory.getPartitionOptions(ctx.partition_attributes_option()));
        return element;
    }

    public static PartitionOptions getPartitionOptions(OBParser.Partition_attributes_optionContext ctx) {
        if (ctx == null) {
            return null;
        }
        PartitionOptions partitionOptions = new PartitionOptions(ctx);
        partitionOptions.setEngine(ctx.INNODB().getText());
        return partitionOptions;
    }

    public static List<Expression> getListPartitionExprs(OBParser.List_partition_exprContext context) {
        if (context.DEFAULT() != null) {
            return Collections.singletonList(new ConstExpression(context.DEFAULT()));
        }
        return context.list_expr().expr().stream().map(c -> new MySQLExpressionFactory((OBParser.ExprContext)((Object)c)).generate()).collect(Collectors.toList());
    }

    public static List<Expression> getRangePartitionExprs(OBParser.Range_partition_exprContext cxt) {
        if (cxt.MAXVALUE() != null) {
            return Collections.singletonList(new ConstExpression(cxt));
        }
        return cxt.range_expr_list().range_expr().stream().map(c -> {
            if (c.MAXVALUE() != null) {
                return new ConstExpression((ParserRuleContext)c);
            }
            return new MySQLExpressionFactory(c.expr()).generate();
        }).collect(Collectors.toList());
    }
}

