/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.mysql;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLExpressionFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLSubPartitionElementFactory;
import com.oceanbase.tools.sqlparser.obmysql.OBParser;
import com.oceanbase.tools.sqlparser.obmysql.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.createtable.SubPartitionElement;
import com.oceanbase.tools.sqlparser.statement.createtable.SubPartitionOption;
import com.oceanbase.tools.sqlparser.statement.expression.ColumnReference;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class MySQLSubPartitionOptionFactory
extends OBParserBaseVisitor<SubPartitionOption>
implements StatementFactory<SubPartitionOption> {
    private final ParserRuleContext parserRuleContext;

    public MySQLSubPartitionOptionFactory(@NonNull OBParser.Subpartition_optionContext subpartitionOptionContext) {
        if (subpartitionOptionContext == null) {
            throw new NullPointerException("subpartitionOptionContext is marked non-null but is null");
        }
        this.parserRuleContext = subpartitionOptionContext;
    }

    @Override
    public SubPartitionOption generate() {
        return (SubPartitionOption)this.visit((ParseTree)this.parserRuleContext);
    }

    @Override
    public SubPartitionOption visitSubpartition_template_option(OBParser.Subpartition_template_optionContext ctx) {
        List<Expression> subPartitionTargets = ctx.expr() != null ? Collections.singletonList(new MySQLExpressionFactory(ctx.expr()).generate()) : ctx.column_name_list().column_name().stream().map(c -> new ColumnReference((ParserRuleContext)c, null, null, c.getText())).collect(Collectors.toList());
        String type = ctx.COLUMNS() == null ? ctx.getChild(2).getText() : ctx.getChild(2).getText().toLowerCase() + " " + ctx.COLUMNS().getText().toLowerCase();
        SubPartitionOption subPartitionOption = new SubPartitionOption(ctx, subPartitionTargets, type);
        subPartitionOption.setTemplates(this.getSubPartitionElements(ctx));
        return subPartitionOption;
    }

    @Override
    public SubPartitionOption visitSubpartition_individual_option(OBParser.Subpartition_individual_optionContext ctx) {
        List<Expression> targets = ctx.expr() != null ? Collections.singletonList(new MySQLExpressionFactory(ctx.expr()).generate()) : ctx.column_name_list().column_name().stream().map(c -> new ColumnReference((ParserRuleContext)c, null, null, c.getText())).collect(Collectors.toList());
        String type = ctx.COLUMNS() == null ? ctx.getChild(2).getText() : ctx.getChild(2).getText().toLowerCase() + " " + ctx.COLUMNS().getText().toLowerCase();
        SubPartitionOption option = new SubPartitionOption(ctx, targets, type);
        if (ctx.INTNUM() != null) {
            option.setSubPartitionNum(Integer.valueOf(ctx.INTNUM().getText()));
        }
        return option;
    }

    private List<SubPartitionElement> getSubPartitionElements(OBParser.Subpartition_template_optionContext context) {
        if (context == null) {
            return null;
        }
        if (context.opt_hash_subpartition_list() != null) {
            return context.opt_hash_subpartition_list().hash_subpartition_list().hash_subpartition_element().stream().map(c -> new MySQLSubPartitionElementFactory((OBParser.Hash_subpartition_elementContext)((Object)c)).generate()).collect(Collectors.toList());
        }
        if (context.opt_range_subpartition_list() != null) {
            return context.opt_range_subpartition_list().range_subpartition_list().range_subpartition_element().stream().map(c -> new MySQLSubPartitionElementFactory((OBParser.Range_subpartition_elementContext)((Object)c)).generate()).collect(Collectors.toList());
        }
        return context.opt_list_subpartition_list().list_subpartition_list().list_subpartition_element().stream().map(c -> new MySQLSubPartitionElementFactory((OBParser.List_subpartition_elementContext)((Object)c)).generate()).collect(Collectors.toList());
    }
}

