/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.mysql;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLExpressionFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLOrderByFactory;
import com.oceanbase.tools.sqlparser.obmysql.OBParser;
import com.oceanbase.tools.sqlparser.obmysql.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.common.WindowBody;
import com.oceanbase.tools.sqlparser.statement.common.WindowOffset;
import com.oceanbase.tools.sqlparser.statement.common.WindowOffsetType;
import com.oceanbase.tools.sqlparser.statement.common.WindowSpec;
import com.oceanbase.tools.sqlparser.statement.common.WindowType;
import com.oceanbase.tools.sqlparser.statement.expression.IntervalExpression;
import com.oceanbase.tools.sqlparser.statement.select.OrderBy;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class MySQLWindowSpecFactory
extends OBParserBaseVisitor<WindowSpec>
implements StatementFactory<WindowSpec> {
    private final OBParser.New_generalized_window_clauseContext windowClauseContext;
    private final OBParser.New_generalized_window_clause_with_blanketContext windowClauseWithBlanketContext;

    public MySQLWindowSpecFactory(@NonNull OBParser.New_generalized_window_clauseContext windowClauseContext) {
        if (windowClauseContext == null) {
            throw new NullPointerException("windowClauseContext is marked non-null but is null");
        }
        this.windowClauseWithBlanketContext = null;
        this.windowClauseContext = windowClauseContext;
    }

    public MySQLWindowSpecFactory(@NonNull OBParser.New_generalized_window_clause_with_blanketContext windowClauseWithBlanketContext) {
        if (windowClauseWithBlanketContext == null) {
            throw new NullPointerException("windowClauseWithBlanketContext is marked non-null but is null");
        }
        this.windowClauseContext = null;
        this.windowClauseWithBlanketContext = windowClauseWithBlanketContext;
    }

    @Override
    public WindowSpec generate() {
        if (this.windowClauseContext != null) {
            return (WindowSpec)this.visit((ParseTree)this.windowClauseContext);
        }
        return (WindowSpec)this.visit((ParseTree)this.windowClauseWithBlanketContext);
    }

    @Override
    public WindowSpec visitNew_generalized_window_clause(OBParser.New_generalized_window_clauseContext ctx) {
        if (ctx.new_generalized_window_clause_with_blanket() != null) {
            return (WindowSpec)this.visit((ParseTree)ctx.new_generalized_window_clause_with_blanket());
        }
        WindowSpec window = new WindowSpec(ctx);
        window.setName(ctx.NAME_OB().getText());
        return window;
    }

    @Override
    public WindowSpec visitNew_generalized_window_clause_with_blanket(OBParser.New_generalized_window_clause_with_blanketContext ctx) {
        WindowSpec window = new WindowSpec((ParserRuleContext)ctx, (WindowSpec)this.visit((ParseTree)ctx.generalized_window_clause()));
        if (ctx.NAME_OB() != null) {
            window.setName(ctx.NAME_OB().getText());
        }
        return window;
    }

    @Override
    public WindowSpec visitGeneralized_window_clause(OBParser.Generalized_window_clauseContext ctx) {
        WindowSpec window = new WindowSpec(ctx);
        if (ctx.PARTITION() != null) {
            window.setPartitionBy(ctx.expr_list().expr().stream().map(e -> {
                MySQLExpressionFactory factory = new MySQLExpressionFactory((OBParser.ExprContext)((Object)e));
                return (Expression)factory.generate();
            }).collect(Collectors.toList()));
        }
        if (ctx.order_by() != null) {
            MySQLOrderByFactory factory = new MySQLOrderByFactory(ctx.order_by());
            window.setOrderBy((OrderBy)factory.generate());
        }
        if (ctx.win_window() != null) {
            WindowBody body;
            List offsets;
            OBParser.Win_windowContext win = ctx.win_window();
            WindowType windowType = WindowType.RANGE;
            if (win.win_rows_or_range().ROWS() != null) {
                windowType = WindowType.ROWS;
            }
            if ((offsets = win.win_bounding().stream().map(c -> {
                if (c.CURRENT() != null) {
                    return new WindowOffset((ParserRuleContext)c, WindowOffsetType.CURRENT_ROW);
                }
                OBParser.Win_intervalContext w = c.win_interval();
                MySQLExpressionFactory factory = new MySQLExpressionFactory(w.expr());
                WindowOffsetType type = WindowOffsetType.FOLLOWING;
                if (c.win_preceding_or_following().PRECEDING() != null) {
                    type = WindowOffsetType.PRECEDING;
                }
                WindowOffset offset = new WindowOffset((ParserRuleContext)c, type);
                Expression target = (Expression)factory.generate();
                if (w.INTERVAL() == null) {
                    offset.setInterval(target);
                    return offset;
                }
                offset.setInterval(new IntervalExpression(w, target, w.date_unit().getText()));
                return offset;
            }).collect(Collectors.toList())).size() == 1) {
                body = new WindowBody(ctx.win_window(), windowType, (WindowOffset)offsets.get(0));
            } else if (offsets.size() == 2) {
                body = new WindowBody(ctx.win_window(), windowType, (WindowOffset)offsets.get(0), (WindowOffset)offsets.get(1));
            } else {
                throw new IllegalStateException("Window offset's count is illegal");
            }
            window.setBody(body);
        }
        return window;
    }
}

