/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.mysql;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLSelectBodyFactory;
import com.oceanbase.tools.sqlparser.obmysql.OBParser;
import com.oceanbase.tools.sqlparser.obmysql.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.select.SelectBody;
import com.oceanbase.tools.sqlparser.statement.select.WithTable;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.tree.ParseTree;

public class MySQLWithTableFactory
extends OBParserBaseVisitor<WithTable>
implements StatementFactory<WithTable> {
    private final OBParser.Common_table_exprContext commonTableExprContext;

    public MySQLWithTableFactory(@NonNull OBParser.Common_table_exprContext commonTableExprContext) {
        if (commonTableExprContext == null) {
            throw new NullPointerException("commonTableExprContext is marked non-null but is null");
        }
        this.commonTableExprContext = commonTableExprContext;
    }

    @Override
    public WithTable generate() {
        return (WithTable)this.visit((ParseTree)this.commonTableExprContext);
    }

    @Override
    public WithTable visitCommon_table_expr(OBParser.Common_table_exprContext ctx) {
        Object factory;
        String relationName = ctx.relation_name().getText();
        SelectBody select = null;
        if (ctx.select_no_parens() != null) {
            factory = new MySQLSelectBodyFactory(ctx.select_no_parens());
            select = (SelectBody)factory.generate();
        } else if (ctx.select_with_parens() != null) {
            factory = new MySQLSelectBodyFactory(ctx.select_with_parens());
            select = (SelectBody)factory.generate();
        }
        if (select == null) {
            throw new IllegalStateException("Missing select statement");
        }
        if (ctx.with_clause() != null) {
            if (ctx.with_clause().RECURSIVE() != null) {
                select.setRecursive(true);
            }
            for (OBParser.Common_table_exprContext c : ctx.with_clause().with_list().common_table_expr()) {
                select.getWith().add((WithTable)this.visit((ParseTree)c));
            }
        }
        WithTable withTable = new WithTable(ctx, relationName, select);
        if (ctx.alias_name_list() != null) {
            withTable.setAliasList(this.visitAliasNames(ctx.alias_name_list()));
        }
        return withTable;
    }

    private List<String> visitAliasNames(OBParser.Alias_name_listContext ctx) {
        return ctx.column_alias_name().stream().map(c -> c.column_name().getText()).collect(Collectors.toList());
    }
}

