/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.oracle;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.oboracle.OBParser;
import com.oceanbase.tools.sqlparser.oboracle.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.common.CharacterType;
import com.oceanbase.tools.sqlparser.statement.common.DataType;
import com.oceanbase.tools.sqlparser.statement.common.GeneralDataType;
import com.oceanbase.tools.sqlparser.statement.common.NumberType;
import com.oceanbase.tools.sqlparser.statement.common.TimestampType;
import com.oceanbase.tools.sqlparser.statement.common.oracle.IntervalType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.apache.commons.collections4.CollectionUtils;

public class OracleDataTypeFactory
extends OBParserBaseVisitor<DataType>
implements StatementFactory<DataType> {
    private final ParserRuleContext parserRuleContext;

    public OracleDataTypeFactory(@NonNull OBParser.Data_typeContext dataTypeContext) {
        if (dataTypeContext == null) {
            throw new NullPointerException("dataTypeContext is marked non-null but is null");
        }
        this.parserRuleContext = dataTypeContext;
    }

    public OracleDataTypeFactory(@NonNull OBParser.Cast_data_typeContext castDataTypeContext) {
        if (castDataTypeContext == null) {
            throw new NullPointerException("castDataTypeContext is marked non-null but is null");
        }
        this.parserRuleContext = castDataTypeContext;
    }

    public OracleDataTypeFactory(@NonNull OBParser.Treat_data_typeContext treatDataTypeContext) {
        if (treatDataTypeContext == null) {
            throw new NullPointerException("treatDataTypeContext is marked non-null but is null");
        }
        this.parserRuleContext = treatDataTypeContext;
    }

    public OracleDataTypeFactory(@NonNull OBParser.Opt_jt_value_typeContext optJtValueTypeContext) {
        if (optJtValueTypeContext == null) {
            throw new NullPointerException("optJtValueTypeContext is marked non-null but is null");
        }
        this.parserRuleContext = optJtValueTypeContext;
    }

    public OracleDataTypeFactory(@NonNull OBParser.Js_value_return_typeContext jsValueReturnTypeContext) {
        if (jsValueReturnTypeContext == null) {
            throw new NullPointerException("jsValueReturnTypeContext is marked non-null but is null");
        }
        this.parserRuleContext = jsValueReturnTypeContext;
    }

    public OracleDataTypeFactory(@NonNull OBParser.Js_query_return_typeContext jsQueryReturnTypeContext) {
        if (jsQueryReturnTypeContext == null) {
            throw new NullPointerException("jsQueryReturnTypeContext is marked non-null but is null");
        }
        this.parserRuleContext = jsQueryReturnTypeContext;
    }

    public OracleDataTypeFactory(@NonNull OBParser.Js_return_typeContext jsReturnTypeContext) {
        if (jsReturnTypeContext == null) {
            throw new NullPointerException("jsReturnTypeContext is marked non-null but is null");
        }
        this.parserRuleContext = jsReturnTypeContext;
    }

    public OracleDataTypeFactory(@NonNull OBParser.Js_agg_returning_typeContext jsAggReturningTypeContext) {
        if (jsAggReturningTypeContext == null) {
            throw new NullPointerException("jsAggReturningTypeContext is marked non-null but is null");
        }
        this.parserRuleContext = jsAggReturningTypeContext;
    }

    @Override
    public DataType generate() {
        return (DataType)this.visit((ParseTree)this.parserRuleContext);
    }

    @Override
    public DataType visitData_type(OBParser.Data_typeContext ctx) {
        if (ctx.STRING_VALUE() != null || ctx.JSON() != null || ctx.XMLTYPE() != null || ctx.SDO_GEOMETRY() != null) {
            return new GeneralDataType(ctx, ctx.getChild(0).getText(), null);
        }
        if (ctx.character_type_i() != null) {
            CharacterType type = new CharacterType((ParserRuleContext)ctx, (CharacterType)this.visit((ParseTree)ctx.character_type_i()));
            if (ctx.charset_name() != null) {
                type.setCharset(ctx.charset_name().getText());
            }
            if (ctx.collation() != null) {
                type.setCollation(ctx.collation().collation_name().getText());
            }
            return type;
        }
        return (DataType)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public DataType visitOpt_jt_value_type(final OBParser.Opt_jt_value_typeContext ctx) {
        if (ctx.CHAR() != null || ctx.NVARCHAR2() != null || ctx.NCHAR() != null) {
            return OracleDataTypeFactory.getDataType(new TextTypeOpt(){

                @Override
                public ParserRuleContext getCtx() {
                    return ctx;
                }

                @Override
                public String getTypeName() {
                    return ctx.getChild(0).getText();
                }

                @Override
                public OBParser.String_length_iContext getStringLengthIContext() {
                    return ctx.string_length_i();
                }

                @Override
                public OBParser.Nstring_length_iContext getNstringLengthIContext() {
                    return ctx.nstring_length_i();
                }

                @Override
                public boolean isBinary() {
                    return ctx.BINARY() != null;
                }
            });
        }
        return (DataType)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public DataType visitJs_value_return_type(OBParser.Js_value_return_typeContext ctx) {
        if (ctx.NUMBER() != null) {
            return this.getNumberType(ctx.NUMBER().getText(), ctx, ctx.number_precision());
        }
        return (DataType)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public DataType visitJs_query_return_type(OBParser.Js_query_return_typeContext ctx) {
        if (ctx.BLOB() != null || ctx.JSON() != null) {
            return new GeneralDataType(ctx, ctx.getChild(0).getText(), null);
        }
        return (DataType)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public DataType visitJs_agg_returning_type(final OBParser.Js_agg_returning_typeContext ctx) {
        if (ctx.RAW() != null) {
            ArrayList<String> args = new ArrayList<String>();
            if (ctx.zero_suffix_intnum() != null) {
                args.add(ctx.zero_suffix_intnum().getText());
            }
            return new GeneralDataType(ctx, ctx.RAW().getText(), args);
        }
        return OracleDataTypeFactory.getDataType(new TextTypeOpt(){

            @Override
            public ParserRuleContext getCtx() {
                return ctx;
            }

            @Override
            public String getTypeName() {
                return ctx.NVARCHAR2().getText();
            }

            @Override
            public OBParser.String_length_iContext getStringLengthIContext() {
                return null;
            }

            @Override
            public OBParser.Nstring_length_iContext getNstringLengthIContext() {
                return ctx.nstring_length_i();
            }

            @Override
            public boolean isBinary() {
                return false;
            }
        });
    }

    @Override
    public DataType visitJs_return_type(OBParser.Js_return_typeContext ctx) {
        if (ctx.BLOB() != null || ctx.JSON() != null) {
            return new GeneralDataType(ctx, ctx.getChild(0).getText(), null);
        }
        return (DataType)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public DataType visitJs_return_text_type(final OBParser.Js_return_text_typeContext ctx) {
        return OracleDataTypeFactory.getDataType(new TextTypeOpt(){

            @Override
            public ParserRuleContext getCtx() {
                return ctx;
            }

            @Override
            public String getTypeName() {
                return ctx.getChild(0).getText();
            }

            @Override
            public OBParser.String_length_iContext getStringLengthIContext() {
                return ctx.string_length_i();
            }

            @Override
            public OBParser.Nstring_length_iContext getNstringLengthIContext() {
                return null;
            }

            @Override
            public boolean isBinary() {
                return ctx.BINARY() != null;
            }
        });
    }

    @Override
    public DataType visitTreat_data_type(OBParser.Treat_data_typeContext ctx) {
        if (ctx.JSON() != null) {
            return new GeneralDataType(ctx, ctx.JSON().getText(), null);
        }
        return (DataType)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public DataType visitJs_return_default_type(OBParser.Js_return_default_typeContext ctx) {
        return null;
    }

    @Override
    public DataType visitInt_type_i(OBParser.Int_type_iContext ctx) {
        return new NumberType(ctx, ctx.getText(), null, null);
    }

    @Override
    public DataType visitFloat_type_i(OBParser.Float_type_iContext ctx) {
        ArrayList<String> args = new ArrayList<String>();
        if (ctx.data_type_precision() != null) {
            args.add(this.getPrecision(ctx.data_type_precision()));
        }
        BigDecimal first = null;
        BigDecimal second = null;
        if (!args.isEmpty()) {
            first = new BigDecimal((String)args.get(0));
            if (args.size() > 1) {
                second = new BigDecimal((String)args.get(1));
            }
        }
        return new NumberType(ctx, ctx.getChild(0).getText(), first, second);
    }

    @Override
    public DataType visitDouble_type_i(OBParser.Double_type_iContext ctx) {
        return new NumberType(ctx, ctx.getText(), null, null);
    }

    @Override
    public DataType visitNumber_type_i(OBParser.Number_type_iContext ctx) {
        return this.getNumberType(ctx.getChild(0).getText(), ctx, ctx.number_precision());
    }

    @Override
    public DataType visitTimestamp_type_i(OBParser.Timestamp_type_iContext ctx) {
        BigDecimal precision = null;
        if (ctx.data_type_precision() != null) {
            precision = new BigDecimal(this.getPrecision(ctx.data_type_precision()));
        }
        if (ctx.WITH() == null) {
            return new TimestampType(ctx, precision, false, false);
        }
        if (ctx.LOCAL() != null) {
            return new TimestampType(ctx, precision, false, true);
        }
        return new TimestampType(ctx, precision, true, false);
    }

    @Override
    public DataType visitDatetime_type_i(OBParser.Datetime_type_iContext ctx) {
        return new GeneralDataType(ctx, ctx.getText(), null);
    }

    @Override
    public DataType visitCharacter_type_i(final OBParser.Character_type_iContext ctx) {
        return OracleDataTypeFactory.getDataType(new TextTypeOpt(){

            @Override
            public ParserRuleContext getCtx() {
                return ctx;
            }

            @Override
            public String getTypeName() {
                return ctx.getChild(0).getText();
            }

            @Override
            public OBParser.String_length_iContext getStringLengthIContext() {
                return ctx.string_length_i();
            }

            @Override
            public OBParser.Nstring_length_iContext getNstringLengthIContext() {
                return null;
            }

            @Override
            public boolean isBinary() {
                return ctx.BINARY() != null;
            }
        });
    }

    @Override
    public DataType visitBinary_type_i(OBParser.Binary_type_iContext ctx) {
        ArrayList<String> args = new ArrayList<String>();
        if (ctx.zero_suffix_intnum() != null) {
            args.add(ctx.zero_suffix_intnum().getText());
        }
        return new GeneralDataType(ctx, ctx.getChild(0).getText(), args);
    }

    @Override
    public DataType visitInterval_type_i(OBParser.Interval_type_iContext ctx) {
        if (ctx.YEAR() != null) {
            BigDecimal yearPrecision = null;
            if (ctx.year_precision != null) {
                yearPrecision = new BigDecimal(this.getPrecision(ctx.year_precision));
            }
            return new IntervalType((ParserRuleContext)ctx, yearPrecision);
        }
        BigDecimal dayPrecision = null;
        BigDecimal secondPrecision = null;
        if (ctx.day_precision != null) {
            dayPrecision = new BigDecimal(this.getPrecision(ctx.day_precision));
        }
        if (ctx.second_precision != null) {
            secondPrecision = new BigDecimal(this.getPrecision(ctx.second_precision));
        }
        return new IntervalType(ctx, dayPrecision, secondPrecision);
    }

    @Override
    public DataType visitRowid_type_i(OBParser.Rowid_type_iContext ctx) {
        ArrayList<String> args = new ArrayList<String>();
        if (ctx.urowid_length_i() != null) {
            args.add(ctx.urowid_length_i().INTNUM().getText());
        }
        return new GeneralDataType(ctx, ctx.getChild(0).getText(), args);
    }

    @Override
    public DataType visitUdt_type_i(OBParser.Udt_type_iContext ctx) {
        return new GeneralDataType(ctx, ctx.getText(), null);
    }

    private DataType getNumberType(String typeName, ParserRuleContext parent, OBParser.Number_precisionContext numberPrecisionContext) {
        ArrayList<String> args = new ArrayList<String>();
        this.visitNumberPrecision(numberPrecisionContext, args);
        BigDecimal first = null;
        BigDecimal second = null;
        boolean starPrecision = false;
        if (!args.isEmpty()) {
            if (!"*".equals(args.get(0))) {
                first = new BigDecimal((String)args.get(0));
            } else {
                starPrecision = true;
            }
            if (args.size() > 1) {
                second = new BigDecimal((String)args.get(1));
            }
        }
        NumberType numberType = new NumberType(parent, typeName, first, second);
        if (starPrecision) {
            numberType.setStarPresicion(true);
        }
        return numberType;
    }

    private void visitNumberPrecision(OBParser.Number_precisionContext ctx, List<String> args) {
        if (ctx == null) {
            return;
        }
        if (ctx.precision_decimal_num() != null) {
            args.add(ctx.precision_decimal_num().getText());
        } else {
            if (ctx.Star() != null) {
                args.add(ctx.Star().getText());
            }
            if (CollectionUtils.isNotEmpty(ctx.signed_int_num())) {
                ctx.signed_int_num().forEach(s -> args.add(s.getText()));
            }
        }
    }

    private static void visitStringLengthI(OBParser.String_length_iContext ctx, List<String> args) {
        if (ctx == null) {
            return;
        }
        StringBuilder builder = new StringBuilder(ctx.zero_suffix_intnum().getText());
        if (ctx.CHARACTER() != null || ctx.CHAR() != null || ctx.BYTE() != null) {
            builder.append(" ").append(ctx.getChild(2).getText());
        }
        args.add(builder.toString());
    }

    private static void visitNstringLengthI(OBParser.Nstring_length_iContext ctx, List<String> args) {
        if (ctx == null) {
            return;
        }
        args.add(ctx.zero_suffix_intnum().getText());
    }

    private String getPrecision(OBParser.Data_type_precisionContext context) {
        if (context.precision_int_num() != null) {
            return context.precision_int_num().getText();
        }
        return context.precision_decimal_num().getText();
    }

    public static DataType getDataType(TextTypeOpt opt) {
        CharacterType type;
        ArrayList<String> args = new ArrayList<String>();
        OracleDataTypeFactory.visitStringLengthI(opt.getStringLengthIContext(), args);
        OracleDataTypeFactory.visitNstringLengthI(opt.getNstringLengthIContext(), args);
        if (args.isEmpty()) {
            type = new CharacterType(opt.getCtx(), opt.getTypeName(), null);
        } else {
            String[] arg = ((String)args.get(0)).split(" ");
            type = new CharacterType(opt.getCtx(), opt.getTypeName(), new BigDecimal(arg[0]));
            if (arg.length > 1) {
                type.setLengthOption(arg[1]);
            }
        }
        if (opt.isBinary()) {
            type.setBinary(true);
        }
        return type;
    }

    static interface TextTypeOpt {
        public ParserRuleContext getCtx();

        public String getTypeName();

        public OBParser.String_length_iContext getStringLengthIContext();

        public OBParser.Nstring_length_iContext getNstringLengthIContext();

        public boolean isBinary();
    }
}

