/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.oracle;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleColumnRefFactory;
import com.oceanbase.tools.sqlparser.oboracle.OBParser;
import com.oceanbase.tools.sqlparser.oboracle.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.expression.ColumnReference;
import com.oceanbase.tools.sqlparser.statement.select.ForUpdate;
import com.oceanbase.tools.sqlparser.statement.select.WaitOption;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.tree.ParseTree;

public class OracleForUpdateFactory
extends OBParserBaseVisitor<ForUpdate>
implements StatementFactory<ForUpdate> {
    private final OBParser.For_updateContext forUpdateContext;

    public OracleForUpdateFactory(@NonNull OBParser.For_updateContext forUpdateContext) {
        if (forUpdateContext == null) {
            throw new NullPointerException("forUpdateContext is marked non-null but is null");
        }
        this.forUpdateContext = forUpdateContext;
    }

    @Override
    public ForUpdate generate() {
        return (ForUpdate)this.visit((ParseTree)this.forUpdateContext);
    }

    @Override
    public ForUpdate visitFor_update(OBParser.For_updateContext ctx) {
        ArrayList<ColumnReference> columnDefRefs = new ArrayList();
        if (ctx.column_list() != null) {
            columnDefRefs = ctx.column_list().column_definition_ref().stream().map(c -> {
                OracleColumnRefFactory factory = new OracleColumnRefFactory((OBParser.Column_definition_refContext)((Object)c));
                return (ColumnReference)factory.generate();
            }).collect(Collectors.toList());
        }
        WaitOption waitOption = null;
        BigDecimal waitNum = null;
        if (ctx.WAIT() != null) {
            waitOption = WaitOption.WAIT;
            waitNum = new BigDecimal(ctx.INTNUM().getText());
        } else if (ctx.NOWAIT() != null) {
            waitOption = WaitOption.NOWAIT;
        } else if (ctx.R_SKIP() != null) {
            waitOption = WaitOption.SKIP_LOCKED;
        }
        return new ForUpdate(ctx, columnDefRefs, waitOption, waitNum);
    }
}

