/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.oracle;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleColumnRefFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleExpressionFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleFetchFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleOrderByFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OraclePartitionUsageFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleSelectBodyFactory;
import com.oceanbase.tools.sqlparser.oboracle.OBParser;
import com.oceanbase.tools.sqlparser.oboracle.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.JoinType;
import com.oceanbase.tools.sqlparser.statement.common.RelationFactor;
import com.oceanbase.tools.sqlparser.statement.expression.ColumnReference;
import com.oceanbase.tools.sqlparser.statement.expression.FunctionCall;
import com.oceanbase.tools.sqlparser.statement.expression.RelationReference;
import com.oceanbase.tools.sqlparser.statement.select.ExpressionReference;
import com.oceanbase.tools.sqlparser.statement.select.FlashBackType;
import com.oceanbase.tools.sqlparser.statement.select.FlashbackUsage;
import com.oceanbase.tools.sqlparser.statement.select.FromReference;
import com.oceanbase.tools.sqlparser.statement.select.JoinCondition;
import com.oceanbase.tools.sqlparser.statement.select.JoinReference;
import com.oceanbase.tools.sqlparser.statement.select.NameReference;
import com.oceanbase.tools.sqlparser.statement.select.OnJoinCondition;
import com.oceanbase.tools.sqlparser.statement.select.SelectBody;
import com.oceanbase.tools.sqlparser.statement.select.UsingJoinCondition;
import com.oceanbase.tools.sqlparser.statement.select.oracle.Pivot;
import com.oceanbase.tools.sqlparser.statement.select.oracle.UnPivot;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class OracleFromReferenceFactory
extends OBParserBaseVisitor<FromReference>
implements StatementFactory<FromReference> {
    private OBParser.Table_referenceContext tableReferenceContext;
    private OBParser.Table_factorContext tableFactorContext;

    public OracleFromReferenceFactory(@NonNull OBParser.Table_referenceContext tableReferenceContext) {
        if (tableReferenceContext == null) {
            throw new NullPointerException("tableReferenceContext is marked non-null but is null");
        }
        this.tableReferenceContext = tableReferenceContext;
    }

    public OracleFromReferenceFactory(@NonNull OBParser.Table_factorContext tableFactorContext) {
        if (tableFactorContext == null) {
            throw new NullPointerException("tableFactorContext is marked non-null but is null");
        }
        this.tableFactorContext = tableFactorContext;
    }

    @Override
    public FromReference generate() {
        if (this.tableReferenceContext != null) {
            return (FromReference)this.visit((ParseTree)this.tableReferenceContext);
        }
        return (FromReference)this.visit((ParseTree)this.tableFactorContext);
    }

    @Override
    public FromReference visitTable_reference(OBParser.Table_referenceContext ctx) {
        if (ctx.table_factor() != null) {
            return (FromReference)this.visit((ParseTree)ctx.table_factor());
        }
        return (FromReference)this.visit((ParseTree)ctx.joined_table());
    }

    @Override
    public FromReference visitJoined_table(OBParser.Joined_tableContext ctx) {
        FromReference right;
        FromReference left;
        JoinType joinType;
        if (ctx.outer_join_type() != null) {
            joinType = this.getOuterJoinType(ctx.outer_join_type());
        } else if (ctx.INNER() != null) {
            joinType = JoinType.INNER_JOIN;
        } else if (ctx.CROSS() != null) {
            joinType = JoinType.CROSS_JOIN;
        } else if (ctx.natural_join_type() != null) {
            OBParser.Natural_join_typeContext naturalJoinType = ctx.natural_join_type();
            if (naturalJoinType.INNER() != null) {
                joinType = JoinType.NATURAL_INNER_JOIN;
            } else if (naturalJoinType.outer_join_type() != null) {
                JoinType outerJ = this.getOuterJoinType(naturalJoinType.outer_join_type());
                joinType = JoinType.valueOf("NATURAL_" + outerJ.name().toUpperCase());
            } else {
                joinType = JoinType.NATURAL_JOIN;
            }
        } else {
            joinType = JoinType.JOIN;
        }
        List<OBParser.Table_factorContext> tableFactors = ctx.table_factor();
        if (tableFactors.size() == 2) {
            left = (FromReference)this.visit((ParseTree)tableFactors.get(0));
            right = (FromReference)this.visit((ParseTree)tableFactors.get(1));
        } else {
            left = (FromReference)this.visit((ParseTree)ctx.joined_table());
            right = (FromReference)this.visit((ParseTree)tableFactors.get(0));
        }
        JoinCondition condition = null;
        OBParser.Join_conditionContext joinCondition = ctx.join_condition();
        if (joinCondition != null) {
            condition = joinCondition.ON() != null ? this.getFromOnExpr(joinCondition.expr(), joinCondition) : this.getFromUsingColumnList(joinCondition.column_list(), joinCondition);
        } else if (ctx.ON() != null) {
            condition = this.getFromOnExpr(ctx.expr(), null);
        } else if (ctx.USING() != null) {
            condition = this.getFromUsingColumnList(ctx.column_list(), null);
        }
        return new JoinReference(ctx, left, right, joinType, condition);
    }

    @Override
    public FromReference visitTable_factor(OBParser.Table_factorContext ctx) {
        String alias = null;
        if (ctx.relation_name() != null) {
            alias = ctx.relation_name().getText();
        }
        if (ctx.tbl_name() != null) {
            return (FromReference)this.visit((ParseTree)ctx.tbl_name());
        }
        if (ctx.table_subquery() != null) {
            return (FromReference)this.visit((ParseTree)ctx.table_subquery());
        }
        if (ctx.table_reference() != null) {
            return (FromReference)this.visit((ParseTree)ctx.table_reference());
        }
        if (ctx.simple_expr() != null) {
            return new ExpressionReference(ctx, new OracleExpressionFactory(ctx.simple_expr()).generate(), alias);
        }
        if (ctx.select_function() != null) {
            return new ExpressionReference(ctx, this.visitSelectFunction(ctx.select_function()), alias);
        }
        if (ctx.json_table_expr() != null) {
            return new ExpressionReference(ctx, new OracleExpressionFactory().visitJson_table_expr(ctx.json_table_expr()), alias);
        }
        return new ExpressionReference(ctx, new OracleExpressionFactory().visitXml_table_expr(ctx.xml_table_expr()), alias);
    }

    private Expression visitSelectFunction(OBParser.Select_functionContext ctx) {
        if (ctx.access_func_expr() != null) {
            return new OracleExpressionFactory().getFunctionCall(ctx.access_func_expr());
        }
        RelationReference ref = new RelationReference((ParserRuleContext)ctx.database_factor(), ctx.database_factor().getText());
        ref.reference(this.visitSelectFunction(ctx.select_function()), Expression.ReferenceOperator.DOT);
        return ref;
    }

    @Override
    public FromReference visitTable_subquery(OBParser.Table_subqueryContext ctx) {
        String alias = null;
        if (ctx.relation_name() != null) {
            alias = ctx.relation_name().getText();
        }
        if (ctx.select_with_parens() != null) {
            OracleSelectBodyFactory factory = new OracleSelectBodyFactory(ctx.select_with_parens());
            ExpressionReference reference = new ExpressionReference(ctx, factory.generate(), alias);
            if (ctx.use_flashback() != null) {
                reference.setFlashbackUsage(this.visitFlashbackUsage(ctx.use_flashback()));
            }
            reference.setUnPivot(this.visitUnPivot(ctx.transpose_clause()));
            reference.setPivot(this.visitPivot(ctx.transpose_clause()));
            return reference;
        }
        OracleSelectBodyFactory factory = new OracleSelectBodyFactory(ctx.subquery());
        SelectBody select = factory.generate();
        OBParser.Order_by_fetch_with_check_optionContext oCtx = ctx.order_by_fetch_with_check_option();
        if (oCtx.order_by() != null) {
            select.getLastSelectBody().setOrderBy(new OracleOrderByFactory(oCtx.order_by()).generate());
        }
        if (oCtx.fetch_next_clause() != null) {
            select.getLastSelectBody().setFetch(new OracleFetchFactory(oCtx.fetch_next_clause()).generate());
        }
        if (oCtx.with_check_option() != null) {
            select.getLastSelectBody().setWithCheckOption(true);
        }
        ExpressionReference reference = new ExpressionReference(ctx, select, alias);
        if (ctx.use_flashback() != null) {
            reference.setFlashbackUsage(this.visitFlashbackUsage(ctx.use_flashback()));
        }
        reference.setUnPivot(this.visitUnPivot(ctx.transpose_clause()));
        reference.setPivot(this.visitPivot(ctx.transpose_clause()));
        return reference;
    }

    @Override
    public FromReference visitTbl_name(OBParser.Tbl_nameContext ctx) {
        if (ctx.dual_table() != null) {
            String alias = ctx.relation_name() == null ? null : ctx.relation_name().getText();
            return new NameReference(ctx, null, ctx.dual_table().DUAL().getText(), alias);
        }
        OBParser.Relation_factorContext relationFactor = ctx.relation_factor();
        String alias = null;
        if (ctx.relation_name() != null) {
            alias = ctx.relation_name().getText();
        }
        NameReference nameReference = new NameReference(ctx, OracleFromReferenceFactory.getSchemaName(relationFactor), OracleFromReferenceFactory.getRelation(relationFactor), alias);
        if (ctx.use_partition() != null) {
            OraclePartitionUsageFactory factory = new OraclePartitionUsageFactory(ctx.use_partition());
            nameReference.setPartitionUsage(factory.generate());
        }
        if (ctx.use_flashback() != null) {
            nameReference.setFlashbackUsage(this.visitFlashbackUsage(ctx.use_flashback()));
        }
        nameReference.setPivot(this.visitPivot(ctx.transpose_clause()));
        nameReference.setUnPivot(this.visitUnPivot(ctx.transpose_clause()));
        nameReference.setUserVariable(OracleFromReferenceFactory.getUserVariable(relationFactor));
        return nameReference;
    }

    public static String getSchemaName(OBParser.Relation_factorContext relationFactor) {
        if (relationFactor == null || relationFactor.normal_relation_factor() == null) {
            return null;
        }
        return OracleFromReferenceFactory.getSchemaName(relationFactor.normal_relation_factor());
    }

    public static String getRelation(OBParser.Relation_factorContext relationFactor) {
        if (relationFactor == null) {
            return null;
        }
        if (relationFactor.normal_relation_factor() != null) {
            return OracleFromReferenceFactory.getRelation(relationFactor.normal_relation_factor());
        }
        if (relationFactor.dot_relation_factor() != null) {
            return relationFactor.dot_relation_factor().relation_name().getText();
        }
        return null;
    }

    public static String getUserVariable(OBParser.Relation_factorContext relationFactor) {
        if (relationFactor == null || relationFactor.normal_relation_factor() == null) {
            return null;
        }
        return OracleFromReferenceFactory.getUserVariable(relationFactor.normal_relation_factor());
    }

    public static RelationFactor getRelationFactor(OBParser.Normal_relation_factorContext ctx) {
        RelationFactor relationFactor = new RelationFactor((ParserRuleContext)ctx, OracleFromReferenceFactory.getRelation(ctx));
        relationFactor.setSchema(OracleFromReferenceFactory.getSchemaName(ctx));
        relationFactor.setUserVariable(OracleFromReferenceFactory.getUserVariable(ctx));
        if (ctx.opt_reverse_link_flag() != null && ctx.opt_reverse_link_flag().Not() != null) {
            relationFactor.setReverseLink(true);
        }
        return relationFactor;
    }

    public static RelationFactor getRelationFactor(OBParser.Relation_factorContext ctx) {
        RelationFactor relationFactor = new RelationFactor((ParserRuleContext)ctx, OracleFromReferenceFactory.getRelation(ctx));
        relationFactor.setSchema(OracleFromReferenceFactory.getSchemaName(ctx));
        relationFactor.setUserVariable(OracleFromReferenceFactory.getUserVariable(ctx));
        if (ctx.normal_relation_factor() != null && ctx.normal_relation_factor().opt_reverse_link_flag() != null && ctx.normal_relation_factor().opt_reverse_link_flag().Not() != null) {
            relationFactor.setReverseLink(true);
        }
        return relationFactor;
    }

    public static String getSchemaName(OBParser.Normal_relation_factorContext ctx) {
        return ctx.database_factor() != null ? ctx.database_factor().relation_name().getText() : null;
    }

    public static String getRelation(OBParser.Normal_relation_factorContext ctx) {
        return ctx.relation_name().getText();
    }

    public static String getUserVariable(OBParser.Normal_relation_factorContext ctx) {
        return ctx.USER_VARIABLE() != null ? ctx.USER_VARIABLE().getText() : null;
    }

    private Pivot visitPivot(OBParser.Transpose_clauseContext ctx) {
        if (ctx == null || ctx.PIVOT() == null) {
            return null;
        }
        OBParser.Pivot_aggr_clauseContext aggrContext = ctx.pivot_aggr_clause();
        List<Pivot.FunctionItem> functionItems = aggrContext.pivot_single_aggr_clause().stream().map(c -> {
            OracleExpressionFactory factory = new OracleExpressionFactory();
            Expression fCall = c.aggregate_function() != null ? factory.visitAggregate_function(c.aggregate_function()) : factory.visitAccess_func_expr_count(c.access_func_expr_count());
            String alias = c.relation_name() == null ? null : c.relation_name().getText();
            return new Pivot.FunctionItem((ParserRuleContext)c, (FunctionCall)fCall, alias);
        }).collect(Collectors.toList());
        ArrayList<ColumnReference> forColumns = new ArrayList<ColumnReference>();
        OBParser.Transpose_for_clauseContext forClause = ctx.transpose_for_clause();
        if (forClause.column_name() != null) {
            forColumns.add(new ColumnReference(forClause.column_name(), null, null, forClause.column_name().getText()));
        } else {
            forColumns = forClause.column_name_list().column_name().stream().map(c -> new ColumnReference((ParserRuleContext)c, null, null, c.getText())).collect(Collectors.toList());
        }
        OBParser.Transpose_in_clauseContext inClause = ctx.transpose_in_clause();
        List<Pivot.ExpressionItem> expressionItems = inClause.transpose_in_args().transpose_in_arg().stream().map(c -> {
            String alias = c.relation_name() == null ? null : c.relation_name().getText();
            return new Pivot.ExpressionItem((ParserRuleContext)c, new OracleExpressionFactory(c.bit_expr()).generate(), alias);
        }).collect(Collectors.toList());
        Pivot pivot = new Pivot(ctx, functionItems, forColumns, expressionItems);
        if (ctx.relation_name() != null) {
            pivot.setAlias(ctx.relation_name().getText());
        }
        return pivot;
    }

    private UnPivot visitUnPivot(OBParser.Transpose_clauseContext ctx) {
        if (ctx == null || ctx.UNPIVOT() == null) {
            return null;
        }
        boolean includeNulls = ctx.INCLUDE() != null;
        OBParser.Unpivot_column_clauseContext clauseContext = ctx.unpivot_column_clause();
        ArrayList<ColumnReference> unpivotColumns = new ArrayList<ColumnReference>();
        if (clauseContext.column_name() != null) {
            unpivotColumns.add(new ColumnReference(clauseContext.column_name(), null, null, clauseContext.column_name().getText()));
        } else {
            unpivotColumns = clauseContext.column_name_list().column_name().stream().map(c -> new ColumnReference((ParserRuleContext)c, null, null, c.getText())).collect(Collectors.toList());
        }
        ArrayList<ColumnReference> forColumns = new ArrayList<ColumnReference>();
        OBParser.Transpose_for_clauseContext forClauseContext = ctx.transpose_for_clause();
        if (forClauseContext.column_name() != null) {
            forColumns.add(new ColumnReference(forClauseContext.column_name(), null, null, forClauseContext.column_name().getText()));
        } else {
            forColumns = forClauseContext.column_name_list().column_name().stream().map(c -> new ColumnReference((ParserRuleContext)c, null, null, c.getText())).collect(Collectors.toList());
        }
        OBParser.Unpivot_in_clauseContext inClauseContext = ctx.unpivot_in_clause();
        List<UnPivot.InItem> inItems = inClauseContext.unpivot_in_args().unpivot_in_arg().stream().map(c -> {
            ArrayList<ColumnReference> columns = new ArrayList<ColumnReference>();
            OBParser.Unpivot_column_clauseContext c1 = c.unpivot_column_clause();
            if (c1.column_name() != null) {
                columns.add(new ColumnReference(c1.column_name(), null, null, c1.column_name().getText()));
            } else {
                columns = c1.column_name_list().column_name().stream().map(c2 -> new ColumnReference((ParserRuleContext)c2, null, null, c2.getText())).collect(Collectors.toList());
            }
            Expression as = null;
            if (c.bit_expr() != null) {
                OracleExpressionFactory factory = new OracleExpressionFactory(c.bit_expr());
                as = (Expression)factory.generate();
            }
            return new UnPivot.InItem((ParserRuleContext)c, (List<ColumnReference>)columns, as);
        }).collect(Collectors.toList());
        UnPivot unPivot = new UnPivot(ctx, includeNulls, unpivotColumns, forColumns, inItems);
        if (ctx.relation_name() != null) {
            unPivot.setAlias(ctx.relation_name().getText());
        }
        return unPivot;
    }

    private FlashbackUsage visitFlashbackUsage(OBParser.Use_flashbackContext ctx) {
        OracleExpressionFactory factory = new OracleExpressionFactory(ctx.bit_expr());
        FlashBackType type = FlashBackType.AS_OF_SCN;
        if (ctx.TIMESTAMP() != null) {
            type = FlashBackType.AS_OF_TIMESTAMP;
        }
        return new FlashbackUsage(ctx, type, factory.generate());
    }

    private JoinCondition getFromOnExpr(OBParser.ExprContext exprContext, ParserRuleContext parent) {
        OracleExpressionFactory factory = new OracleExpressionFactory(exprContext);
        return new OnJoinCondition((ParserRuleContext)(parent == null ? exprContext : parent), (Expression)factory.generate());
    }

    private JoinCondition getFromUsingColumnList(OBParser.Column_listContext columnCtxList, ParserRuleContext parent) {
        List<ColumnReference> columnList = columnCtxList.column_definition_ref().stream().map(child -> {
            OracleColumnRefFactory factory = new OracleColumnRefFactory((OBParser.Column_definition_refContext)((Object)child));
            return factory.generate();
        }).collect(Collectors.toList());
        return new UsingJoinCondition((ParserRuleContext)(parent == null ? columnCtxList : parent), columnList);
    }

    private JoinType getOuterJoinType(OBParser.Outer_join_typeContext outerJoinType) {
        boolean outer;
        OBParser.Join_outerContext joinOuter = outerJoinType.join_outer();
        boolean bl = outer = joinOuter != null && joinOuter.OUTER() != null;
        if (outerJoinType.FULL() != null) {
            return outer ? JoinType.FULL_OUTER_JOIN : JoinType.FULL_JOIN;
        }
        if (outerJoinType.LEFT() != null) {
            return outer ? JoinType.LEFT_OUTER_JOIN : JoinType.LEFT_JOIN;
        }
        if (outerJoinType.RIGHT() != null) {
            return outer ? JoinType.RIGHT_OUTER_JOIN : JoinType.RIGHT_JOIN;
        }
        throw new IllegalStateException("Illegal context, " + outerJoinType.getText());
    }
}

