/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.oracle;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleColumnRefFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleExpressionFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleFetchFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleFromReferenceFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleLogErrorsFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleOrderByFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OraclePartitionUsageFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleReturningFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleSelectBodyFactory;
import com.oceanbase.tools.sqlparser.oboracle.OBParser;
import com.oceanbase.tools.sqlparser.oboracle.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.expression.ConstExpression;
import com.oceanbase.tools.sqlparser.statement.insert.ConditionalInsert;
import com.oceanbase.tools.sqlparser.statement.insert.Insert;
import com.oceanbase.tools.sqlparser.statement.insert.InsertCondition;
import com.oceanbase.tools.sqlparser.statement.insert.InsertTable;
import com.oceanbase.tools.sqlparser.statement.select.Select;
import com.oceanbase.tools.sqlparser.statement.select.SelectBody;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class OracleInsertFactory
extends OBParserBaseVisitor<Insert>
implements StatementFactory<Insert> {
    private final OBParser.Insert_stmtContext insertStmtContext;

    public OracleInsertFactory(@NonNull OBParser.Insert_stmtContext insertStmtContext) {
        if (insertStmtContext == null) {
            throw new NullPointerException("insertStmtContext is marked non-null but is null");
        }
        this.insertStmtContext = insertStmtContext;
    }

    @Override
    public Insert generate() {
        return (Insert)this.visit((ParseTree)this.insertStmtContext);
    }

    @Override
    public Insert visitInsert_stmt(OBParser.Insert_stmtContext ctx) {
        if (ctx.single_table_insert() != null) {
            return new Insert((ParserRuleContext)ctx, (Insert)this.visit((ParseTree)ctx.single_table_insert()));
        }
        return new Insert((ParserRuleContext)ctx, (Insert)this.visit((ParseTree)ctx.multi_table_insert()));
    }

    @Override
    public Insert visitMulti_table_insert(OBParser.Multi_table_insertContext ctx) {
        Insert insert;
        if (ctx.insert_table_clause_list() != null) {
            insert = new Insert((ParserRuleContext)ctx, (Insert)this.visit((ParseTree)ctx.insert_table_clause_list()));
            insert.setAll(true);
        } else {
            insert = new Insert((ParserRuleContext)ctx, (Insert)this.visit((ParseTree)ctx.conditional_insert_clause()));
        }
        Select select = new Select((ParserRuleContext)ctx.subquery(), new OracleSelectBodyFactory(ctx.subquery()).generate());
        if (ctx.order_by() != null) {
            select.setOrderBy(new OracleOrderByFactory(ctx.order_by()).generate());
        }
        if (ctx.fetch_next_clause() != null) {
            select.setFetch(new OracleFetchFactory(ctx.fetch_next_clause()).generate());
        }
        insert.setSelect(select);
        return insert;
    }

    @Override
    public Insert visitInsert_table_clause_list(OBParser.Insert_table_clause_listContext ctx) {
        List<InsertTable> insertTables = ctx.insert_single_table_clause().stream().map(this::getInsertTable).collect(Collectors.toList());
        return new Insert(ctx, insertTables, null);
    }

    @Override
    public Insert visitConditional_insert_clause(OBParser.Conditional_insert_clauseContext ctx) {
        ConditionalInsert conditionalInsert;
        List<InsertCondition> insertConditions = ctx.condition_insert_clause_list().condition_insert_clause().stream().map(this::getInsertCondition).collect(Collectors.toList());
        if (ctx.insert_table_clause_list() != null) {
            conditionalInsert = new ConditionalInsert(ctx.condition_insert_clause_list(), ctx.insert_table_clause_list(), insertConditions);
            conditionalInsert.setElseClause(ctx.insert_table_clause_list().insert_single_table_clause().stream().map(this::getInsertTable).collect(Collectors.toList()));
        } else {
            conditionalInsert = new ConditionalInsert((ParserRuleContext)ctx.condition_insert_clause_list(), insertConditions);
        }
        Insert insert = new Insert(ctx, Collections.emptyList(), conditionalInsert);
        if (ctx.ALL() != null) {
            insert.setAll(true);
        } else if (ctx.FIRST() != null) {
            insert.setFirst(true);
        }
        return insert;
    }

    @Override
    public Insert visitSingle_table_insert(OBParser.Single_table_insertContext ctx) {
        InsertTable insertTable;
        OBParser.Insert_table_clauseContext iCtx = ctx.insert_table_clause();
        if (iCtx.dml_table_name() != null) {
            OBParser.Dml_table_nameContext dCtx = iCtx.dml_table_name();
            insertTable = new InsertTable(ctx.INTO(), (ParserRuleContext)ctx.values_clause(), OracleFromReferenceFactory.getRelationFactor(dCtx.relation_factor()));
            if (dCtx.use_partition() != null) {
                insertTable.setPartitionUsage(new OraclePartitionUsageFactory(dCtx.use_partition()).generate());
            }
        } else if (iCtx.select_with_parens() != null) {
            insertTable = new InsertTable(ctx.INTO(), (ParserRuleContext)ctx.values_clause(), new OracleSelectBodyFactory(iCtx.select_with_parens()).generate());
        } else {
            OracleSelectBodyFactory factory = new OracleSelectBodyFactory(iCtx.subquery());
            SelectBody select = factory.generate();
            OBParser.Order_by_fetch_with_check_optionContext oCtx = iCtx.order_by_fetch_with_check_option();
            if (oCtx.order_by() != null) {
                select.getLastSelectBody().setOrderBy(new OracleOrderByFactory(oCtx.order_by()).generate());
            }
            if (oCtx.fetch_next_clause() != null) {
                select.getLastSelectBody().setFetch(new OracleFetchFactory(oCtx.fetch_next_clause()).generate());
            }
            if (oCtx.with_check_option() != null) {
                select.getLastSelectBody().setWithCheckOption(true);
            }
            insertTable = new InsertTable(ctx.INTO(), (ParserRuleContext)ctx.values_clause(), select);
        }
        if (iCtx.relation_name() != null) {
            insertTable.setAlias(iCtx.relation_name().getText());
        }
        if (ctx.NOLOGGING() != null) {
            insertTable.setNologging(true);
        }
        if (ctx.column_list() != null) {
            insertTable.setColumns(ctx.column_list().column_definition_ref().stream().map(c -> new OracleColumnRefFactory((OBParser.Column_definition_refContext)((Object)c)).generate()).collect(Collectors.toList()));
        }
        OBParser.Values_clauseContext vCtx = ctx.values_clause();
        ArrayList<List<Expression>> values = new ArrayList<List<Expression>>();
        if (vCtx.insert_vals_list() != null) {
            this.fullFillValues(vCtx.insert_vals_list(), values);
        } else if (vCtx.obj_access_ref_normal() != null) {
            values.add(Collections.singletonList(new OracleExpressionFactory().visit((ParseTree)vCtx.obj_access_ref_normal())));
        } else {
            Select select = new Select((ParserRuleContext)vCtx.subquery(), new OracleSelectBodyFactory(vCtx.subquery()).generate());
            if (vCtx.order_by() != null) {
                select.setOrderBy(new OracleOrderByFactory(vCtx.order_by()).generate());
            }
            if (vCtx.fetch_next_clause() != null) {
                select.setFetch(new OracleFetchFactory(vCtx.fetch_next_clause()).generate());
            }
            values.add(Collections.singletonList(select));
        }
        insertTable.setValues(values);
        Insert insert = new Insert(ctx, Collections.singletonList(insertTable), null);
        if (ctx.returning_log_error_clause() != null) {
            OBParser.Returning_log_error_clauseContext rCtx = ctx.returning_log_error_clause();
            if (rCtx.returning_clause() != null) {
                insert.setReturning(new OracleReturningFactory(rCtx.returning_clause()).generate());
            }
            if (rCtx.log_error_clause() != null) {
                insert.setLogErrors(new OracleLogErrorsFactory(rCtx.log_error_clause()).generate());
            }
        }
        return insert;
    }

    private void fullFillValues(OBParser.Insert_vals_listContext ctx, List<List<Expression>> values) {
        if (ctx.insert_vals_list() != null) {
            this.fullFillValues(ctx.insert_vals_list(), values);
        }
        values.add(ctx.insert_vals().expr_or_default().stream().map(c -> {
            if (c.DEFAULT() != null) {
                return new ConstExpression(c.DEFAULT());
            }
            return new OracleExpressionFactory(c.bit_expr()).generate();
        }).collect(Collectors.toList()));
    }

    private InsertTable getInsertTable(OBParser.Insert_single_table_clauseContext ctx) {
        OBParser.Dml_table_nameContext dCtx = ctx.dml_table_name();
        InsertTable insertTable = new InsertTable((ParserRuleContext)ctx, OracleFromReferenceFactory.getRelationFactor(dCtx.relation_factor()));
        if (dCtx.use_partition() != null) {
            insertTable.setPartitionUsage(new OraclePartitionUsageFactory(dCtx.use_partition()).generate());
        }
        if (ctx.column_list() != null) {
            insertTable.setColumns(ctx.column_list().column_definition_ref().stream().map(c -> new OracleColumnRefFactory((OBParser.Column_definition_refContext)((Object)c)).generate()).collect(Collectors.toList()));
        }
        if (ctx.insert_vals() != null) {
            ArrayList<List<Expression>> values = new ArrayList<List<Expression>>();
            values.add(ctx.insert_vals().expr_or_default().stream().map(c -> {
                if (c.DEFAULT() != null) {
                    return new ConstExpression(c.DEFAULT());
                }
                return new OracleExpressionFactory(c.bit_expr()).generate();
            }).collect(Collectors.toList()));
            insertTable.setValues(values);
        }
        return insertTable;
    }

    private InsertCondition getInsertCondition(OBParser.Condition_insert_clauseContext ctx) {
        List<InsertTable> insertTables = ctx.insert_table_clause_list().insert_single_table_clause().stream().map(this::getInsertTable).collect(Collectors.toList());
        return new InsertCondition(ctx, new OracleExpressionFactory(ctx.expr()).generate(), insertTables);
    }
}

