/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.oracle;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleExpressionFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleFromReferenceFactory;
import com.oceanbase.tools.sqlparser.oboracle.OBParser;
import com.oceanbase.tools.sqlparser.oboracle.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.common.oracle.LogErrors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class OracleLogErrorsFactory
extends OBParserBaseVisitor<LogErrors>
implements StatementFactory<LogErrors> {
    private final ParserRuleContext context;

    public OracleLogErrorsFactory(@NonNull OBParser.Log_error_clauseContext clauseContext) {
        if (clauseContext == null) {
            throw new NullPointerException("clauseContext is marked non-null but is null");
        }
        this.context = clauseContext;
    }

    @Override
    public LogErrors generate() {
        return (LogErrors)this.visit((ParseTree)this.context);
    }

    @Override
    public LogErrors visitLog_error_clause(OBParser.Log_error_clauseContext ctx) {
        LogErrors logErrors = new LogErrors(ctx);
        if (ctx.into_err_log_caluse().relation_factor() != null) {
            logErrors.setInto(OracleFromReferenceFactory.getRelationFactor(ctx.into_err_log_caluse().relation_factor()));
        }
        if (ctx.opt_simple_expression().simple_expr() != null) {
            logErrors.setExpression(new OracleExpressionFactory(ctx.opt_simple_expression().simple_expr()).generate());
        }
        if (ctx.reject_limit().REJECT() != null) {
            OBParser.Reject_limitContext rCtx = ctx.reject_limit();
            if (rCtx.INTNUM() != null) {
                logErrors.setUnlimitedReject(false);
                logErrors.setRejectLimit(Integer.valueOf(rCtx.INTNUM().getText()));
            } else {
                logErrors.setRejectLimit(null);
                logErrors.setUnlimitedReject(true);
            }
        }
        return logErrors;
    }
}

